from spark_auto_mapper.automappers.automapper_with_column_base import AutoMapperWithColumnBase
from spark_auto_mapper.data_types.automapper_defined_types import AutoMapperAnyDataType


class AutoMapperWithColumn(AutoMapperWithColumnBase):
    # This class is just a helper that allows us to pass the parameters in the form dst_column=value
    def __init__(self,
                 **kwargs: AutoMapperAnyDataType
                 ) -> None:
        assert len(kwargs) == 1, kwargs
        dst_column: str = list(kwargs.keys())[0]
        value = kwargs[dst_column]
        super().__init__(dst_column=dst_column, value=value)
