"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineAnchoreInlineScanAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codebuild_1 = require("@aws-cdk/aws-codebuild");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
class CodePipelineAnchoreInlineScanAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.TEST,
            provider: 'CodeBuild',
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.input],
        });
        this.props = props;
    }
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     */
    bound(scope, _stage, options) {
        var _b, _c, _d;
        const { account, region } = core_1.Stack.of(scope);
        const buildImage = aws_codebuild_1.LinuxBuildImage.STANDARD_4_0;
        const version = (_b = this.props.version) !== null && _b !== void 0 ? _b : 'v0.8.2';
        const timeout = (_c = this.props.timeout) !== null && _c !== void 0 ? _c : 300;
        const policyBundlePath = (_d = this.props.policyBundlePath) !== null && _d !== void 0 ? _d : './policy_bundle.json';
        const url = `https://ci-tools.anchore.io/inline_scan-${version}`;
        const project = new aws_codebuild_1.PipelineProject(scope, 'VulnScanProject', {
            cache: aws_codebuild_1.Cache.local(aws_codebuild_1.LocalCacheMode.DOCKER_LAYER),
            role: this.props.projectRole,
            environment: {
                buildImage,
                computeType: this.props.computeType || buildImage.defaultComputeType,
                privileged: true,
            },
            environmentVariables: this.props.customAnchoreImage
                ? {
                    ANCHORE_CI_IMAGE: {
                        value: this.props.customAnchoreImage,
                    },
                }
                : undefined,
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    pre_build: {
                        commands: [
                            'echo Build started on `date`',
                            'docker build -t image2scan:ci .',
                            'echo Build completed on `date`',
                            this.props.ecrLogin &&
                                `aws ecr get-login-password | docker login --username AWS --password-stdin ${account}.dkr.ecr.${region}.amazonaws.com`,
                        ],
                    },
                    build: {
                        commands: [
                            'echo Scan started on `date`',
                            `curl -s ${url} | if [ -f "${policyBundlePath}" ]; then bash -s -- -f -t ${timeout} -b ${policyBundlePath} image2scan:ci; else bash -s -- -f -t ${timeout} image2scan:ci; fi`,
                            'echo Scan completed on `date`',
                        ],
                    },
                },
            }),
        });
        // grant the Pipeline role the required permissions to this Project
        options.role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            resources: [project.projectArn],
            actions: ['codebuild:BatchGetBuilds', 'codebuild:StartBuild', 'codebuild:StopBuild'],
        }));
        // allow the Project access to the Pipeline's artifact Bucket
        // but only if the project is not imported
        // (ie., has a role) - otherwise, the IAM library throws an error
        if (project.role) {
            options.bucket.grantRead(project);
        }
        return {
            configuration: {
                ProjectName: project.projectName,
            },
        };
    }
}
exports.CodePipelineAnchoreInlineScanAction = CodePipelineAnchoreInlineScanAction;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineAnchoreInlineScanAction[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-anchore-inline-scan-action.CodePipelineAnchoreInlineScanAction", version: "1.28.0" };
//# sourceMappingURL=data:application/json;base64,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