"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipelineTsProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const path = require("path");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
/**
 * Synthesizes a Typescript Project with a CI/CD pipeline.
 *
 * @pjid pdk-pipeline-ts
 */
class PDKPipelineTsProject extends awscdk_1.AwsCdkTypeScriptApp {
    constructor(options) {
        super({
            github: false,
            package: false,
            prettier: true,
            projenrcTs: true,
            release: false,
            sampleCode: false,
            ...options,
            appEntrypoint: options.appEntrypoint || "pipeline.ts",
            cdkVersion: options.cdkVersion || "2.0.0",
        });
        this.addDeps("aws-prototyping-sdk");
        new projen_1.SampleDir(this, this.srcdir, {
            sourceDir: path.join(__dirname, "..", "..", "..", "samples", "sample-pdk-pipeline-ts", "src"),
        });
        new projen_1.SampleDir(this, this.testdir, {
            sourceDir: path.join(__dirname, "..", "..", "..", "samples", "sample-pdk-pipeline-ts", "test"),
        });
    }
}
exports.PDKPipelineTsProject = PDKPipelineTsProject;
_a = JSII_RTTI_SYMBOL_1;
PDKPipelineTsProject[_a] = { fqn: "aws-prototyping-sdk.pdk_projen.PDKPipelineTsProject", version: "0.0.59" };
//# sourceMappingURL=data:application/json;base64,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