"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineDockerfileLinterAction = void 0;
const aws_codebuild_1 = require("@aws-cdk/aws-codebuild");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_iam_1 = require("@aws-cdk/aws-iam");
class CodePipelineDockerfileLinterAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.TEST,
            provider: 'CodeBuild',
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.input],
        });
        this.props = props;
    }
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     */
    bound(scope, _stage, options) {
        const buildImage = aws_codebuild_1.LinuxBuildImage.STANDARD_4_0;
        const version = this.props.version || 'v1.18.0';
        const project = new aws_codebuild_1.PipelineProject(scope, 'LinterProject', {
            cache: aws_codebuild_1.Cache.local(aws_codebuild_1.LocalCacheMode.DOCKER_LAYER),
            environment: {
                buildImage,
                computeType: this.props.computeType || buildImage.defaultComputeType,
                privileged: true,
            },
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    pre_build: {
                        commands: ['echo Pulling the hadolint docker image', `docker pull hadolint/hadolint:${version}`],
                    },
                    build: {
                        commands: [],
                        finally: ['echo Scan started on `date`', `result=$(docker run --rm -i hadolint/hadolint:${version} hadolint -f json - < Dockerfile)`],
                    },
                    post_build: {
                        commands: ['if [ "$result" != "[]" ]; then echo $result | jq .; else echo "Awesome! No findings!"; fi', 'echo Scan completed on `date`'],
                    },
                },
            }),
        });
        // grant the Pipeline role the required permissions to this Project
        options.role.addToPolicy(new aws_iam_1.PolicyStatement({
            resources: [project.projectArn],
            actions: ['codebuild:BatchGetBuilds', 'codebuild:StartBuild', 'codebuild:StopBuild'],
        }));
        // allow the Project access to the Pipeline's artifact Bucket
        // but only if the project is not imported
        // (ie., has a role) - otherwise, the IAM library throws an error
        if (project.role) {
            options.bucket.grantRead(project);
        }
        return {
            configuration: {
                ProjectName: project.projectName,
            },
        };
    }
}
exports.CodePipelineDockerfileLinterAction = CodePipelineDockerfileLinterAction;
//# sourceMappingURL=data:application/json;base64,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