"use strict";

require("core-js/modules/es.symbol");

require("core-js/modules/es.symbol.description");

require("core-js/modules/es.symbol.iterator");

require("core-js/modules/es.array.iterator");

require("core-js/modules/es.array.map");

require("core-js/modules/es.date.to-string");

require("core-js/modules/es.function.bind");

require("core-js/modules/es.function.name");

require("core-js/modules/es.object.create");

require("core-js/modules/es.object.define-property");

require("core-js/modules/es.object.get-prototype-of");

require("core-js/modules/es.object.set-prototype-of");

require("core-js/modules/es.object.to-string");

require("core-js/modules/es.promise");

require("core-js/modules/es.reflect.construct");

require("core-js/modules/es.regexp.to-string");

require("core-js/modules/es.string.iterator");

require("core-js/modules/web.dom-collections.iterator");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddJob = void 0;

require("regenerator-runtime/runtime");

var _apputils = require("@jupyterlab/apputils");

var _api = require("./api");

var _cronParser = _interopRequireDefault(require("cron-parser"));

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var Component = /*#__PURE__*/function (_React$Component) {
  _inherits(Component, _React$Component);

  var _super = _createSuper(Component);

  function Component() {
    var _this;

    _classCallCheck(this, Component);

    _this = _super.call(this);
    _this.state = {
      schedule: '',
      schedule_examples: [],
      is_schedule_valid: false,
      is_submit_successful: null,
      submitted: false,
      run_evironment: 'bash',
      command: ''
    };
    _this.runEnvironmentChange = _this.runEnvironmentChange.bind(_assertThisInitialized(_this));
    _this.commandChange = _this.commandChange.bind(_assertThisInitialized(_this));
    _this.scheduleChange = _this.scheduleChange.bind(_assertThisInitialized(_this));
    _this.handleSubmit = _this.handleSubmit.bind(_assertThisInitialized(_this));
    _this.cronRegex = /(((\d+,)+\d+|(\d+(\/|-)\d+)|\d+|\*) ?){5,7}/g;
    return _this;
  }

  _createClass(Component, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      // Force the DOM 'change' event on the select field so that the
      // runEnvironmentChange function is called, updating the command field
      this.triggerInitialEnvSelection();
    }
  }, {
    key: "triggerInitialEnvSelection",
    value: function triggerInitialEnvSelection() {
      var input = document.getElementById("run_environment");
      var event = new Event("change", {
        bubbles: true
      });
      input.dispatchEvent(event);
    }
  }, {
    key: "scheduleChange",
    value: function scheduleChange(event) {
      if (event.target.name === "schedule") {
        var schedule = event.target.value; // Try to display some examples of the next runs

        try {
          // Throwing shcedule into failed state if it's empty...
          if (schedule === "" || !this.cronRegex.test(schedule)) {
            throw new Error();
          }

          var examples = [];

          var interval = _cronParser["default"].parseExpression(schedule);

          for (var i = 0; i < 5; i++) {
            examples.push(interval.next().toString());
          }

          this.setState({
            schedule: schedule,
            schedule_examples: examples,
            is_schedule_valid: true
          }); // Don't actually care if we can't generate example cron runs....
        } catch (err) {
          this.setState({
            schedule: schedule,
            is_schedule_valid: false
          });
        }
      }
    }
  }, {
    key: "runEnvironmentChange",
    value: function runEnvironmentChange(event) {
      if (event.target.name === "run_environment") {
        var runEnvironment = event.target.value;
        var updatedCommand = '';

        switch (runEnvironment) {
          case "bash":
            updatedCommand = "bash ".concat(this.props.script_path);
            break;

          case "python":
            updatedCommand = "python ".concat(this.props.script_path);
            break;

          case "papermill":
            updatedCommand = "papermill ".concat(this.props.script_path, " /dev/null");
            break;

          case "custom":
            updatedCommand = "[CUSTOM_RUN_ENVIRONMENT_GOES_HERE] ".concat(this.props.script_path);
            break;

          default:
            updatedCommand = "bash ".concat(this.props.script_path);
        }

        this.setState({
          run_evironment: runEnvironment,
          command: updatedCommand
        });
      }
    }
  }, {
    key: "commandChange",
    value: function commandChange(event) {
      console.log("here");

      if (event.target.name === "command") {
        console.log("andhere");
        var command = event.target.value;
        this.setState({
          command: command
        });
      }
    }
  }, {
    key: "handleSubmit",
    value: function handleSubmit(event) {
      event.preventDefault();
      this.setState({
        submitted: true
      });
      this.addJob(this.state.schedule, this.props.script, this.state.command);
    }
  }, {
    key: "addJob",
    value: function () {
      var _addJob = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(schedule, script, command) {
        var dataToSend, reply;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                dataToSend = {
                  script: script,
                  schedule: schedule,
                  command: command
                };
                _context.prev = 1;
                _context.next = 4;
                return (0, _api.requestAPI)('add', {
                  body: JSON.stringify(dataToSend),
                  method: 'POST'
                });

              case 4:
                reply = _context.sent;
                this.setState({
                  is_submit_successful: true
                });
                _context.next = 12;
                break;

              case 8:
                _context.prev = 8;
                _context.t0 = _context["catch"](1);
                console.error("Error sending delete: ".concat(_context.t0));
                this.setState({
                  is_submit_successful: false
                });

              case 12:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[1, 8]]);
      }));

      function addJob(_x, _x2, _x3) {
        return _addJob.apply(this, arguments);
      }

      return addJob;
    }()
  }, {
    key: "render",
    value: function render() {
      var submissionStatus = this.state.is_submit_successful ? /*#__PURE__*/_react["default"].createElement("span", {
        style: {
          "marginLeft": "5px",
          "color": "green"
        }
      }, "Job submitted successfully!") : /*#__PURE__*/_react["default"].createElement("span", {
        style: {
          "marginLeft": "5px",
          "color": "red"
        }
      }, "There was an error submitting job!");
      return /*#__PURE__*/_react["default"].createElement("form", {
        onSubmit: this.handleSubmit
      }, /*#__PURE__*/_react["default"].createElement("div", {
        style: {
          "display": "flex",
          "alignContent": "flex-start",
          "flexDirection": "column"
        }
      }, /*#__PURE__*/_react["default"].createElement("div", {
        style: {
          "display": "flex",
          "flexDirection": "row",
          "padding": "10px"
        }
      }, /*#__PURE__*/_react["default"].createElement("div", {
        style: {
          "minWidth": "120px"
        }
      }, "Run Environment:"), /*#__PURE__*/_react["default"].createElement("div", null, /*#__PURE__*/_react["default"].createElement("select", {
        id: "run_environment",
        value: this.state.run_evironment,
        name: "run_environment",
        onChange: this.runEnvironmentChange
      }, /*#__PURE__*/_react["default"].createElement("option", {
        value: "bash"
      }, "Bash"), /*#__PURE__*/_react["default"].createElement("option", {
        value: "python"
      }, "Python"), /*#__PURE__*/_react["default"].createElement("option", {
        value: "papermill"
      }, "Jupyter Notebook (Papermill)"), /*#__PURE__*/_react["default"].createElement("option", {
        value: "custom"
      }, "Custom (Edit command below)")))), /*#__PURE__*/_react["default"].createElement("div", {
        style: {
          "display": "flex",
          "flexDirection": "row",
          "padding": "10px"
        }
      }, /*#__PURE__*/_react["default"].createElement("div", {
        style: {
          "minWidth": "120px"
        }
      }, "Command:"), /*#__PURE__*/_react["default"].createElement("div", null, this.state.run_evironment === "custom" ? /*#__PURE__*/_react["default"].createElement("textarea", {
        style: {
          "width": "500px",
          "height": "50px"
        },
        type: "text",
        name: "command",
        value: this.state.command,
        onChange: this.commandChange
      }) : /*#__PURE__*/_react["default"].createElement("textarea", {
        style: {
          "width": "500px",
          "height": "50px"
        },
        type: "text",
        name: "command",
        value: this.state.command,
        readOnly: true,
        disabled: true
      }))), /*#__PURE__*/_react["default"].createElement("div", {
        style: {
          "display": "flex",
          "flexDirection": "row",
          "padding": "10px"
        }
      }, /*#__PURE__*/_react["default"].createElement("div", {
        style: {
          "minWidth": "120px"
        }
      }, "Cron Schedule:"), /*#__PURE__*/_react["default"].createElement("div", null, /*#__PURE__*/_react["default"].createElement("input", {
        type: "text",
        name: "schedule",
        value: this.state.schedule,
        onChange: this.scheduleChange
      }))), /*#__PURE__*/_react["default"].createElement("div", {
        style: {
          "display": "flex",
          "flexDirection": "row",
          "padding": "10px"
        }
      }, /*#__PURE__*/_react["default"].createElement("div", {
        style: {
          "minWidth": "120px"
        }
      }, "Example Runs:"), this.state.is_schedule_valid ? null : /*#__PURE__*/_react["default"].createElement("div", null, /*#__PURE__*/_react["default"].createElement("span", {
        style: {
          "color": "red"
        }
      }, "Invalid chron syntax!"))), this.state.is_schedule_valid && /*#__PURE__*/_react["default"].createElement("div", {
        style: {
          "display": "flex",
          "flexDirection": "row",
          "padding": "10px"
        }
      }, /*#__PURE__*/_react["default"].createElement("ul", null, this.state.schedule_examples.map(function (example, i) {
        return /*#__PURE__*/_react["default"].createElement("li", {
          key: i
        }, example);
      }))), /*#__PURE__*/_react["default"].createElement("div", {
        style: {
          "padding": "10px"
        }
      }, this.state.is_schedule_valid && /*#__PURE__*/_react["default"].createElement("div", null, /*#__PURE__*/_react["default"].createElement("input", {
        type: "submit",
        value: "Schedule"
      }), this.state.submitted && submissionStatus))));
    }
  }]);

  return Component;
}(_react["default"].Component);
/**
 * A Lumino Widget that wraps the react component.
 */


var AddJob = /*#__PURE__*/function (_ReactWidget) {
  _inherits(AddJob, _ReactWidget);

  var _super2 = _createSuper(AddJob);

  function AddJob(script, script_path) {
    var _this2;

    _classCallCheck(this, AddJob);

    _this2 = _super2.call(this);

    _this2.addClass('ReactWidget');

    _this2.script = script;
    _this2.script_path = script_path;
    return _this2;
  }

  _createClass(AddJob, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/_react["default"].createElement(Component, {
        script: this.script,
        script_path: this.script_path
      });
    }
  }]);

  return AddJob;
}(_apputils.ReactWidget);

exports.AddJob = AddJob;