"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaLayerVersionCleaner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const targets = require("aws-cdk-lib/aws-events-targets");
const iam = require("aws-cdk-lib/aws-iam");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const delete_old_lambda_layer_versions_function_1 = require("./lambda/delete-old-lambda-layer-versions-function");
class LambdaLayerVersionCleaner extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Create the Lambda function to delete old layer versions
        this.handler = new delete_old_lambda_layer_versions_function_1.DeleteOldLambdaLayerVersionsFunction(this, 'DeleteOldLambdaLayerVersionsFunction', {
            environment: { RETAIN_VERSIONS: props?.retainVersions ?? '10' },
        });
        // Create the LogGroup for the Lambda function
        new logs.LogGroup(this, `${this.handler.node.id}LogGroup`, {
            logGroupName: `/aws/lambda/${this.handler.functionName}`,
            removalPolicy: cdk.RemovalPolicy.DESTROY,
        });
        // Add the necessary IAM permissions for the Lambda function
        const handlerPolicyStatement = new iam.PolicyStatement({
            actions: ['lambda:ListLayers', 'lambda:ListLayerVersions', 'lambda:DeleteLayerVersion'],
            effect: iam.Effect.ALLOW,
            resources: ['*'],
        });
        this.handler.addToRolePolicy(handlerPolicyStatement);
        // Create the EventBridge rule for the Lambda function execution schedule
        this.rule = new events.Rule(this, 'LayerCleanerScheduleRule', {
            schedule: props?.layerCleanerSchedule ?? events.Schedule.rate(cdk.Duration.days(1)),
        });
        this.rule.addTarget(new targets.LambdaFunction(this.handler));
        // Add the necessary permissions for the EventBridge rule to invoke the Lambda function
        targets.addLambdaPermission(this.rule, this.handler);
    }
}
exports.LambdaLayerVersionCleaner = LambdaLayerVersionCleaner;
_a = JSII_RTTI_SYMBOL_1;
LambdaLayerVersionCleaner[_a] = { fqn: "lambda-layer-version-cleaner.LambdaLayerVersionCleaner", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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