# coding: utf-8

"""
    Collibra Catalog classification API

    <p>The Catalog API offers functionality related to the catalog product.<br/> It is mainly focused on facilitating the ingestion of information into Catalog. The API enables users to more easily connect Catalog to sources that are not necessarily natively supported in the product. </p>  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_data_classification.configuration import Configuration


class ChangeClassificationMatchRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'classification_match_id': 'str',
        'status': 'str',
        'confidence': 'float'
    }

    attribute_map = {
        'classification_match_id': 'classificationMatchId',
        'status': 'status',
        'confidence': 'confidence'
    }

    def __init__(self, classification_match_id=None, status=None, confidence=None, local_vars_configuration=None):  # noqa: E501
        """ChangeClassificationMatchRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._classification_match_id = None
        self._status = None
        self._confidence = None
        self.discriminator = None

        if classification_match_id is not None:
            self.classification_match_id = classification_match_id
        if status is not None:
            self.status = status
        if confidence is not None:
            self.confidence = confidence

    @property
    def classification_match_id(self):
        """Gets the classification_match_id of this ChangeClassificationMatchRequest.  # noqa: E501

        The <code>id</code> of the classification match.  # noqa: E501

        :return: The classification_match_id of this ChangeClassificationMatchRequest.  # noqa: E501
        :rtype: str
        """
        return self._classification_match_id

    @classification_match_id.setter
    def classification_match_id(self, classification_match_id):
        """Sets the classification_match_id of this ChangeClassificationMatchRequest.

        The <code>id</code> of the classification match.  # noqa: E501

        :param classification_match_id: The classification_match_id of this ChangeClassificationMatchRequest.  # noqa: E501
        :type: str
        """

        self._classification_match_id = classification_match_id

    @property
    def status(self):
        """Gets the status of this ChangeClassificationMatchRequest.  # noqa: E501

        The status to be set on classification match with given id. Only possible choices : ACCEPTED, REJECTED.  # noqa: E501

        :return: The status of this ChangeClassificationMatchRequest.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ChangeClassificationMatchRequest.

        The status to be set on classification match with given id. Only possible choices : ACCEPTED, REJECTED.  # noqa: E501

        :param status: The status of this ChangeClassificationMatchRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["ACCEPTED", "REJECTED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def confidence(self):
        """Gets the confidence of this ChangeClassificationMatchRequest.  # noqa: E501

        The confidence level between 0-1 which the current match is assigned with.  # noqa: E501

        :return: The confidence of this ChangeClassificationMatchRequest.  # noqa: E501
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence):
        """Sets the confidence of this ChangeClassificationMatchRequest.

        The confidence level between 0-1 which the current match is assigned with.  # noqa: E501

        :param confidence: The confidence of this ChangeClassificationMatchRequest.  # noqa: E501
        :type: float
        """

        self._confidence = confidence

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChangeClassificationMatchRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ChangeClassificationMatchRequest):
            return True

        return self.to_dict() != other.to_dict()
