#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

#include <G4MaterialPropertiesIndex.hh>

#include "typecast.hh"
#include "opaques.hh"

namespace py = pybind11;

void export_G4MaterialPropertiesIndex(py::module &m)
{
   py::enum_<G4MaterialPropertyIndex>(m, "G4MaterialPropertyIndex")
      .value("kNullPropertyIndex", kNullPropertyIndex)
      .value("kRINDEX", kRINDEX)
      .value("kREFLECTIVITY", kREFLECTIVITY)
      .value("kREALRINDEX", kREALRINDEX)
      .value("kIMAGINARYRINDEX", kIMAGINARYRINDEX)
      .value("kEFFICIENCY", kEFFICIENCY)
      .value("kTRANSMITTANCE", kTRANSMITTANCE)
      .value("kSPECULARLOBECONSTANT", kSPECULARLOBECONSTANT)
      .value("kSPECULARSPIKECONSTANT", kSPECULARSPIKECONSTANT)
      .value("kBACKSCATTERCONSTANT", kBACKSCATTERCONSTANT)
      .value("kGROUPVEL", kGROUPVEL)
      .value("kMIEHG", kMIEHG)
      .value("kRAYLEIGH", kRAYLEIGH)
      .value("kWLSCOMPONENT", kWLSCOMPONENT)
      .value("kWLSABSLENGTH", kWLSABSLENGTH)
      .value("kWLSCOMPONENT2", kWLSCOMPONENT2)
      .value("kWLSABSLENGTH2", kWLSABSLENGTH2)
      .value("kABSLENGTH", kABSLENGTH)
      .value("kPROTONSCINTILLATIONYIELD", kPROTONSCINTILLATIONYIELD)
      .value("kDEUTERONSCINTILLATIONYIELD", kDEUTERONSCINTILLATIONYIELD)
      .value("kTRITONSCINTILLATIONYIELD", kTRITONSCINTILLATIONYIELD)
      .value("kALPHASCINTILLATIONYIELD", kALPHASCINTILLATIONYIELD)
      .value("kIONSCINTILLATIONYIELD", kIONSCINTILLATIONYIELD)
      .value("kELECTRONSCINTILLATIONYIELD", kELECTRONSCINTILLATIONYIELD)
      .value("kSCINTILLATIONCOMPONENT1", kSCINTILLATIONCOMPONENT1)
      .value("kSCINTILLATIONCOMPONENT2", kSCINTILLATIONCOMPONENT2)
      .value("kSCINTILLATIONCOMPONENT3", kSCINTILLATIONCOMPONENT3)
      .value("kNumberOfPropertyIndex", kNumberOfPropertyIndex)
      .export_values();

   py::enum_<G4MaterialConstPropertyIndex>(m, "G4MaterialConstPropertyIndex")
      .value("kNullConstPropertyIndex", kNullConstPropertyIndex)
      .value("kSURFACEROUGHNESS", kSURFACEROUGHNESS)
      .value("kISOTHERMAL_COMPRESSIBILITY", kISOTHERMAL_COMPRESSIBILITY)
      .value("kRS_SCALE_FACTOR", kRS_SCALE_FACTOR)
      .value("kWLSMEANNUMBERPHOTONS", kWLSMEANNUMBERPHOTONS)
      .value("kWLSTIMECONSTANT", kWLSTIMECONSTANT)
      .value("kWLSMEANNUMBERPHOTONS2", kWLSMEANNUMBERPHOTONS2)
      .value("kWLSTIMECONSTANT2", kWLSTIMECONSTANT2)
      .value("kMIEHG_FORWARD", kMIEHG_FORWARD)
      .value("kMIEHG_BACKWARD", kMIEHG_BACKWARD)
      .value("kMIEHG_FORWARD_RATIO", kMIEHG_FORWARD_RATIO)
      .value("kSCINTILLATIONYIELD", kSCINTILLATIONYIELD)
      .value("kRESOLUTIONSCALE", kRESOLUTIONSCALE)
      .value("kFERMIPOT", kFERMIPOT)
      .value("kDIFFUSION", kDIFFUSION)
      .value("kSPINFLIP", kSPINFLIP)
      .value("kLOSS", kLOSS)
      .value("kLOSSCS", kLOSSCS)
      .value("kABSCS", kABSCS)
      .value("kSCATCS", kSCATCS)
      .value("kMR_NBTHETA", kMR_NBTHETA)
      .value("kMR_NBE", kMR_NBE)
      .value("kMR_RRMS", kMR_RRMS)
      .value("kMR_CORRLEN", kMR_CORRLEN)
      .value("kMR_THETAMIN", kMR_THETAMIN)
      .value("kMR_THETAMAX", kMR_THETAMAX)
      .value("kMR_EMIN", kMR_EMIN)
      .value("kMR_EMAX", kMR_EMAX)
      .value("kMR_ANGNOTHETA", kMR_ANGNOTHETA)
      .value("kMR_ANGNOPHI", kMR_ANGNOPHI)
      .value("kMR_ANGCUT", kMR_ANGCUT)
      .value("kSCINTILLATIONTIMECONSTANT1", kSCINTILLATIONTIMECONSTANT1)
      .value("kSCINTILLATIONTIMECONSTANT2", kSCINTILLATIONTIMECONSTANT2)
      .value("kSCINTILLATIONTIMECONSTANT3", kSCINTILLATIONTIMECONSTANT3)
      .value("kSCINTILLATIONRISETIME1", kSCINTILLATIONRISETIME1)
      .value("kSCINTILLATIONRISETIME2", kSCINTILLATIONRISETIME2)
      .value("kSCINTILLATIONRISETIME3", kSCINTILLATIONRISETIME3)
      .value("kSCINTILLATIONYIELD1", kSCINTILLATIONYIELD1)
      .value("kSCINTILLATIONYIELD2", kSCINTILLATIONYIELD2)
      .value("kSCINTILLATIONYIELD3", kSCINTILLATIONYIELD3)
      .value("kPROTONSCINTILLATIONYIELD1", kPROTONSCINTILLATIONYIELD1)
      .value("kPROTONSCINTILLATIONYIELD2", kPROTONSCINTILLATIONYIELD2)
      .value("kPROTONSCINTILLATIONYIELD3", kPROTONSCINTILLATIONYIELD3)
      .value("kDEUTERONSCINTILLATIONYIELD1", kDEUTERONSCINTILLATIONYIELD1)
      .value("kDEUTERONSCINTILLATIONYIELD2", kDEUTERONSCINTILLATIONYIELD2)
      .value("kDEUTERONSCINTILLATIONYIELD3", kDEUTERONSCINTILLATIONYIELD3)
      .value("kTRITONSCINTILLATIONYIELD1", kTRITONSCINTILLATIONYIELD1)
      .value("kTRITONSCINTILLATIONYIELD2", kTRITONSCINTILLATIONYIELD2)
      .value("kTRITONSCINTILLATIONYIELD3", kTRITONSCINTILLATIONYIELD3)
      .value("kALPHASCINTILLATIONYIELD1", kALPHASCINTILLATIONYIELD1)
      .value("kALPHASCINTILLATIONYIELD2", kALPHASCINTILLATIONYIELD2)
      .value("kALPHASCINTILLATIONYIELD3", kALPHASCINTILLATIONYIELD3)
      .value("kIONSCINTILLATIONYIELD1", kIONSCINTILLATIONYIELD1)
      .value("kIONSCINTILLATIONYIELD2", kIONSCINTILLATIONYIELD2)
      .value("kIONSCINTILLATIONYIELD3", kIONSCINTILLATIONYIELD3)
      .value("kELECTRONSCINTILLATIONYIELD1", kELECTRONSCINTILLATIONYIELD1)
      .value("kELECTRONSCINTILLATIONYIELD2", kELECTRONSCINTILLATIONYIELD2)
      .value("kELECTRONSCINTILLATIONYIELD3", kELECTRONSCINTILLATIONYIELD3)
      .value("kNumberOfConstPropertyIndex", kNumberOfConstPropertyIndex)
      .export_values();
}
