from setuptools import setup, find_packages
import pathlib

here = pathlib.Path(__file__).parent.resolve()

# Get the long description from the README file
long_description = (here / 'README.md').read_text(encoding='utf-8')

setup(
    name='json-stream',
    version='1.0.0',
    description='Streaming JSON decoder',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://github.com/daggaz/json-stream',
    author='Jamie Cockburn',
    author_email='jamie_cockburn@hotmail.co.uk',  # Optional
    classifiers=[  # Optional
        # How mature is this project? Common values are
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        'Development Status :: 3 - Alpha',

        # Indicate who your project is intended for
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Libraries',

        # Pick your license as you wish
        'License :: OSI Approved :: MIT License',

        # Specify the Python versions you support here. In particular, ensure
        # that you indicate you support Python 3. These classifiers are *not*
        # checked by 'pip install'. See instead 'python_requires' below.
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3 :: Only',
    ],
    keywords='sample, setuptools, development',
    package_dir={'': 'src'},
    packages=find_packages(where='src'),
    setup_requires=['wheel'],
    python_requires='>=3.5, <4',
    project_urls={
        'Bug Reports': 'https://github.com/daggaz/json-stream/issues',
        'Source': 'https://github.com/daggaz/json-stream/',
    },
)
