# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 2.3.0  # noqa: E501
    The version of the OpenAPI document: 0.11.2
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class MerkleTreeLeafDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'MerkleTreeNodeTypeEnum',
        'path': 'str',
        'encoded_path': 'str',
        'nibble_count': 'int',
        'value': 'str',
        'leaf_hash': 'str'
    }

    attribute_map = {
        'type': 'type',
        'path': 'path',
        'encoded_path': 'encodedPath',
        'nibble_count': 'nibbleCount',
        'value': 'value',
        'leaf_hash': 'leafHash'
    }

    def __init__(self, type=None, path=None, encoded_path=None, nibble_count=None, value=None, leaf_hash=None, local_vars_configuration=None):  # noqa: E501
        """MerkleTreeLeafDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._path = None
        self._encoded_path = None
        self._nibble_count = None
        self._value = None
        self._leaf_hash = None
        self.discriminator = None

        self.type = type
        self.path = path
        self.encoded_path = encoded_path
        self.nibble_count = nibble_count
        self.value = value
        self.leaf_hash = leaf_hash

    @property
    def type(self):
        """Gets the type of this MerkleTreeLeafDTO.  # noqa: E501


        :return: The type of this MerkleTreeLeafDTO.  # noqa: E501
        :rtype: MerkleTreeNodeTypeEnum
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this MerkleTreeLeafDTO.


        :param type: The type of this MerkleTreeLeafDTO.  # noqa: E501
        :type: MerkleTreeNodeTypeEnum
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def path(self):
        """Gets the path of this MerkleTreeLeafDTO.  # noqa: E501

        Leaf path.  # noqa: E501

        :return: The path of this MerkleTreeLeafDTO.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this MerkleTreeLeafDTO.

        Leaf path.  # noqa: E501

        :param path: The path of this MerkleTreeLeafDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and path is None:  # noqa: E501
            raise ValueError("Invalid value for `path`, must not be `None`")  # noqa: E501

        self._path = path

    @property
    def encoded_path(self):
        """Gets the encoded_path of this MerkleTreeLeafDTO.  # noqa: E501

        Encoded leaf path.  # noqa: E501

        :return: The encoded_path of this MerkleTreeLeafDTO.  # noqa: E501
        :rtype: str
        """
        return self._encoded_path

    @encoded_path.setter
    def encoded_path(self, encoded_path):
        """Sets the encoded_path of this MerkleTreeLeafDTO.

        Encoded leaf path.  # noqa: E501

        :param encoded_path: The encoded_path of this MerkleTreeLeafDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and encoded_path is None:  # noqa: E501
            raise ValueError("Invalid value for `encoded_path`, must not be `None`")  # noqa: E501

        self._encoded_path = encoded_path

    @property
    def nibble_count(self):
        """Gets the nibble_count of this MerkleTreeLeafDTO.  # noqa: E501

        Nibble count.  # noqa: E501

        :return: The nibble_count of this MerkleTreeLeafDTO.  # noqa: E501
        :rtype: int
        """
        return self._nibble_count

    @nibble_count.setter
    def nibble_count(self, nibble_count):
        """Sets the nibble_count of this MerkleTreeLeafDTO.

        Nibble count.  # noqa: E501

        :param nibble_count: The nibble_count of this MerkleTreeLeafDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and nibble_count is None:  # noqa: E501
            raise ValueError("Invalid value for `nibble_count`, must not be `None`")  # noqa: E501

        self._nibble_count = nibble_count

    @property
    def value(self):
        """Gets the value of this MerkleTreeLeafDTO.  # noqa: E501

        Leaf value (sha256 hash).  # noqa: E501

        :return: The value of this MerkleTreeLeafDTO.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this MerkleTreeLeafDTO.

        Leaf value (sha256 hash).  # noqa: E501

        :param value: The value of this MerkleTreeLeafDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and value is None:  # noqa: E501
            raise ValueError("Invalid value for `value`, must not be `None`")  # noqa: E501

        self._value = value

    @property
    def leaf_hash(self):
        """Gets the leaf_hash of this MerkleTreeLeafDTO.  # noqa: E501


        :return: The leaf_hash of this MerkleTreeLeafDTO.  # noqa: E501
        :rtype: str
        """
        return self._leaf_hash

    @leaf_hash.setter
    def leaf_hash(self, leaf_hash):
        """Sets the leaf_hash of this MerkleTreeLeafDTO.


        :param leaf_hash: The leaf_hash of this MerkleTreeLeafDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and leaf_hash is None:  # noqa: E501
            raise ValueError("Invalid value for `leaf_hash`, must not be `None`")  # noqa: E501

        self._leaf_hash = leaf_hash

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MerkleTreeLeafDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MerkleTreeLeafDTO):
            return True

        return self.to_dict() != other.to_dict()
