# kplot theme finding and execution "library"

# for path finding
from glob import glob
import sys
import matplotlib.pyplot as plt

# findpath: gets the path to the given theme, using `glob`
# Arguments:
#    str `style`: name of the style, with no extension or path information

# Returns:
#    if valid path found: path to theme
#    else: no return value

# Other Actions:
#    none

def findpath(style):
    for p in sys.path:
        search = glob(p+'*/kplot/styles/'+style+'.mplstyle')
        if len(search) == 1:
            return search[0]

# loadtheme: takes a path (as generated by findpath) and sets the current style with it
# Arguments:
#    str `path`: path to matplotlib style

# Returns: 
#    none

# Other Actions:
#    Sets the theme using the passed theme path.
def loadtheme(path):
    import kplot.lib
    s = kplot.lib.findpath(path)
    plt.style.use(s)

def hline(y,ax=False):
    if not ax:
        for yi in y:
            plt.axhline(yi,color='black',linestyle='--')
    else:
        for yi in y:
            ax.axhline(yi,color='black',linestyle='--')
        
def vline(x,ax=False):
    if not ax:
        for xi in x:
            plt.axvline(xi,color='black',linestyle='--')
    else:
        for xi in x:
            ax.axvline(xi,color='black',linestyle='--')
