(function(angular,undefined){"use strict";var fileuploadModule=angular.module("djng.fileupload",["ngFileUpload"]);fileuploadModule.directive("djngFileuploadUrl",["Upload",function(Upload){return{restrict:"A",require:"ngModel",link:function(scope,element,attrs,ngModelController){ngModelController.$setViewValue({});element.data("area_label",element.val());if(attrs.currentFile){angular.extend(scope.$eval(attrs.ngModel),{current_file:attrs.currentFile});element.data("current_file",attrs.currentFile);element.val(attrs.currentFile.substring(0,attrs.currentFile.indexOf(":")));element.addClass("djng-preset")}else{element.addClass("djng-empty")}scope.uploadFile=function(file,filetype,id,model){var data={"file:0":file,filetype:filetype},element=angular.element(document.querySelector("#"+id));element.addClass("uploading");Upload.upload({data:data,url:attrs.djngFileuploadUrl}).then(function(response){var field=response.data["file:0"];var cf=element.data("current_file");element.removeClass("uploading");if(!field)return;element.css("background-image",field.url);element.removeClass("djng-empty");element.removeClass("djng-preset");element.val(field.file_name);delete field.url;angular.extend(scope.$eval(model),field,cf?{current_file:cf}:{})},function(respose){element.removeClass("uploading");console.error(respose.statusText)})}}}}]);fileuploadModule.directive("djngFileuploadButton",function(){return{restrict:"A",link:function(scope,element,attrs){scope.deleteImage=function(id,_model){var model=scope.$eval(_model),element=angular.element(document.querySelector("#"+id));element.css("background-image","none");element.addClass("djng-empty");element.removeClass("djng-preset");element.val(element.data("area_label"));if(model){model.temp_name="delete"}}}}})})(window.angular);(function(angular,undefined){"use strict";var djngModule=angular.module("djng.forms",[]);function hashCode(s){return s.split("").reduce(function(a,b){a=(a<<5)-a+b.charCodeAt(0);return a&a},0)}angular.forEach(["input","select","textarea","datalist"],function(element){djngModule.directive(element,function(){return["$compile",function($compile){return{restrict:"E",require:["?^form","?^djngMultifieldsRequired"],link:function(scope,element,attr,controllers){var modelName,formCtrl=controllers[0];if(!formCtrl||angular.isUndefined(formCtrl.$name)||element.prop("type")==="hidden"||angular.isUndefined(attr.name)||angular.isDefined(attr.ngModel))return;modelName="dmy"+Math.abs(hashCode(formCtrl.$name))+"."+attr.name.replace(/-/g,"_");if(controllers[1]){modelName=modelName.concat("['"+attr.value+"']")}attr.$set("ngModel",modelName);$compile(element,null,9999)(scope)}}}]}())});djngModule.directive("djngError",function(){return{restrict:"A",require:"?^form",link:function(scope,element,attrs,formCtrl){var boundField;var field=angular.isElement(element)?element[0]:null;if(!field||!formCtrl||angular.isUndefined(attrs.name)||attrs.djngError!=="bound-field")return;boundField=formCtrl[attrs.name];boundField.$setValidity("bound",false);boundField.$parsers.push(function(value){if(value!==field.defaultValue){boundField.$setValidity("bound",true);element.removeAttr("djng-error")}return value})}}});djngModule.directive("ngModel",["$log",function($log){function restoreInputField(field){switch(field.type){case"radio":if(field.defaultChecked)return field.defaultValue;break;case"checkbox":if(field.defaultChecked)return true;break;case"password":return null;default:if(field.defaultValue)return field.defaultValue;break}}function restoreSelectOptions(field){var result=field.multiple?[]:undefined;angular.forEach(field.options,function(option){if(option.defaultSelected){angular.element(option).prop("selected","selected");if(field.multiple){result.push(option.value)}else{result=option.value}}});return result}function restoreTextArea(field){if(field.defaultValue){return field.defaultValue}}function setDefaultValue(modelCtrl,value){if(angular.isDefined(value)){modelCtrl.$setViewValue(value);if(angular.isObject(modelCtrl.$options)){modelCtrl.$commitViewValue()}}}return{restrict:"A",priority:2,require:["ngModel","^?form","^?djngMultifieldsRequired"],link:function(scope,element,attrs,controllers){var field=angular.isElement(element)?element[0]:null;var modelCtrl=controllers[0],formCtrl=controllers[1],multifieldsCtrl=controllers[2];var curModelValue=scope.$eval(attrs.ngModel);if(!field||!formCtrl||angular.isDefined(curModelValue))return;switch(field.tagName){case"INPUT":setDefaultValue(modelCtrl,restoreInputField(field));if(multifieldsCtrl){multifieldsCtrl.subFields.push(modelCtrl);modelCtrl.$validators.multifield=multifieldsCtrl.validate}break;case"SELECT":setDefaultValue(modelCtrl,restoreSelectOptions(field));break;case"TEXTAREA":setDefaultValue(modelCtrl,restoreTextArea(field));break;default:$log.log("Unknown field type: "+field.tagName);break}formCtrl.$setPristine()}}}]);djngModule.directive("djngMultifieldsRequired",function(){return{restrict:"A",require:"djngMultifieldsRequired",controller:["$scope",function($scope){var self=this;this.subFields=[];this.validate=function(){var validated=!self.anyFieldRequired;angular.forEach(self.subFields,function(subField){validated=validated||subField.$viewValue});if(validated){angular.forEach(self.subFields,function(subField){subField.$setValidity("multifield",true)})}return validated}}],link:function(scope,element,attrs,controller){controller.anyFieldRequired=scope.$eval(attrs.djngMultifieldsRequired)}}});djngModule.directive("validateDate",function(){var validDatePattern=null;function validateDate(date){var matched,dateobj;if(!date)return true;dateobj=new Date(date);if(isNaN(dateobj))return false;if(validDatePattern){matched=validDatePattern.exec(date);return matched&&parseInt(matched[2],10)===dateobj.getMonth()+1}return true}return{require:"?ngModel",restrict:"A",link:function(scope,elem,attrs,controller){if(!controller)return;if(attrs.validateDate){validDatePattern=new RegExp(attrs.validateDate,"i")}var validator=function(value){var validity=controller.$isEmpty(value)||validateDate(value);controller.$setValidity("date",validity);return validity?value:undefined};controller.$parsers.push(validator)}}});djngModule.directive("validateEmail",function(){return{require:"?ngModel",restrict:"A",link:function(scope,elem,attrs,controller){if(controller&&controller.$validators.email&&attrs.emailPattern){var emailPattern=new RegExp(attrs.emailPattern,"i");controller.$validators.email=function(value){return controller.$isEmpty(value)||emailPattern.test(value)}}}}});djngModule.controller("FormUploadController",["$scope","$http","$interpolate","$parse","$q",function($scope,$http,$interpolate,$parse,$q){var self=this;this.endpointValidatedForms={};this.endpointFormsMap={};this.setEndpoint=function(endpointURL,endpointScope){self.endpointURL=$interpolate(decodeURIComponent(endpointURL));self.endpointScope=endpointScope};this.uploadScope=function(method,urlParams,extraData){var deferred=$q.defer(),data={},url,promise;if(!self.endpointURL)throw new Error("Can not upload form data: Missing endpoint.");if(angular.isObject(urlParams)){url=self.endpointURL(urlParams)}else{url=self.endpointURL()}if(method==="GET"){promise=$http({url:url,method:method,params:extraData})}else{if(angular.isObject(extraData)){angular.merge(data,extraData)}angular.forEach(self.endpointFormsMap,function(scopeModels){var modelScopeData={};angular.forEach(scopeModels,function(scopeModel){var values=$scope.$eval(scopeModel);if(values){modelScopeData[scopeModel]=values;angular.merge(data,modelScopeData)}})});promise=$http({url:url,method:method,data:data})}promise.then(function(response){angular.forEach(self.endpointFormsMap,function(scopeModels,formName){var getter=$parse(formName);self.clearErrors(getter($scope));if(angular.isObject(getter(response.data))){self.setModels(getter($scope),getter(response.data))}getter($scope).$setSubmitted()});deferred.resolve(response)}).catch(function(response){if(response.status>=400&&response.status<=499){angular.forEach(self.endpointFormsMap,function(scopeModels,formName){self.clearErrors($parse(formName)($scope))});angular.forEach(self.endpointFormsMap,function(scopeModels,formName){var getter=$parse(formName);if(angular.isObject(getter(response.data))){self.setErrors(getter($scope),getter(response.data))}getter($scope).$setSubmitted()})}deferred.reject(response)});return deferred.promise};this.clearErrors=function(form){form.$message="";if(form.hasOwnProperty("$error")&&angular.isArray(form.$error.rejected)){angular.forEach(form.$error.rejected.concat(),function(rejected){var field,key=rejected?rejected.$name:null;if(form.hasOwnProperty(key)){field=form[key];if(isField(field)&&angular.isFunction(field.clearRejected)){field.clearRejected()}else if(isForm(field)){field.$setValidity("rejected",true);angular.forEach(field,function(subField,subKey){if(isField(subField)&&subField.clearRejected){subField.clearRejected()}})}}})}};this.setErrors=function(form,errors){var NON_FIELD_ERRORS="__all__";function resetFieldValidity(field){var pos=field.$viewChangeListeners.push(field.clearRejected=function(){field.$message="";field.$setValidity("rejected",true);field.$viewChangeListeners.splice(pos-1,1);delete field.clearRejected})}angular.forEach(errors,function(errors,key){var field;if(errors.length>0){if(key===NON_FIELD_ERRORS||key==="non_field_errors"){form.$message=errors[0];form.$setPristine();form.$setValidity("rejected",false)}else if(form.hasOwnProperty(key)){field=form[key];field.$message=errors[0];field.$setValidity("rejected",false);field.$setPristine();if(isField(field)){resetFieldValidity(field)}else{angular.forEach(field,function(subField,subKey){if(isField(subField)){resetFieldValidity(subField)}})}}}})};this.setModels=function(formCtrl,models){if(models.success_message){formCtrl.$message=models.success_message}angular.forEach(models,function(value,key){var fieldCtrl=formCtrl[key];if(isField(fieldCtrl)){fieldCtrl.$setViewValue(value,"updateOn");if(angular.isObject(fieldCtrl.$options)){fieldCtrl.$commitViewValue()}fieldCtrl.$render();fieldCtrl.$validate();fieldCtrl.$setUntouched();fieldCtrl.$setPristine()}else if(isForm(fieldCtrl)){angular.forEach(fieldCtrl,function(subField,subKey){var leaf;if(isField(subField)){leaf=subField.$name.replace(fieldCtrl.$name+".","");if(value.indexOf(leaf)===-1){leaf=null}subField.$setViewValue(leaf,"updateOn");if(angular.isObject(subField.$options)){subField.$commitViewValue()}subField.$render();subField.$validate();subField.$setUntouched()}});fieldCtrl.$setPristine()}})};this.acceptOrReject=function(){var deferred=$q.defer(),rejected=false,formName,formController;for(formName in self.endpointValidatedForms){var response;if(!self.endpointValidatedForms[formName]){formController=$parse(formName)($scope);formController.$setSubmitted();response={status:422,data:{}};response.data[formName]={};angular.forEach(formController,function(field,fieldName){if(angular.isObject(field)&&field.hasOwnProperty("$modelValue")&&field.$invalid){formController[fieldName].$setDirty();formController[fieldName].$setTouched();response.data[formName][fieldName]=true}});deferred.reject(response);rejected=true;break}}if(!rejected){deferred.resolve()}return deferred.promise};function isField(field){return field&&angular.isArray(field.$viewChangeListeners)}function isForm(form){return form&&form.constructor.name==="FormController"}}]);djngModule.directive("djngEndpoint",function(){return{require:["form","djngEndpoint"],restrict:"A",controller:"FormUploadController",scope:true,link:{pre:function(scope,element,attrs,controllers){if(!attrs.name)throw new Error("Attribute 'name' is not set for this form!");if(!attrs.djngEndpoint)throw new Error("Attribute 'djng-endpoint' is not set for this form!");controllers[1].setEndpoint(attrs.djngEndpoint,scope)},post:function(scope,element,attrs,controllers){var formController=controllers[0];scope.hasError=function(field){if(angular.isObject(formController[field])){if(formController[field].$pristine&&formController[field].$error.rejected)return"has-error";if(formController[field].$touched&&formController[field].$invalid)return"has-error"}};scope.successMessageIsVisible=function(){return formController.$message&&!formController.$error.rejected&&formController.$submitted};scope.rejectMessageIsVisible=function(){return formController.$message&&formController.$error.rejected&&formController.$submitted};scope.getSubmitMessage=function(){return formController.$message};scope.dismissSubmitMessage=function(){if(formController.$error.rejected){formController.$setValidity("rejected",true)}formController.$setPristine()}}}}});djngModule.directive("ngModel",["djangoForm",function(djangoForm){return{restrict:"A",require:["^?djngFormsSet","^?form","^?djngEndpoint"],link:function(scope,element,attrs,controllers){var formController=controllers[1],scopePrefix;if(!formController)return;scopePrefix=djangoForm.getScopePrefix(attrs.ngModel);if(controllers[0]){addToEndpoint(controllers[0])}if(controllers[2]){addToEndpoint(controllers[2])}function addToEndpoint(controller){if(scope.$id!==controller.endpointScope.$id){if(scope.hasOwnProperty(scopePrefix)){controller.endpointScope[scopePrefix]=scope[scopePrefix];delete scope[scopePrefix];if(!scope[formController.$name])throw new Error("Failed to detach model scope and reappend to its parent.")}if(scope.hasOwnProperty(formController.$name)){controller.endpointScope[formController.$name]=scope[formController.$name];delete scope[formController.$name];if(!scope[formController.$name])throw new Error("Failed to detach form controller and/or to reappend to its parent.")}}if(!angular.isArray(controller.endpointFormsMap[formController.$name])){controller.endpointFormsMap[formController.$name]=[]}if(scopePrefix&&controller.endpointFormsMap[formController.$name].indexOf(scopePrefix)===-1){controller.endpointFormsMap[formController.$name].push(scopePrefix)}}element.on("change",function(){if(formController.$error.rejected){formController.$setValidity("rejected",true);formController.$submitted=false;scope.$apply()}})}}}]);djngModule.provider("djangoForm",function(){var self=this,_buttonClasses={showOK:"glyphicon glyphicon-ok",showFail:"glyphicon glyphicon-remove",spinner:"glyphicon glyphicon-refresh djng-rotate-animate"};this.setButtonClasses=function(buttonClasses){if(angular.isDefined(buttonClasses.showOK)){_buttonClasses.showOK=buttonClasses.showOK}if(angular.isDefined(buttonClasses.showFail)){_buttonClasses.showFail=buttonClasses.showFail}if(angular.isDefined(buttonClasses.spinner)){_buttonClasses.spinner=buttonClasses.spinner}};this.$get=["$parse",function($parse){return{buttonClasses:_buttonClasses,getScopePrefix:function(modelName){var context={},result;$parse(modelName).assign(context,true);angular.forEach(context,function(val,key){result=key});return result}}}]});djngModule.directive("button",["$q","$timeout","$window","djangoForm",function($q,$timeout,$window,djangoForm){return{restrict:"E",require:["^?djngFormsSet","^?form","^?djngEndpoint"],scope:false,link:function(scope,element,attrs,controllers){var uploadController=controllers[2]||controllers[0],urlParams,preparePromises=[];if(!uploadController)return;if(attrs.urlParams){urlParams=scope.$eval(attrs.urlParams)}preparePromises.push(uploadController.acceptOrReject);if(angular.isFunction(scope.prepare)){preparePromises.push(scope.prepare())}scope.do=function(resolve,reject){return $q.resolve().then(resolve,reject)};scope.prepare=function(resolve,reject){return function(){var promises=[];angular.forEach(preparePromises,function(p){promises.push(p())});return $q.all(promises)}};scope.fetch=function(extraData){return function(){return uploadController.uploadScope("GET",urlParams,extraData)}};scope.create=function(extraData){return function(){return uploadController.uploadScope("POST",urlParams,extraData)}};scope.update=function(extraData){return function(){return uploadController.uploadScope("PUT",urlParams,extraData)}};scope.delete=function(extraData){return function(){return uploadController.uploadScope("DELETE",urlParams,extraData)}};scope.disable=function(){return function(response){scope.disabled=true;return $q.resolve(response)}};scope.isDisabled=function(){if(controllers[1])return controllers[1].$invalid||scope.disabled;if(controllers[0])return!controllers[0].setIsValid||scope.disabled};scope.spinner=function(){return function(response){scope.disabled=true;angular.forEach(element.find("i"),function(icon){icon=angular.element(icon);if(!icon.data("remember-class")){icon.data("remember-class",icon.attr("class"))}icon.attr("class",djangoForm.buttonClasses.spinner)});return $q.resolve(response)}};scope.showOK=function(){return function(response){angular.forEach(element.find("i"),function(icon){icon=angular.element(icon);if(!icon.data("remember-class")){icon.data("remember-class",icon.attr("class"))}icon.attr("class",djangoForm.buttonClasses.showOK)});return $q.resolve(response)}};scope.showFail=function(){return function(response){angular.forEach(element.find("i"),function(icon){icon=angular.element(icon);if(!icon.data("remember-class")){icon.data("remember-class",icon.attr("class"))}icon.attr("class",djangoForm.buttonClasses.showFail)});return $q.resolve(response)}};scope.restore=function(){return function(response){scope.disabled=false;angular.forEach(element.find("i"),function(icon){icon=angular.element(icon);if(icon.data("remember-class")){icon.attr("class",icon.data("remember-class"));icon.removeData("remember-class")}});return $q.resolve(response)}};scope.emit=function(name,args){return function(response){scope.$emit(name,args);return $q.resolve(response)}};scope.reloadPage=function(){return function(response){$window.location.reload()}};scope.redirectTo=function(url){return function(response){if(angular.isDefined(response.data.success_url)){$window.location.assign(response.data.success_url)}else{$window.location.assign(url)}}};scope.delay=function(ms){return function(response){return $q(function(resolve){scope.timer=$timeout(function(){scope.timer=null;resolve(response)},ms)})}};scope.scrollToRejected=function(){return function(response){var formName,fieldName,element;if(response.status>=400&&response.status<=499){for(formName in response.data){element=null;if(response.data[formName]["__all__"]){element=document.getElementsByName(formName)[0];element=element?element.getElementsByClassName("djng-line-spreader")[0]:null}if(!element){for(fieldName in response.data[formName]){element=document.getElementById("id_"+fieldName)||document.getElementById(formName+"-"+fieldName);if(element)break}}if(element){element.scrollIntoView({behavior:"smooth",block:"center",inline:"nearest"});break}}}}};scope.$on("$destroy",function(){if(scope.timer){$timeout.cancel(scope.timer)}})}}}]);djngModule.directive("a",["djangoForm",function(djangoForm){return{restrict:"E",scope:false,link:function(scope,element,attrs){var icon=element.find("i");if(attrs.ariaPressed==="false"&&icon.length>0){element.on("click",function(){icon.attr("class",djangoForm.buttonClasses.showOK)})}}}}]);djngModule.directive("djngFormsSet",function(){return{require:"djngFormsSet",controller:"FormUploadController",scope:true,link:{pre:function(scope,element,attrs,uploadController){if(!attrs.endpoint)throw new Error("Attribute 'endpoint' is not set!");uploadController.setEndpoint(attrs.endpoint,scope)}}}});djngModule.directive("form",function(){return{restrict:"E",require:["^?djngFormsSet","form"],priority:1,link:function(scope,element,attrs,controllers){var formsSetController=controllers[0],formController=controllers[1];if(!formsSetController)return;if(!attrs.name)throw new Error("Each <form> embedded inside a <djng-forms-set> must identify itself by name.");scope.$watch(attrs.name+".$valid",function reduceValidation(){formsSetController.endpointValidatedForms[formController.$name]=formController.$valid;formsSetController.setIsValid=true;angular.forEach(formsSetController.endpointValidatedForms,function(validatedForm){formsSetController.setIsValid=formsSetController.setIsValid&&validatedForm})})}}});djngModule.directive("djngBindIf",function(){return{restrict:"A",compile:function(templateElement){templateElement.addClass("ng-binding");return function(scope,element,attr){element.data("$binding",attr.ngBind);scope.$watch(attr.djngBindIf,function ngBindWatchAction(value){if(value===undefined||value===null)return;element.text(value)})}}}})})(window.angular);(function(angular,undefined){"use strict";var djng_rmi_module=angular.module("djng.rmi",[]);djng_rmi_module.provider("djangoRMI",function(){var remote_methods,http;this.configure=function(conf){remote_methods=conf;convert_configuration(remote_methods)};function convert_configuration(obj){angular.forEach(obj,function(val,key){if(!angular.isObject(val))throw new Error("djangoRMI.configure got invalid data");if(val.hasOwnProperty("url")){val.headers["X-Requested-With"]="XMLHttpRequest";obj[key]=function(data){var config=angular.copy(val);if(config.method==="POST"){if(data===undefined)throw new Error("Calling remote method "+key+" without data object");config.data=data}else if(config.method==="auto"){if(data===undefined){config.method="GET"}else{config.method="POST";config.data=data}}return http(config)}}else{convert_configuration(val)}})}this.$get=["$http",function($http){http=$http;return remote_methods}]})})(window.angular);(function(angular,undefined){"use strict";var djngUrls=angular.module("djng.urls",[]);djngUrls.provider("djangoUrl",function djangoUrlProvider(){var reverseUrl="/angular/reverse/";this.setReverseUrl=function(url){reverseUrl=url};this.$get=function(){return new djangoUrl(reverseUrl)}});var djangoUrl=function(reverseUrl){function forEachSorted(obj,iterator,context){var keys=sortedKeys(obj);for(var i=0;i<keys.length;i++){iterator.call(context,obj[keys[i]],keys[i])}return keys}function sortedKeys(obj){var keys=[];for(var key in obj){if(obj.hasOwnProperty(key)){keys.push(key)}}return keys.sort()}function buildUrl(url,params){if(!params)return url;var parts=[];forEachSorted(params,function(value,key){if(value===null||value===undefined)return;if(angular.isObject(value)){value=angular.toJson(value)}if((typeof value==="string"||value instanceof String)&&value.lastIndexOf(":",0)===0){parts.push(encodeURIComponent(key)+"="+value)}else{parts.push(encodeURIComponent(key)+"="+encodeURIComponent(value))}});return url+(url.indexOf("?")===-1?"?":"&")+parts.join("&")}this.reverse=function(url_name,args_or_kwargs){var url=buildUrl(reverseUrl,{djng_url_name:url_name});if(Array.isArray(args_or_kwargs)){forEachSorted(args_or_kwargs,function(value){url=buildUrl(url,{djng_url_args:value})});return url}var params={};forEachSorted(args_or_kwargs,function(value,key){params["djng_url_kwarg_"+key]=value});if(angular.equals(params,{})){return url}return buildUrl(url,params)}}})(window.angular);(function(angular,undefined){"use strict";function noop(){}var djng_ws_module=angular.module("djng.websocket",[]);djng_ws_module.service("$websocket",function(){var ws;this.connect=function(url){ws=new WebSocket(url);ws.onopen=this.onopen;ws.onmessage=this.onmessage;ws.onerror=this.onerror;ws.onclose=this.onclose};this.send=function(msg){ws.send(msg)};this.close=function(){ws.close()}});djng_ws_module.provider("djangoWebsocket",function(){var _console={log:noop,warn:noop,error:noop};var websocket_uri,heartbeat_msg=null;var $log=angular.injector(["ng"]).get("$log");this.setURI=function(uri){websocket_uri=uri;return this};this.setHeartbeat=function(msg){heartbeat_msg=msg;return this};this.setLogLevel=function(logLevel){switch(logLevel){case"debug":_console=$log;break;case"log":_console.log=$log.log;case"warn":_console.warn=$log.warn;case"error":_console.error=$log.error;default:break}return this};this.$get=["$websocket","$q","$timeout","$interval",function($websocket,$q,$timeout,$interval){var ws_url,deferred,scope,collection;var is_subscriber=false,is_publisher=false,receiving=false;var wait_for_reconnect=0,heartbeat_promise=null,missed_heartbeats=0;function connect(){_console.log("Connecting to "+ws_url);deferred=$q.defer();$websocket.connect(ws_url)}$websocket.onopen=function(evt){_console.log("Connected");deferred.resolve();wait_for_reconnect=0;if(heartbeat_msg&&heartbeat_promise===null){missed_heartbeats=0;heartbeat_promise=$interval(sendHeartbeat,5e3)}};$websocket.onclose=function(evt){_console.log("Disconnected");deferred.reject();wait_for_reconnect=Math.min(wait_for_reconnect+1e3,1e4);$timeout(function(){$websocket.connect(ws_url)},wait_for_reconnect)};$websocket.onerror=function(evt){_console.error("Websocket connection is broken!");$websocket.close()};$websocket.onmessage=function(evt){var data;if(evt.data===heartbeat_msg){missed_heartbeats=0;return}try{data=angular.fromJson(evt.data)}catch(e){_console.warn("Data received by server is invalid JSON: "+evt.data);return}if(is_subscriber){receiving=true;scope.$apply(function(){angular.extend(scope[collection],data)});receiving=false}};function sendHeartbeat(){try{missed_heartbeats++;if(missed_heartbeats>3)throw new Error("Too many missed heartbeats.");$websocket.send(heartbeat_msg)}catch(e){$interval.cancel(heartbeat_promise);heartbeat_promise=null;_console.warn("Closing connection. Reason: "+e.message);$websocket.close()}}function listener(newValue,oldValue){if(!receiving&&!angular.equals(oldValue,newValue)){$websocket.send(angular.toJson(newValue))}}function setChannels(channels){angular.forEach(channels,function(channel){if(channel.substring(0,9)==="subscribe"){is_subscriber=true}else if(channel.substring(0,7)==="publish"){is_publisher=true}})}function watchCollection(){scope.$watchCollection(collection,listener)}function buildWebsocketURL(facility,channels){var parts=[websocket_uri,facility,"?"];parts.push(channels.join("&"));ws_url=parts.join("")}return{connect:function($scope,scope_obj,facility,channels){scope=$scope;setChannels(channels);collection=scope_obj;scope[collection]=scope[collection]||{};buildWebsocketURL(facility,channels);connect();if(is_publisher){deferred.promise.then(watchCollection)}return deferred.promise}}}]})})(window.angular);angular.module("djng",["djng.forms","djng.urls"]);