# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pytwitter', 'pytwitter.models', 'pytwitter.utils']

package_data = \
{'': ['*']}

install_requires = \
['Authlib>=0.15.4,<0.16.0',
 'dataclasses-json>=0.5.2,<0.6.0',
 'requests>=2.24,<3.0']

setup_kwargs = {
    'name': 'python-twitter-v2',
    'version': '0.7.1',
    'description': 'A simple Python wrapper for Twitter API v2 ✨ 🍰 ✨',
    'long_description': 'python-twitter\n\nA simple Python wrapper around for Twitter API v2 :sparkles: :cake: :sparkles:.\n\n.. image:: https://img.shields.io/endpoint?url=https%3A%2F%2Ftwbadges.glitch.me%2Fbadges%2Fv2\n   :target: https://developer.twitter.com/en/docs/twitter-api\n   :alt: v2\n\n.. image:: https://github.com/sns-sdks/python-twitter/workflows/Test/badge.svg\n    :target: https://github.com/sns-sdks/python-twitter/actions\n    :alt: Build Status\n\n.. image:: https://codecov.io/gh/sns-sdks/python-twitter/branch/master/graph/badge.svg\n    :target: https://codecov.io/gh/sns-sdks/python-twitter\n    :alt: Codecov\n\n.. image:: https://img.shields.io/pypi/v/python-twitter-v2.svg\n    :target: https://pypi.org/project/python-twitter-v2/\n    :alt: PyPI\n\n\n\n============\nIntroduction\n============\n\nTwitter has published new version `Twitter API V2 <https://twitter.com/TwitterDev/status/1293593516040269825>`_ for developer at Aug 13, 2020.\n\nThis library provides a service to easily use this new version Twitter API.\n\n=============\nDocumentation\n=============\n\nYou can get all api description and update at `Twitter API v2: Early Access <https://developer.twitter.com/en/docs/twitter-api/early-access>`_.\n\nLibrary docs site on `here <https://sns-sdks.github.io/python-twitter/>`_\n\n\n==========\nInstalling\n==========\n\nYou can install this library easily by `pypi`:\n\n.. code-block:: shell\n\n    $ pip install python-twitter-v2\n\nCode is hosted at `https://github.com/sns-sdks/python-twitter <https://github.com/sns-sdks/python-twitter>`_.\n\nCheckout latest development version with:\n\n.. code-block:: shell\n\n    $ git clone https://github.com/sns-sdks/python-twitter.git\n    $ cd python-twitter\n\nInstall dependencies with:\n\n.. code-block:: shell\n\n    $ make env\n\n\nRun tests with:\n\n.. code-block:: shell\n\n    $ make test\n\nRun tests with coverage:\n\n.. code-block:: shell\n\n    $ make cov-term\n    $ make cov-html\n\n=====\nUsing\n=====\n\nThe API is exposed via the ``pytwitter.Api`` class.\n\nNow cover features:\n\n- Tweets\n    - Tweet lookup\n    - Manage Tweets\n    - Timelines\n    - Search Tweets\n    - Tweet counts\n    - Filtered stream\n    - Volume streams\n    - Retweets\n    - Likes\n    - Hide replies\n\n- Users\n    - User lookup\n    - Follows\n    - Blocks\n    - Mutes\n\n- Spaces\n    - Spaces lookup\n    - Search Spaces\n\n- Compliance\n    - Batch compliance\n\n- Lists\n    - List lookup\n    - Manage lists\n    - List Tweets lookup\n    - List members\n    - List follows\n    - Pinned Lists\n\n-----------\nINSTANTIATE\n-----------\n\nYou can initialize with an bearer token:\n\n.. code-block:: python\n\n    >>> from pytwitter import Api\n    >>> api = Api(bearer_token="Your bearer token")\n\nWith user context token:\n\n.. code-block:: python\n\n    >>> api = Api(\n            consumer_key="consumer key",\n            consumer_secret="consumer secret",\n            access_token="access token",\n            access_secret="access secret"\n        )\n\nOr with authorize by user:\n\n.. code-block:: python\n\n    >>> api = Api(consumer_key="consumer key",consumer_secret="consumer secret",oauth_flow=True)\n    # get url for user to authorize\n    >>> api.get_authorize_url()\n    # copy the response url\n    >>> api.generate_access_token("https://localhost/?oauth_token=oauth_token&oauth_verifier=oauth_verifier")\n    {\'oauth_token\': \'oauth_token\',\n     \'oauth_token_secret\': \'oauth_token_secret\',\n     \'user_id\': \'123456\',\n     \'screen_name\': \'screen name\'}\n\nTwitter has `announcing OAuth 2.0 beta <https://twittercommunity.com/t/announcing-oauth-2-0-beta/159189>`_\n\nNow if you have app with ``OAuth2.0`` client ID. you can do authorize with ``OAuth2``.\n\n.. code-block:: python\n\n    >>> api = Api(client_id="You client ID", oauth_flow=True)\n    # get the url and code verifier for user to authorize\n    >>> url, code_verifier, _ = api.get_oauth2_authorize_url()\n    # copy the response url\n    >>> api.generate_oauth2_access_token("https://localhost/?state=state&code=code", code_verifier)\n    {\'token_type\': \'bearer\',\n     \'expires_in\': 7200,\n     \'access_token\': \'access_token\',\n     \'scope\': \'users.read tweet.read\',\n     \'expires_at\': 1631775928}\n\n\n------------\nUsers-lookup\n------------\n\nYou can get information about a user or group of users, specified by a user ID or a username.\n\nGet group of users:\n\n.. code-block:: python\n\n    # By ids\n    >>> api.get_users(ids=["783214", "2244994945"])\n    Response(data=[User(id=\'2244994945\', name=\'Twitter Dev\', username=\'TwitterDev\'), User(id=\'783214\', name=\'Twitter\', username=\'Twitter\')])\n\n    # By username\n    >>> api.get_users(usernames="Twitter,TwitterDev")\n    Response(data=[User(id=\'2244994945\', name=\'Twitter Dev\', username=\'TwitterDev\'), User(id=\'783214\', name=\'Twitter\', username=\'Twitter\')])\n\nGet single user:\n\n.. code-block:: python\n\n    # By id\n    >>> api.get_user(user_id="783214")\n    Response(data=User(id=\'783214\', name=\'Twitter\', username=\'Twitter\'))\n\n    # By username\n    >>> api.get_user(username="Twitter")\n    Response(data=User(id=\'783214\', name=\'Twitter\', username=\'Twitter\'))\n\nGet user following:\n\n.. code-block:: python\n\n    >>> api.get_following(user_id="2244994945", max_results=5)\n    Response(data=[User(id=\'459860328\', name=\'julie✨\', username=\'JulieMendoza206\'), User(id=\'273830767\', name=\'🄿🅄🅂🄷\', username=\'rahul_pushkarna\')...])\n\nGet user followers:\n\n.. code-block:: python\n\n    >>> api.get_followers(user_id="2244994945", max_results=5)\n    Response(data=[User(id=\'715131097332518912\', name=\'Daniel\', username=\'RGIDaniel\'), User(id=\'1176323137757048832\', name=\'Joyce Wang\', username=\'joycew67\')...])\n\n\nYou can follow or unfollow user if you have OAuth 1.0a User context.\n\nfollow user:\n\n.. code-block:: python\n\n    >>> api.follow_user(user_id="123456", target_user_id="654321")\n    {\'data\': {\'following\': True, \'pending_follow\': False}}\n\n\nunfollow user:\n\n.. code-block:: python\n\n    >>> api.unfollow_user(user_id="123456", target_user_id="654321")\n    {\'data\': {\'following\': False}}\n\n-------------\nTweets-lookup\n-------------\n\nYou can get information about a tweet or group of tweets by tweet id(s).\n\nGet single tweet:\n\n.. code-block:: python\n\n    >>> api.get_tweet("1354143047324299264", expansions=["attachments.media_keys"], media_fields=["type","duration_ms"])\n    Response(data=Tweet(id=1354143047324299264, text=Academics are one of the biggest groups using...))\n\nGet group of tweets:\n\n.. code-block:: python\n\n    >>> api.get_tweets(["1261326399320715264","1278347468690915330"],expansions="author_id",tweet_fields=["created_at"], user_fields=["username","verified"])\n    Response(data=[Tweet(id=1261326399320715264, text=Tune in to the @MongoDB @Twitch stream...), Tweet(id=1278347468690915330, text=Good news and bad news: 2020 is half over)])\n\n-------------\nStreaming API\n-------------\n\nFor Streaming, this provide `StreamApi` independent. Same as main `Api`, You need initial it first.\n\n.. code-block:: python\n\n    >>> from pytwitter import StreamApi\n    >>> stream_api = StreamApi(bearer_token="bearer token")\n    # or use consumer key and secret\n    >>> stream_api = StreamApi(consumer_key="consumer key", consumer_secret="consumer secret")\n\n\nFor Sample Stream tweets, You can use `sample_stream` function to build a connection.\n\n.. code-block:: python\n\n    >>> stream_api.sample_stream()\n\nFor Search Stream, You can point your rules.\n\nGet your current rules.\n\n.. code-block:: python\n\n    >>> stream_api.get_rules()\n    Response(data=[StreamRule(id=\'1369580714056843266\', value=\'twitter api \')])\n\nDelete You rules.\n\n.. code-block:: python\n\n    >>> stream_api.manage_rules(rules={"delete": {"ids": ["1369580714056843266"]}})\n    Response(data=[])\n\nAdd new rules. If you set `dry_run` to True, will only validate rules, and not create them.\n\n.. code-block:: python\n\n    >>> np = {\n            "add": [\n                {"value": "cat has:media", "tag": "cats with media"},\n                {"value": "cat has:media -grumpy", "tag": "happy cats with media"}\n            ]\n         }\n    >>> stream_api.manage_rules(rules=np, dry_run=True)\n    Response(data=[StreamRule(id=\'1370406958721732610\', value=\'cat has:media -grumpy\'), StreamRule(id=\'1370406958721732609\', value=\'cat has:media\')])\n\nThen you can use `search_stream` to get tweets match your rules.\n\n.. code-block:: python\n\n    >>> stream_api.search_stream()\n\n\nYou can go to the `Example folder <examples>`_ for streaming examples.\n\n====\nTODO\n====\n\n- More Api waiting twitter\n\n',
    'author': 'ikaroskun',
    'author_email': 'merle.liukun@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sns-sdks/python-twitter',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
