"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsUiReactTsWebsiteProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const web_1 = require("projen/lib/web");
/**
 * Synthesizes a AWS UI React Typescript Website Project.
 *
 * @pjid awsui-react-ts-website
 */
class AwsUiReactTsWebsiteProject extends web_1.ReactTypeScriptProject {
    constructor(options) {
        super({
            defaultReleaseBranch: options.defaultReleaseBranch,
            name: options.name,
            sampleCode: false,
            devDeps: ["@babel/plugin-proposal-private-property-in-object"],
            deps: [
                "@awsui/global-styles",
                "@awsui/components-react",
                "@awsui/collection-hooks",
                "react-router-dom",
                "aws-amplify",
                "@aws-amplify/ui-react",
            ],
            readme: {
                contents: fs
                    .readFileSync(path.resolve(__dirname, "../README.md"))
                    .toString(),
            },
            gitignore: ["runtime-config.json"],
        });
        this.applicationName = options.applicationName ?? "Sample App";
        this.publicDir = options.publicDir ?? "public";
        const srcDir = path.resolve(__dirname, "../sample/src");
        new projen_1.SampleDir(this, this.srcdir, {
            files: {
                ...Object.fromEntries(fs
                    .readdirSync(srcDir)
                    .filter((f) => f !== "config.json")
                    .map((name) => [
                    name,
                    fs.readFileSync(`${srcDir}/${name}`).toString(),
                ])),
                "config.json": JSON.stringify({
                    applicationName: this.applicationName,
                }, undefined, 2),
            },
        });
        const publicDir = path.resolve(__dirname, "../sample/public");
        new projen_1.SampleDir(this, this.publicDir, {
            sourceDir: publicDir,
            files: {
                // override index.html to pass through applicationName
                "index.html": fs
                    .readFileSync(`${publicDir}/index.html`)
                    .toString()
                    .replace("<title></title>", `<title>${this.applicationName}</title>`),
            },
        });
    }
}
exports.AwsUiReactTsWebsiteProject = AwsUiReactTsWebsiteProject;
_a = JSII_RTTI_SYMBOL_1;
AwsUiReactTsWebsiteProject[_a] = { fqn: "@aws-prototyping-sdk/awsui-react-ts-website.AwsUiReactTsWebsiteProject", version: "0.2.6" };
//# sourceMappingURL=data:application/json;base64,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