# Generated by Django 2.2.10 on 2020-03-05 02:38

from django.db import migrations, models
import django.db.models.deletion
import django_ckeditor_5.fields
import mptt.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Article',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=64, verbose_name='Title')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('content', django_ckeditor_5.fields.CKEditor5Field(blank=True, null=True, verbose_name='Content')),
                ('published', models.BooleanField(verbose_name='Published')),
                ('published_time', models.DateTimeField(blank=True, null=True, verbose_name='Published Time')),
                ('preview_image', models.ImageField(blank=True, null=True, upload_to='article-preview-images', verbose_name='Preview Image')),
                ('show_preview_image', models.BooleanField(default=False, verbose_name='Show Preview Image')),
                ('order', models.IntegerField(blank=True, null=True, verbose_name='Order')),
                ('priority', models.IntegerField(default=99, verbose_name='Priority')),
                ('label', models.CharField(blank=True, choices=[('Set Top', 'Set Top'), ('Important', 'Important'), ('Good News', 'Good News'), ('Warning', 'Warning')], max_length=16, null=True, verbose_name='Label')),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='django_power_cms.Article', verbose_name='Article Parent')),
            ],
            options={
                'verbose_name': 'Article',
                'verbose_name_plural': 'Articles',
            },
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, verbose_name='Name')),
                ('code', models.CharField(max_length=64, unique=True, verbose_name='Code')),
                ('order', models.IntegerField(blank=True, null=True, verbose_name='Order')),
                ('published', models.NullBooleanField(verbose_name='Published')),
                ('published_time', models.DateTimeField(blank=True, null=True, verbose_name='Published Time')),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('parent', mptt.fields.TreeForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='children', to='django_power_cms.Page', verbose_name='Parent Page')),
            ],
            options={
                'verbose_name': 'Page',
                'verbose_name_plural': 'Pages',
            },
        ),
        migrations.CreateModel(
            name='Template',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, verbose_name='Name')),
                ('app_label', models.CharField(blank=True, max_length=64, null=True, verbose_name='App Label')),
                ('app_verbose_name', models.CharField(blank=True, max_length=64, null=True, verbose_name='App Verbose Name')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('preview_image', models.CharField(blank=True, max_length=128, null=True, verbose_name='Preview Image')),
                ('template', models.CharField(max_length=128, verbose_name='Template File')),
            ],
            options={
                'verbose_name': 'Template',
                'verbose_name_plural': 'Templates',
            },
        ),
        migrations.CreateModel(
            name='Theme',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, verbose_name='Name')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description')),
                ('is_default', models.BooleanField(default=False, verbose_name='Is default theme')),
            ],
            options={
                'verbose_name': 'Theme',
                'verbose_name_plural': 'Themes',
            },
        ),
        migrations.CreateModel(
            name='Widget',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('app_label', models.CharField(blank=True, editable=False, max_length=64, verbose_name='App Label')),
                ('model_name', models.CharField(blank=True, editable=False, max_length=64, verbose_name='Model Name')),
                ('type_name', models.CharField(blank=True, editable=False, max_length=64, verbose_name='Type Name')),
                ('name', models.CharField(max_length=64, verbose_name='Name')),
                ('title', models.CharField(blank=True, max_length=128, null=True, verbose_name='Title')),
                ('widget_with_border', models.BooleanField(default=False, verbose_name='Widget With border')),
                ('widget_body_padding', models.CharField(blank=True, default='10px', max_length=16, null=True, verbose_name='Widget Body Pading')),
                ('widget_style', models.CharField(blank=True, max_length=256, null=True, verbose_name='Widget Style')),
                ('widget_header_style', models.CharField(blank=True, max_length=256, null=True, verbose_name='Widget Header Style')),
                ('widget_body_style', models.CharField(blank=True, max_length=256, null=True, verbose_name='Widget Body Style')),
                ('widget_footer_style', models.CharField(blank=True, max_length=256, null=True, verbose_name='Widget Footer Style')),
                ('widget_class', models.CharField(blank=True, max_length=256, null=True, verbose_name='Widget Class')),
                ('widget_header_class', models.CharField(blank=True, max_length=256, null=True, verbose_name='Widget Header Class')),
                ('widget_body_class', models.CharField(blank=True, max_length=256, null=True, verbose_name='Widget Body Class')),
                ('widget_footer_class', models.CharField(blank=True, max_length=256, null=True, verbose_name='Widget Footer Class')),
            ],
            options={
                'verbose_name': 'Widget',
                'verbose_name_plural': 'Widgets',
            },
        ),
        migrations.CreateModel(
            name='CarouselWidget',
            fields=[
                ('widget_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='django_power_cms.Widget')),
                ('width', models.IntegerField(blank=True, null=True, verbose_name='Width')),
                ('height', models.IntegerField(blank=True, null=True, verbose_name='Height')),
            ],
            options={
                'verbose_name': 'Carousel Widget',
                'verbose_name_plural': 'Carousel Widgets',
            },
            bases=('django_power_cms.widget',),
        ),
        migrations.CreateModel(
            name='StaticHtmlWidget',
            fields=[
                ('widget_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='django_power_cms.Widget')),
                ('html', models.TextField(blank=True, null=True, verbose_name='HTML Code')),
            ],
            options={
                'verbose_name': 'Static HTML Widget',
                'verbose_name_plural': 'Static HTML Widgets',
            },
            bases=('django_power_cms.widget',),
        ),
        migrations.CreateModel(
            name='StaticListWidget',
            fields=[
                ('widget_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='django_power_cms.Widget')),
                ('max_display_count', models.IntegerField(blank=True, null=True, verbose_name='Max Display Count')),
                ('empty_display_message', models.TextField(blank=True, null=True, verbose_name='Empty Display Message')),
            ],
            options={
                'verbose_name': 'Static List Widget',
                'verbose_name_plural': 'Static List Widgets',
            },
            bases=('django_power_cms.widget',),
        ),
        migrations.CreateModel(
            name='TopbarWidget',
            fields=[
                ('widget_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='django_power_cms.Widget')),
                ('brand_link', models.CharField(blank=True, max_length=128, null=True, verbose_name='Brand Link')),
                ('brand_link_target', models.CharField(blank=True, max_length=32, null=True, verbose_name='Brand Link Target')),
                ('welcome_message_for_login_user', models.CharField(blank=True, max_length=128, null=True, verbose_name='Welcome Message For Login User')),
                ('welcome_message_for_anonymous_user', models.CharField(blank=True, max_length=128, null=True, verbose_name='Welcome Message For Anonymous User')),
                ('fix_position', models.BooleanField(default=False, verbose_name='Fix Position')),
                ('show_login_or_logout_link', models.BooleanField(default=False, verbose_name='Show Login Or Logout Link')),
                ('login_link', models.CharField(blank=True, max_length=128, null=True, verbose_name='Login Link')),
                ('logout_link', models.CharField(blank=True, max_length=128, null=True, verbose_name='Logout Link')),
                ('show_change_password_link', models.BooleanField(default=False, verbose_name='Show Change Password Link')),
                ('change_password_link', models.CharField(blank=True, max_length=128, null=True, verbose_name='Change Password Link')),
            ],
            options={
                'verbose_name': 'Topbar Widget',
                'verbose_name_plural': 'Topbar Widgets',
            },
            bases=('django_power_cms.widget',),
        ),
        migrations.CreateModel(
            name='WidgetLink',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('role', models.IntegerField(choices=[(1, 'Top Left'), (2, 'Top Right'), (3, 'Bottom Left'), (4, 'Bottom Right')], verbose_name='Widget Link Role')),
                ('title', models.CharField(max_length=32, verbose_name='Title')),
                ('url', models.CharField(max_length=128, verbose_name='Url')),
                ('icon', models.CharField(blank=True, max_length=64, null=True, verbose_name='Icon Class')),
                ('target', models.CharField(blank=True, max_length=16, null=True, verbose_name='Link Target')),
                ('Widget', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='links', to='django_power_cms.Widget', verbose_name='Widget')),
            ],
            options={
                'verbose_name': 'Widget Link',
                'verbose_name_plural': 'Widget Links',
            },
        ),
        migrations.CreateModel(
            name='ThemeJs',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('js', models.CharField(max_length=128, verbose_name='JS File')),
                ('order', models.IntegerField(verbose_name='Order')),
                ('theme', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='js_files', to='django_power_cms.Theme', verbose_name='Theme')),
            ],
            options={
                'verbose_name': 'Theme JS',
                'verbose_name_plural': 'Theme JSes',
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='ThemeCss',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('css', models.CharField(max_length=128, verbose_name='CSS File')),
                ('order', models.IntegerField(verbose_name='Order')),
                ('theme', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='css_files', to='django_power_cms.Theme', verbose_name='Theme')),
            ],
            options={
                'verbose_name': 'Theme CSS',
                'verbose_name_plural': 'Theme CSSes',
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='TemplateSlot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=32, verbose_name='Code')),
                ('name', models.CharField(max_length=32, verbose_name='Name')),
                ('template', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='slots', to='django_power_cms.Template', verbose_name='Template')),
            ],
            options={
                'verbose_name': 'Template Slots',
                'unique_together': {('template', 'code')},
            },
        ),
        migrations.CreateModel(
            name='Site',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, verbose_name='Name')),
                ('code', models.CharField(max_length=64, unique=True, verbose_name='Code')),
                ('published', models.BooleanField(verbose_name='Published')),
                ('published_time', models.DateTimeField(blank=True, null=True, verbose_name='Published Time')),
                ('index_page_code', models.CharField(blank=True, max_length=64, null=True, verbose_name='Index Page Code')),
                ('theme', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_power_cms.Theme', verbose_name='Theme')),
            ],
            options={
                'verbose_name': 'Site',
                'verbose_name_plural': 'Sites',
            },
        ),
        migrations.CreateModel(
            name='PageWidget',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField(default=0, verbose_name='Order')),
                ('page', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='widget_bindings', to='django_power_cms.Page', verbose_name='Page')),
                ('slot', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='django_power_cms.TemplateSlot', verbose_name='Slot')),
                ('widget', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='django_power_cms.Widget', verbose_name='Widget')),
            ],
            options={
                'verbose_name': 'Page Widget Binding',
                'verbose_name_plural': 'Page Widget Bindings',
                'ordering': ['slot', 'order'],
            },
        ),
        migrations.AddField(
            model_name='page',
            name='site',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pages', to='django_power_cms.Site', verbose_name='Site'),
        ),
        migrations.AddField(
            model_name='page',
            name='template',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_power_cms.Template', verbose_name='Template'),
        ),
        migrations.AddField(
            model_name='page',
            name='theme',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_power_cms.Theme', verbose_name='Theme'),
        ),
        migrations.CreateModel(
            name='ArticleContentImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to='article-content-images', verbose_name='Image')),
                ('article', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='images', to='django_power_cms.Article', verbose_name='Article')),
            ],
            options={
                'verbose_name': 'Article Content Image',
                'verbose_name_plural': 'Article Content Images',
            },
        ),
        migrations.CreateModel(
            name='TopbarBrand',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(blank=True, null=True, upload_to='brand-images', verbose_name='Image')),
                ('title', models.CharField(blank=True, max_length=64, null=True, verbose_name='Title')),
                ('url', models.CharField(blank=True, max_length=128, null=True, verbose_name='URL')),
                ('order', models.IntegerField(default=0, verbose_name='Order')),
                ('topbar', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='brands', to='django_power_cms.TopbarWidget', verbose_name='Topbar')),
            ],
            options={
                'verbose_name': 'Topbar Brand',
                'verbose_name_plural': 'Topbar Brands',
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='StaticListItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=128, verbose_name='Title')),
                ('url', models.CharField(blank=True, max_length=512, null=True, verbose_name='URL')),
                ('target', models.CharField(blank=True, max_length=32, null=True, verbose_name='URL Target')),
                ('order', models.IntegerField(default=0, verbose_name='Order')),
                ('label', models.CharField(max_length=128, verbose_name='Label')),
                ('label_class', models.CharField(max_length=32, verbose_name='Label Class')),
                ('thelist', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='lists', to='django_power_cms.StaticListWidget', verbose_name='The Static List Widget')),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='CarouselWidgetImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to='carousel-images', verbose_name='Image')),
                ('url', models.CharField(blank=True, max_length=512, null=True, verbose_name='URL')),
                ('target', models.CharField(blank=True, max_length=32, null=True, verbose_name='URL Target')),
                ('order', models.IntegerField(default=0, verbose_name='Order')),
                ('carousel', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='images', to='django_power_cms.CarouselWidget', verbose_name='Carousel')),
            ],
            options={
                'verbose_name': 'Carousel Widget Image',
                'verbose_name_plural': 'Carousel Widget Images',
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='ArticleListWidget',
            fields=[
                ('widget_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='django_power_cms.Widget')),
                ('max_display_count', models.IntegerField(default=10, verbose_name='Max Display Count')),
                ('empty_display_message', models.TextField(blank=True, null=True, verbose_name='Empty Display Message')),
                ('root', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_power_cms.Article', verbose_name='Root')),
            ],
            options={
                'verbose_name': 'Article List Widget',
                'verbose_name_plural': 'Article List Widgets',
            },
            bases=('django_power_cms.widget',),
        ),
    ]
