/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

public class SerialNumber {
    private long m_nValue = 0L;

    public synchronized void setLongCurrentValue(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Attempt to set serial number to negative value " + l);
        }
        this.m_nValue = l;
    }

    public synchronized long getLongCurrentValue() {
        return this.m_nValue;
    }

    public synchronized int getIntCurrentValue() {
        if (this.m_nValue > Integer.MAX_VALUE) {
            throw new IllegalStateException("Serial number value " + this.m_nValue + " exceeds Integer.MAX_VALUE");
        }
        return (int)this.m_nValue;
    }

    public synchronized long getLongNextValue() {
        if (this.m_nValue == Long.MAX_VALUE) {
            throw new IllegalStateException("Attempt to increment serial number value past Long.MAX_VALUE");
        }
        ++this.m_nValue;
        return this.m_nValue;
    }

    public synchronized int getIntNextValue() {
        if (this.m_nValue >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Attempt to increment serial number value " + this.m_nValue + " past Integer.MAX_VALUE");
        }
        ++this.m_nValue;
        return (int)this.m_nValue;
    }
}

