# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['splunk_add_on_ucc_framework',
 'splunk_add_on_ucc_framework.alert_utils',
 'splunk_add_on_ucc_framework.alert_utils.alert_utils_common',
 'splunk_add_on_ucc_framework.alert_utils.alert_utils_common.metric_collector',
 'splunk_add_on_ucc_framework.arf_dir_templates.modular_alert_package.${product_id}.lib',
 'splunk_add_on_ucc_framework.arf_dir_templates.modular_alert_package.${product_id}.lib.splunk_aoblib',
 'splunk_add_on_ucc_framework.modular_alert_builder',
 'splunk_add_on_ucc_framework.modular_alert_builder.build_core',
 'splunk_add_on_ucc_framework.splunktaucclib',
 'splunk_add_on_ucc_framework.splunktaucclib.global_config',
 'splunk_add_on_ucc_framework.splunktaucclib.rest_handler',
 'splunk_add_on_ucc_framework.splunktaucclib.rest_handler.endpoint',
 'splunk_add_on_ucc_framework.uccrestbuilder',
 'splunk_add_on_ucc_framework.uccrestbuilder.endpoint']

package_data = \
{'': ['*'],
 'splunk_add_on_ucc_framework': ['arf_dir_templates/*',
                                 'arf_dir_templates/modular_alert_package/${product_id}/appserver/static/*',
                                 'templates/*'],
 'splunk_add_on_ucc_framework.modular_alert_builder.build_core': ['arf_template/*',
                                                                  'arf_template/default_html_theme/*']}

install_requires = \
['future>=0,<1',
 'jinja2>=2,<3',
 'lxml>=4.3,<5.0',
 'mako>=1,<2',
 'munch>=2,<3',
 'solnlib>=2.1,<3.0',
 'splunk-sdk>=1.6,<2.0']

entry_points = \
{'console_scripts': ['build-ucc = build:build_ucc',
                     'install-libs = '
                     'splunk_add_on_ucc_framework:install_requirements',
                     'ucc-gen = splunk_add_on_ucc_framework:main']}

setup_kwargs = {
    'name': 'splunk-add-on-ucc-framework',
    'version': '4.0.4',
    'description': 'Splunk Add-on SDK formerly UCC is a build and code generation framework',
    'long_description': '',
    'author': 'rfaircloth-splunk',
    'author_email': 'rfaircloth@splunk.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/splunk/splunk-add-on-sdk-python/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
