from django.utils.translation import ugettext


BASE_STRUCTURE_TAG_TYPE_DIV = 'div'
BASE_STRUCTURE_TAG_TYPE_ARTICLE = 'article'
BASE_STRUCTURE_TAG_TYPE_SECTION = 'section'
BASE_STRUCTURE_TAG_TYPE_HEADER = 'header'
BASE_STRUCTURE_TAG_TYPE_FOOTER = 'footer'
BASE_STRUCTURE_TAG_TYPE_ASIDE = 'aside'

BASE_STRUCTURE_TAG_TYPES_CHOICES = (
    (BASE_STRUCTURE_TAG_TYPE_DIV, ugettext('div')),
    (BASE_STRUCTURE_TAG_TYPE_ARTICLE, ugettext('article')),
    (BASE_STRUCTURE_TAG_TYPE_SECTION, ugettext('section')),
    (BASE_STRUCTURE_TAG_TYPE_HEADER, ugettext('header')),
    (BASE_STRUCTURE_TAG_TYPE_FOOTER, ugettext('footer')),
    (BASE_STRUCTURE_TAG_TYPE_ASIDE, ugettext('aside')),
)

VARIANT_GRID_CONTAINER_CLASS_NO_CONTAINER = "no-container"
VARIANT_GRID_CONTAINER_CLASS_BOXED = "container"
VARIANT_GRID_CONTAINER_CLASS_FLUID_UNTIL_SM = "container-sm"
VARIANT_GRID_CONTAINER_CLASS_FLUID_UNTIL_MD = "container-md"
VARIANT_GRID_CONTAINER_CLASS_FLUID_UNTIL_LG = "container-lg"
VARIANT_GRID_CONTAINER_CLASS_FLUID_UNTIL_XL = "container-xl"
VARIANT_GRID_CONTAINER_CLASS_TOTALLY_FLUID = "container-fluid"

VARIANT_GRID_CONTAINER_CLASS_CHOICES = (
    (VARIANT_GRID_CONTAINER_CLASS_NO_CONTAINER, ugettext("No container only for bg")),
    (VARIANT_GRID_CONTAINER_CLASS_BOXED, ugettext("Boxed")),
    (VARIANT_GRID_CONTAINER_CLASS_FLUID_UNTIL_SM, ugettext("Fluid until sm")),
    (VARIANT_GRID_CONTAINER_CLASS_FLUID_UNTIL_MD, ugettext("Fluid until md")),
    (VARIANT_GRID_CONTAINER_CLASS_FLUID_UNTIL_LG, ugettext("Fluid until lg")),
    (VARIANT_GRID_CONTAINER_CLASS_FLUID_UNTIL_XL, ugettext("Fluid until xl")),
    (VARIANT_GRID_CONTAINER_CLASS_TOTALLY_FLUID, ugettext("Totally fluid")),
)

TAG_TYPE_GRID_CONTAINER_SECTION = "section"
TAG_TYPE_GRID_CONTAINER_DIV = "div"

TAG_TYPE_GRID_CONTAINER_CLASS_CHOICES = (
    (TAG_TYPE_GRID_CONTAINER_SECTION, ugettext("Section")),
    (TAG_TYPE_GRID_CONTAINER_DIV, ugettext("Div")),
)


VARIANT_GRID_ROW_CLASS_LEFT = "start"
VARIANT_GRID_ROW_CLASS_CENTER = "center"
VARIANT_GRID_ROW_CLASS_RIGHT = "end"
VARIANT_GRID_ROW_CLASS_AROUND = "around"
VARIANT_GRID_ROW_CLASS_BETWEEN = "between"

VARIANT_GRID_ROW_CLASSES_CHOICES = (
    (VARIANT_GRID_ROW_CLASS_LEFT, ugettext("Align left")),
    (VARIANT_GRID_ROW_CLASS_CENTER, ugettext("Align center")),
    (VARIANT_GRID_ROW_CLASS_RIGHT, ugettext("Align right")),
    (VARIANT_GRID_ROW_CLASS_AROUND, ugettext("Align around")),
    (VARIANT_GRID_ROW_CLASS_BETWEEN, ugettext("Align between"))
)
