# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest  # noqa: E501
    The version of the OpenAPI document: 1.0.2
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class DeploymentDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'deployment_tool': 'str',
        'deployment_tool_version': 'str',
        'last_updated_date': 'str'
    }

    attribute_map = {
        'deployment_tool': 'deploymentTool',
        'deployment_tool_version': 'deploymentToolVersion',
        'last_updated_date': 'lastUpdatedDate'
    }

    def __init__(self, deployment_tool=None, deployment_tool_version=None, last_updated_date=None, local_vars_configuration=None):  # noqa: E501
        """DeploymentDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._deployment_tool = None
        self._deployment_tool_version = None
        self._last_updated_date = None
        self.discriminator = None

        self.deployment_tool = deployment_tool
        self.deployment_tool_version = deployment_tool_version
        self.last_updated_date = last_updated_date

    @property
    def deployment_tool(self):
        """Gets the deployment_tool of this DeploymentDTO.  # noqa: E501

        The tool used to create, maintain and deploy the node. Examples: symbol-bootstrap, manual.  # noqa: E501

        :return: The deployment_tool of this DeploymentDTO.  # noqa: E501
        :rtype: str
        """
        return self._deployment_tool

    @deployment_tool.setter
    def deployment_tool(self, deployment_tool):
        """Sets the deployment_tool of this DeploymentDTO.

        The tool used to create, maintain and deploy the node. Examples: symbol-bootstrap, manual.  # noqa: E501

        :param deployment_tool: The deployment_tool of this DeploymentDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and deployment_tool is None:  # noqa: E501
            raise ValueError("Invalid value for `deployment_tool`, must not be `None`")  # noqa: E501

        self._deployment_tool = deployment_tool

    @property
    def deployment_tool_version(self):
        """Gets the deployment_tool_version of this DeploymentDTO.  # noqa: E501

        The version of the tool used to create, maintain and deploy the node.  # noqa: E501

        :return: The deployment_tool_version of this DeploymentDTO.  # noqa: E501
        :rtype: str
        """
        return self._deployment_tool_version

    @deployment_tool_version.setter
    def deployment_tool_version(self, deployment_tool_version):
        """Sets the deployment_tool_version of this DeploymentDTO.

        The version of the tool used to create, maintain and deploy the node.  # noqa: E501

        :param deployment_tool_version: The deployment_tool_version of this DeploymentDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and deployment_tool_version is None:  # noqa: E501
            raise ValueError("Invalid value for `deployment_tool_version`, must not be `None`")  # noqa: E501

        self._deployment_tool_version = deployment_tool_version

    @property
    def last_updated_date(self):
        """Gets the last_updated_date of this DeploymentDTO.  # noqa: E501

        When was the node last upgraded.  # noqa: E501

        :return: The last_updated_date of this DeploymentDTO.  # noqa: E501
        :rtype: str
        """
        return self._last_updated_date

    @last_updated_date.setter
    def last_updated_date(self, last_updated_date):
        """Sets the last_updated_date of this DeploymentDTO.

        When was the node last upgraded.  # noqa: E501

        :param last_updated_date: The last_updated_date of this DeploymentDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and last_updated_date is None:  # noqa: E501
            raise ValueError("Invalid value for `last_updated_date`, must not be `None`")  # noqa: E501

        self._last_updated_date = last_updated_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeploymentDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DeploymentDTO):
            return True

        return self.to_dict() != other.to_dict()
