# Generated by Django 3.0.8 on 2020-07-14 04:45

import datavalidation.results
from django.db import migrations, models
import django.db.models.deletion
import enumfields.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Summary',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name_plural': 'summaries',
                'managed': False,
            },
        ),
        migrations.CreateModel(
            name='Validator',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('exc_type', models.TextField(blank=True, default=None, null=True)),
                ('exc_traceback', models.TextField(blank=True, default=None, max_length=2000, null=True)),
                ('exc_obj_pk', models.PositiveIntegerField(blank=True, null=True)),
                ('app_label', models.CharField(max_length=100)),
                ('model_name', models.CharField(max_length=100)),
                ('method_name', models.CharField(max_length=100)),
                ('description', models.TextField(max_length=100)),
                ('is_class_method', models.BooleanField()),
                ('last_run_time', models.DateTimeField(blank=True, null=True)),
                ('status', enumfields.fields.EnumIntegerField(default=0, enum=datavalidation.results.Status)),
                ('num_passing', models.PositiveIntegerField(blank=True, null=True)),
                ('num_na', models.PositiveIntegerField(blank=True, null=True)),
            ],
            options={
                'ordering': ('app_label', 'model_name', 'method_name'),
                'unique_together': {('app_label', 'model_name', 'method_name')},
                'index_together': {('app_label', 'model_name', 'method_name')},
            },
        ),
        migrations.CreateModel(
            name='FailingObject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_pk', models.PositiveIntegerField()),
                ('is_exception', models.BooleanField()),
                ('comment', models.TextField(blank=True)),
                ('allowed_to_fail', models.BooleanField(default=False)),
                ('allowed_to_fail_justification', models.TextField(blank=True, verbose_name='justification')),
                ('is_valid', models.BooleanField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='contenttypes.ContentType')),
                ('validator', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='failing_objects', to='datavalidation.Validator')),
            ],
            options={
                'ordering': ('object_pk',),
                'unique_together': {('validator', 'object_pk')},
                'index_together': {('validator', 'object_pk')},
            },
        ),
    ]
