import warnings


def _warnings(*args, **kwargs):
    if len(args) > 0:
        warnings.warn(f"Received unassigned args with args: {args}.", UserWarning)
    if len(kwargs) > 0:
        kwarg_str = ", ".join([f"{k}:{v}" for k, v in kwargs.items()])
        warnings.warn(f"Received unassigned kwargs: \n{kwarg_str}", UserWarning)
