# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class AddHotlineNumberRequestOutboundRangeList(TeaModel):
    def __init__(
        self,
        department_id: int = None,
        group_id_list: List[int] = None,
    ):
        self.department_id = department_id
        self.group_id_list = group_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        return self


class AddHotlineNumberRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        enable_inbound: bool = None,
        enable_inbound_evaluation: bool = None,
        enable_outbound: bool = None,
        enable_outbound_evaluation: bool = None,
        evaluation_level: int = None,
        hotline_number: str = None,
        inbound_flow_id: int = None,
        instance_id: str = None,
        outbound_all_depart: bool = None,
        outbound_range_list: List[AddHotlineNumberRequestOutboundRangeList] = None,
    ):
        self.description = description
        self.enable_inbound = enable_inbound
        self.enable_inbound_evaluation = enable_inbound_evaluation
        self.enable_outbound = enable_outbound
        self.enable_outbound_evaluation = enable_outbound_evaluation
        self.evaluation_level = evaluation_level
        self.hotline_number = hotline_number
        self.inbound_flow_id = inbound_flow_id
        self.instance_id = instance_id
        self.outbound_all_depart = outbound_all_depart
        self.outbound_range_list = outbound_range_list

    def validate(self):
        if self.outbound_range_list:
            for k in self.outbound_range_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_inbound is not None:
            result['EnableInbound'] = self.enable_inbound
        if self.enable_inbound_evaluation is not None:
            result['EnableInboundEvaluation'] = self.enable_inbound_evaluation
        if self.enable_outbound is not None:
            result['EnableOutbound'] = self.enable_outbound
        if self.enable_outbound_evaluation is not None:
            result['EnableOutboundEvaluation'] = self.enable_outbound_evaluation
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.inbound_flow_id is not None:
            result['InboundFlowId'] = self.inbound_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_all_depart is not None:
            result['OutboundAllDepart'] = self.outbound_all_depart
        result['OutboundRangeList'] = []
        if self.outbound_range_list is not None:
            for k in self.outbound_range_list:
                result['OutboundRangeList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableInbound') is not None:
            self.enable_inbound = m.get('EnableInbound')
        if m.get('EnableInboundEvaluation') is not None:
            self.enable_inbound_evaluation = m.get('EnableInboundEvaluation')
        if m.get('EnableOutbound') is not None:
            self.enable_outbound = m.get('EnableOutbound')
        if m.get('EnableOutboundEvaluation') is not None:
            self.enable_outbound_evaluation = m.get('EnableOutboundEvaluation')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InboundFlowId') is not None:
            self.inbound_flow_id = m.get('InboundFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundAllDepart') is not None:
            self.outbound_all_depart = m.get('OutboundAllDepart')
        self.outbound_range_list = []
        if m.get('OutboundRangeList') is not None:
            for k in m.get('OutboundRangeList'):
                temp_model = AddHotlineNumberRequestOutboundRangeList()
                self.outbound_range_list.append(temp_model.from_map(k))
        return self


class AddHotlineNumberShrinkRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        enable_inbound: bool = None,
        enable_inbound_evaluation: bool = None,
        enable_outbound: bool = None,
        enable_outbound_evaluation: bool = None,
        evaluation_level: int = None,
        hotline_number: str = None,
        inbound_flow_id: int = None,
        instance_id: str = None,
        outbound_all_depart: bool = None,
        outbound_range_list_shrink: str = None,
    ):
        self.description = description
        self.enable_inbound = enable_inbound
        self.enable_inbound_evaluation = enable_inbound_evaluation
        self.enable_outbound = enable_outbound
        self.enable_outbound_evaluation = enable_outbound_evaluation
        self.evaluation_level = evaluation_level
        self.hotline_number = hotline_number
        self.inbound_flow_id = inbound_flow_id
        self.instance_id = instance_id
        self.outbound_all_depart = outbound_all_depart
        self.outbound_range_list_shrink = outbound_range_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_inbound is not None:
            result['EnableInbound'] = self.enable_inbound
        if self.enable_inbound_evaluation is not None:
            result['EnableInboundEvaluation'] = self.enable_inbound_evaluation
        if self.enable_outbound is not None:
            result['EnableOutbound'] = self.enable_outbound
        if self.enable_outbound_evaluation is not None:
            result['EnableOutboundEvaluation'] = self.enable_outbound_evaluation
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.inbound_flow_id is not None:
            result['InboundFlowId'] = self.inbound_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_all_depart is not None:
            result['OutboundAllDepart'] = self.outbound_all_depart
        if self.outbound_range_list_shrink is not None:
            result['OutboundRangeList'] = self.outbound_range_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableInbound') is not None:
            self.enable_inbound = m.get('EnableInbound')
        if m.get('EnableInboundEvaluation') is not None:
            self.enable_inbound_evaluation = m.get('EnableInboundEvaluation')
        if m.get('EnableOutbound') is not None:
            self.enable_outbound = m.get('EnableOutbound')
        if m.get('EnableOutboundEvaluation') is not None:
            self.enable_outbound_evaluation = m.get('EnableOutboundEvaluation')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InboundFlowId') is not None:
            self.inbound_flow_id = m.get('InboundFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundAllDepart') is not None:
            self.outbound_all_depart = m.get('OutboundAllDepart')
        if m.get('OutboundRangeList') is not None:
            self.outbound_range_list_shrink = m.get('OutboundRangeList')
        return self


class AddHotlineNumberResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddHotlineNumberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddHotlineNumberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddHotlineNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddOuterAccountRequest(TeaModel):
    def __init__(
        self,
        avatar: str = None,
        ext: str = None,
        outer_account_id: str = None,
        outer_account_name: str = None,
        outer_account_type: str = None,
        outer_department_id: str = None,
        outer_department_type: str = None,
        outer_group_ids: str = None,
        outer_group_type: str = None,
        real_name: str = None,
    ):
        self.avatar = avatar
        self.ext = ext
        self.outer_account_id = outer_account_id
        self.outer_account_name = outer_account_name
        self.outer_account_type = outer_account_type
        self.outer_department_id = outer_department_id
        self.outer_department_type = outer_department_type
        self.outer_group_ids = outer_group_ids
        self.outer_group_type = outer_group_type
        self.real_name = real_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar is not None:
            result['Avatar'] = self.avatar
        if self.ext is not None:
            result['Ext'] = self.ext
        if self.outer_account_id is not None:
            result['OuterAccountId'] = self.outer_account_id
        if self.outer_account_name is not None:
            result['OuterAccountName'] = self.outer_account_name
        if self.outer_account_type is not None:
            result['OuterAccountType'] = self.outer_account_type
        if self.outer_department_id is not None:
            result['OuterDepartmentId'] = self.outer_department_id
        if self.outer_department_type is not None:
            result['OuterDepartmentType'] = self.outer_department_type
        if self.outer_group_ids is not None:
            result['OuterGroupIds'] = self.outer_group_ids
        if self.outer_group_type is not None:
            result['OuterGroupType'] = self.outer_group_type
        if self.real_name is not None:
            result['RealName'] = self.real_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Avatar') is not None:
            self.avatar = m.get('Avatar')
        if m.get('Ext') is not None:
            self.ext = m.get('Ext')
        if m.get('OuterAccountId') is not None:
            self.outer_account_id = m.get('OuterAccountId')
        if m.get('OuterAccountName') is not None:
            self.outer_account_name = m.get('OuterAccountName')
        if m.get('OuterAccountType') is not None:
            self.outer_account_type = m.get('OuterAccountType')
        if m.get('OuterDepartmentId') is not None:
            self.outer_department_id = m.get('OuterDepartmentId')
        if m.get('OuterDepartmentType') is not None:
            self.outer_department_type = m.get('OuterDepartmentType')
        if m.get('OuterGroupIds') is not None:
            self.outer_group_ids = m.get('OuterGroupIds')
        if m.get('OuterGroupType') is not None:
            self.outer_group_type = m.get('OuterGroupType')
        if m.get('RealName') is not None:
            self.real_name = m.get('RealName')
        return self


class AddOuterAccountResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddOuterAccountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddOuterAccountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddOuterAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSkillGroupRequest(TeaModel):
    def __init__(
        self,
        outer_department_id: str = None,
        outer_department_type: str = None,
        outer_group_id: str = None,
        outer_group_name: str = None,
        outer_group_type: str = None,
    ):
        self.outer_department_id = outer_department_id
        self.outer_department_type = outer_department_type
        self.outer_group_id = outer_group_id
        self.outer_group_name = outer_group_name
        self.outer_group_type = outer_group_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outer_department_id is not None:
            result['OuterDepartmentId'] = self.outer_department_id
        if self.outer_department_type is not None:
            result['OuterDepartmentType'] = self.outer_department_type
        if self.outer_group_id is not None:
            result['OuterGroupId'] = self.outer_group_id
        if self.outer_group_name is not None:
            result['OuterGroupName'] = self.outer_group_name
        if self.outer_group_type is not None:
            result['OuterGroupType'] = self.outer_group_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OuterDepartmentId') is not None:
            self.outer_department_id = m.get('OuterDepartmentId')
        if m.get('OuterDepartmentType') is not None:
            self.outer_department_type = m.get('OuterDepartmentType')
        if m.get('OuterGroupId') is not None:
            self.outer_group_id = m.get('OuterGroupId')
        if m.get('OuterGroupName') is not None:
            self.outer_group_name = m.get('OuterGroupName')
        if m.get('OuterGroupType') is not None:
            self.outer_group_type = m.get('OuterGroupType')
        return self


class AddSkillGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddSkillGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddSkillGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AiccsSmartCallRequest(TeaModel):
    def __init__(
        self,
        action_code_break: bool = None,
        action_code_time_break: int = None,
        asr_als_am_id: str = None,
        asr_base_id: str = None,
        asr_model_id: str = None,
        asr_vocabulary_id: str = None,
        background_file_code: str = None,
        background_speed: int = None,
        background_volume: int = None,
        called_number: str = None,
        called_show_number: str = None,
        dynamic_id: str = None,
        early_media_asr: bool = None,
        enable_itn: bool = None,
        mute_time: int = None,
        out_id: str = None,
        owner_id: int = None,
        pause_time: int = None,
        play_times: int = None,
        prod_code: str = None,
        record_flag: bool = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        session_timeout: int = None,
        speed: int = None,
        tts_conf: bool = None,
        tts_speed: int = None,
        tts_style: str = None,
        tts_volume: int = None,
        voice_code: str = None,
        voice_code_param: str = None,
        volume: int = None,
    ):
        self.action_code_break = action_code_break
        self.action_code_time_break = action_code_time_break
        self.asr_als_am_id = asr_als_am_id
        self.asr_base_id = asr_base_id
        self.asr_model_id = asr_model_id
        self.asr_vocabulary_id = asr_vocabulary_id
        self.background_file_code = background_file_code
        self.background_speed = background_speed
        self.background_volume = background_volume
        self.called_number = called_number
        self.called_show_number = called_show_number
        self.dynamic_id = dynamic_id
        self.early_media_asr = early_media_asr
        self.enable_itn = enable_itn
        self.mute_time = mute_time
        self.out_id = out_id
        self.owner_id = owner_id
        self.pause_time = pause_time
        self.play_times = play_times
        self.prod_code = prod_code
        self.record_flag = record_flag
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.session_timeout = session_timeout
        self.speed = speed
        self.tts_conf = tts_conf
        self.tts_speed = tts_speed
        self.tts_style = tts_style
        self.tts_volume = tts_volume
        self.voice_code = voice_code
        self.voice_code_param = voice_code_param
        self.volume = volume

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_code_break is not None:
            result['ActionCodeBreak'] = self.action_code_break
        if self.action_code_time_break is not None:
            result['ActionCodeTimeBreak'] = self.action_code_time_break
        if self.asr_als_am_id is not None:
            result['AsrAlsAmId'] = self.asr_als_am_id
        if self.asr_base_id is not None:
            result['AsrBaseId'] = self.asr_base_id
        if self.asr_model_id is not None:
            result['AsrModelId'] = self.asr_model_id
        if self.asr_vocabulary_id is not None:
            result['AsrVocabularyId'] = self.asr_vocabulary_id
        if self.background_file_code is not None:
            result['BackgroundFileCode'] = self.background_file_code
        if self.background_speed is not None:
            result['BackgroundSpeed'] = self.background_speed
        if self.background_volume is not None:
            result['BackgroundVolume'] = self.background_volume
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.called_show_number is not None:
            result['CalledShowNumber'] = self.called_show_number
        if self.dynamic_id is not None:
            result['DynamicId'] = self.dynamic_id
        if self.early_media_asr is not None:
            result['EarlyMediaAsr'] = self.early_media_asr
        if self.enable_itn is not None:
            result['EnableITN'] = self.enable_itn
        if self.mute_time is not None:
            result['MuteTime'] = self.mute_time
        if self.out_id is not None:
            result['OutId'] = self.out_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pause_time is not None:
            result['PauseTime'] = self.pause_time
        if self.play_times is not None:
            result['PlayTimes'] = self.play_times
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.record_flag is not None:
            result['RecordFlag'] = self.record_flag
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.session_timeout is not None:
            result['SessionTimeout'] = self.session_timeout
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.tts_conf is not None:
            result['TtsConf'] = self.tts_conf
        if self.tts_speed is not None:
            result['TtsSpeed'] = self.tts_speed
        if self.tts_style is not None:
            result['TtsStyle'] = self.tts_style
        if self.tts_volume is not None:
            result['TtsVolume'] = self.tts_volume
        if self.voice_code is not None:
            result['VoiceCode'] = self.voice_code
        if self.voice_code_param is not None:
            result['VoiceCodeParam'] = self.voice_code_param
        if self.volume is not None:
            result['Volume'] = self.volume
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionCodeBreak') is not None:
            self.action_code_break = m.get('ActionCodeBreak')
        if m.get('ActionCodeTimeBreak') is not None:
            self.action_code_time_break = m.get('ActionCodeTimeBreak')
        if m.get('AsrAlsAmId') is not None:
            self.asr_als_am_id = m.get('AsrAlsAmId')
        if m.get('AsrBaseId') is not None:
            self.asr_base_id = m.get('AsrBaseId')
        if m.get('AsrModelId') is not None:
            self.asr_model_id = m.get('AsrModelId')
        if m.get('AsrVocabularyId') is not None:
            self.asr_vocabulary_id = m.get('AsrVocabularyId')
        if m.get('BackgroundFileCode') is not None:
            self.background_file_code = m.get('BackgroundFileCode')
        if m.get('BackgroundSpeed') is not None:
            self.background_speed = m.get('BackgroundSpeed')
        if m.get('BackgroundVolume') is not None:
            self.background_volume = m.get('BackgroundVolume')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CalledShowNumber') is not None:
            self.called_show_number = m.get('CalledShowNumber')
        if m.get('DynamicId') is not None:
            self.dynamic_id = m.get('DynamicId')
        if m.get('EarlyMediaAsr') is not None:
            self.early_media_asr = m.get('EarlyMediaAsr')
        if m.get('EnableITN') is not None:
            self.enable_itn = m.get('EnableITN')
        if m.get('MuteTime') is not None:
            self.mute_time = m.get('MuteTime')
        if m.get('OutId') is not None:
            self.out_id = m.get('OutId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PauseTime') is not None:
            self.pause_time = m.get('PauseTime')
        if m.get('PlayTimes') is not None:
            self.play_times = m.get('PlayTimes')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('RecordFlag') is not None:
            self.record_flag = m.get('RecordFlag')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SessionTimeout') is not None:
            self.session_timeout = m.get('SessionTimeout')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('TtsConf') is not None:
            self.tts_conf = m.get('TtsConf')
        if m.get('TtsSpeed') is not None:
            self.tts_speed = m.get('TtsSpeed')
        if m.get('TtsStyle') is not None:
            self.tts_style = m.get('TtsStyle')
        if m.get('TtsVolume') is not None:
            self.tts_volume = m.get('TtsVolume')
        if m.get('VoiceCode') is not None:
            self.voice_code = m.get('VoiceCode')
        if m.get('VoiceCodeParam') is not None:
            self.voice_code_param = m.get('VoiceCodeParam')
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        return self


class AiccsSmartCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AiccsSmartCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AiccsSmartCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AiccsSmartCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AiccsSmartCallOperateRequest(TeaModel):
    def __init__(
        self,
        call_id: str = None,
        command: str = None,
        owner_id: int = None,
        param: str = None,
        prod_code: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.call_id = call_id
        self.command = command
        self.owner_id = owner_id
        self.param = param
        self.prod_code = prod_code
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.command is not None:
            result['Command'] = self.command
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.param is not None:
            result['Param'] = self.param
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AiccsSmartCallOperateResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AiccsSmartCallOperateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AiccsSmartCallOperateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AiccsSmartCallOperateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AnswerCallRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        call_id: str = None,
        client_token: str = None,
        connection_id: str = None,
        instance_id: str = None,
        job_id: str = None,
    ):
        self.account_name = account_name
        self.call_id = call_id
        self.client_token = client_token
        self.connection_id = connection_id
        self.instance_id = instance_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class AnswerCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AnswerCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AnswerCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AnswerCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachTaskRequest(TeaModel):
    def __init__(
        self,
        call_string: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        task_id: int = None,
    ):
        self.call_string = call_string
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_string is not None:
            result['CallString'] = self.call_string
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallString') is not None:
            self.call_string = m.get('CallString')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class AttachTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AttachTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateQualityProjectsRequest(TeaModel):
    def __init__(
        self,
        analysis_ids: List[int] = None,
        channel_touch_type: List[int] = None,
        check_freq_type: int = None,
        instance_list: List[str] = None,
        project_name: str = None,
        time_range_end: str = None,
        time_range_start: str = None,
    ):
        self.analysis_ids = analysis_ids
        self.channel_touch_type = channel_touch_type
        self.check_freq_type = check_freq_type
        self.instance_list = instance_list
        self.project_name = project_name
        self.time_range_end = time_range_end
        self.time_range_start = time_range_start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_ids is not None:
            result['AnalysisIds'] = self.analysis_ids
        if self.channel_touch_type is not None:
            result['ChannelTouchType'] = self.channel_touch_type
        if self.check_freq_type is not None:
            result['CheckFreqType'] = self.check_freq_type
        if self.instance_list is not None:
            result['InstanceList'] = self.instance_list
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.time_range_end is not None:
            result['TimeRangeEnd'] = self.time_range_end
        if self.time_range_start is not None:
            result['TimeRangeStart'] = self.time_range_start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnalysisIds') is not None:
            self.analysis_ids = m.get('AnalysisIds')
        if m.get('ChannelTouchType') is not None:
            self.channel_touch_type = m.get('ChannelTouchType')
        if m.get('CheckFreqType') is not None:
            self.check_freq_type = m.get('CheckFreqType')
        if m.get('InstanceList') is not None:
            self.instance_list = m.get('InstanceList')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TimeRangeEnd') is not None:
            self.time_range_end = m.get('TimeRangeEnd')
        if m.get('TimeRangeStart') is not None:
            self.time_range_start = m.get('TimeRangeStart')
        return self


class BatchCreateQualityProjectsResponseBodyData(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        project_id: int = None,
        version: int = None,
    ):
        self.instance_id = instance_id
        self.project_id = project_id
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class BatchCreateQualityProjectsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[BatchCreateQualityProjectsResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchCreateQualityProjectsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCreateQualityProjectsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchCreateQualityProjectsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateQualityProjectsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelTaskRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        task_id: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CancelTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeChatAgentStatusRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        instance_id: str = None,
        method: str = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.instance_id = instance_id
        self.method = method

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.method is not None:
            result['Method'] = self.method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        return self


class ChangeChatAgentStatusResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ChangeChatAgentStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeChatAgentStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeChatAgentStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeQualityProjectStatusRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        project_id: int = None,
        status: int = None,
    ):
        self.instance_id = instance_id
        self.project_id = project_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ChangeQualityProjectStatusResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ChangeQualityProjectStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeQualityProjectStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeQualityProjectStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAgentRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        display_name: str = None,
        instance_id: str = None,
        skill_group_id: List[int] = None,
        skill_group_id_list: List[int] = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.display_name = display_name
        self.instance_id = instance_id
        self.skill_group_id = skill_group_id
        self.skill_group_id_list = skill_group_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class CreateAgentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateAgentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAgentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAgentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAiOutboundTaskRequestRecallRule(TeaModel):
    def __init__(
        self,
        count: int = None,
        interval: int = None,
    ):
        self.count = count
        self.interval = interval

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class CreateAiOutboundTaskRequest(TeaModel):
    def __init__(
        self,
        concurrent_rate: int = None,
        description: str = None,
        execution_time: str = None,
        forecast_call_rate: float = None,
        handler_id: int = None,
        instance_id: str = None,
        name: str = None,
        num_repeated: int = None,
        outbound_nums: List[str] = None,
        recall_rule: CreateAiOutboundTaskRequestRecallRule = None,
        type: int = None,
    ):
        self.concurrent_rate = concurrent_rate
        self.description = description
        self.execution_time = execution_time
        self.forecast_call_rate = forecast_call_rate
        self.handler_id = handler_id
        self.instance_id = instance_id
        self.name = name
        self.num_repeated = num_repeated
        self.outbound_nums = outbound_nums
        self.recall_rule = recall_rule
        self.type = type

    def validate(self):
        if self.recall_rule:
            self.recall_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrent_rate is not None:
            result['ConcurrentRate'] = self.concurrent_rate
        if self.description is not None:
            result['Description'] = self.description
        if self.execution_time is not None:
            result['ExecutionTime'] = self.execution_time
        if self.forecast_call_rate is not None:
            result['ForecastCallRate'] = self.forecast_call_rate
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.num_repeated is not None:
            result['NumRepeated'] = self.num_repeated
        if self.outbound_nums is not None:
            result['OutboundNums'] = self.outbound_nums
        if self.recall_rule is not None:
            result['RecallRule'] = self.recall_rule.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcurrentRate') is not None:
            self.concurrent_rate = m.get('ConcurrentRate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExecutionTime') is not None:
            self.execution_time = m.get('ExecutionTime')
        if m.get('ForecastCallRate') is not None:
            self.forecast_call_rate = m.get('ForecastCallRate')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumRepeated') is not None:
            self.num_repeated = m.get('NumRepeated')
        if m.get('OutboundNums') is not None:
            self.outbound_nums = m.get('OutboundNums')
        if m.get('RecallRule') is not None:
            temp_model = CreateAiOutboundTaskRequestRecallRule()
            self.recall_rule = temp_model.from_map(m['RecallRule'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateAiOutboundTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        concurrent_rate: int = None,
        description: str = None,
        execution_time: str = None,
        forecast_call_rate: float = None,
        handler_id: int = None,
        instance_id: str = None,
        name: str = None,
        num_repeated: int = None,
        outbound_nums_shrink: str = None,
        recall_rule_shrink: str = None,
        type: int = None,
    ):
        self.concurrent_rate = concurrent_rate
        self.description = description
        self.execution_time = execution_time
        self.forecast_call_rate = forecast_call_rate
        self.handler_id = handler_id
        self.instance_id = instance_id
        self.name = name
        self.num_repeated = num_repeated
        self.outbound_nums_shrink = outbound_nums_shrink
        self.recall_rule_shrink = recall_rule_shrink
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrent_rate is not None:
            result['ConcurrentRate'] = self.concurrent_rate
        if self.description is not None:
            result['Description'] = self.description
        if self.execution_time is not None:
            result['ExecutionTime'] = self.execution_time
        if self.forecast_call_rate is not None:
            result['ForecastCallRate'] = self.forecast_call_rate
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.num_repeated is not None:
            result['NumRepeated'] = self.num_repeated
        if self.outbound_nums_shrink is not None:
            result['OutboundNums'] = self.outbound_nums_shrink
        if self.recall_rule_shrink is not None:
            result['RecallRule'] = self.recall_rule_shrink
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcurrentRate') is not None:
            self.concurrent_rate = m.get('ConcurrentRate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExecutionTime') is not None:
            self.execution_time = m.get('ExecutionTime')
        if m.get('ForecastCallRate') is not None:
            self.forecast_call_rate = m.get('ForecastCallRate')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumRepeated') is not None:
            self.num_repeated = m.get('NumRepeated')
        if m.get('OutboundNums') is not None:
            self.outbound_nums_shrink = m.get('OutboundNums')
        if m.get('RecallRule') is not None:
            self.recall_rule_shrink = m.get('RecallRule')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateAiOutboundTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateAiOutboundTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAiOutboundTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAiOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAiOutboundTaskBatchRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        task_id: int = None,
    ):
        self.instance_id = instance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateAiOutboundTaskBatchResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateAiOutboundTaskBatchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAiOutboundTaskBatchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAiOutboundTaskBatchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDepartmentRequest(TeaModel):
    def __init__(
        self,
        department_name: str = None,
        instance_id: str = None,
    ):
        self.department_name = department_name
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_name is not None:
            result['DepartmentName'] = self.department_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentName') is not None:
            self.department_name = m.get('DepartmentName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateDepartmentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDepartmentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDepartmentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDepartmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOutboundTaskRequest(TeaModel):
    def __init__(
        self,
        ani: str = None,
        call_infos: str = None,
        department_id: int = None,
        description: str = None,
        end_date: str = None,
        end_time: str = None,
        ext_attrs: str = None,
        group_name: str = None,
        instance_id: str = None,
        model: int = None,
        retry_interval: int = None,
        retry_time: int = None,
        skill_group: int = None,
        start_date: str = None,
        start_time: str = None,
        task_name: str = None,
        task_type: int = None,
    ):
        self.ani = ani
        self.call_infos = call_infos
        self.department_id = department_id
        self.description = description
        self.end_date = end_date
        self.end_time = end_time
        self.ext_attrs = ext_attrs
        self.group_name = group_name
        self.instance_id = instance_id
        self.model = model
        self.retry_interval = retry_interval
        self.retry_time = retry_time
        self.skill_group = skill_group
        self.start_date = start_date
        self.start_time = start_time
        self.task_name = task_name
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ani is not None:
            result['Ani'] = self.ani
        if self.call_infos is not None:
            result['CallInfos'] = self.call_infos
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.description is not None:
            result['Description'] = self.description
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ext_attrs is not None:
            result['ExtAttrs'] = self.ext_attrs
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.model is not None:
            result['Model'] = self.model
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_time is not None:
            result['RetryTime'] = self.retry_time
        if self.skill_group is not None:
            result['SkillGroup'] = self.skill_group
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ani') is not None:
            self.ani = m.get('Ani')
        if m.get('CallInfos') is not None:
            self.call_infos = m.get('CallInfos')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExtAttrs') is not None:
            self.ext_attrs = m.get('ExtAttrs')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryTime') is not None:
            self.retry_time = m.get('RetryTime')
        if m.get('SkillGroup') is not None:
            self.skill_group = m.get('SkillGroup')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateOutboundTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOutboundTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOutboundTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityProjectRequest(TeaModel):
    def __init__(
        self,
        analysis_ids: List[int] = None,
        channel_touch_type: List[int] = None,
        check_freq_type: int = None,
        dep_list: List[int] = None,
        group_list: List[int] = None,
        instance_id: str = None,
        project_name: str = None,
        scope_type: int = None,
        servicer_list: List[str] = None,
        time_range_end: str = None,
        time_range_start: str = None,
    ):
        self.analysis_ids = analysis_ids
        self.channel_touch_type = channel_touch_type
        self.check_freq_type = check_freq_type
        self.dep_list = dep_list
        self.group_list = group_list
        self.instance_id = instance_id
        self.project_name = project_name
        self.scope_type = scope_type
        self.servicer_list = servicer_list
        self.time_range_end = time_range_end
        self.time_range_start = time_range_start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_ids is not None:
            result['AnalysisIds'] = self.analysis_ids
        if self.channel_touch_type is not None:
            result['ChannelTouchType'] = self.channel_touch_type
        if self.check_freq_type is not None:
            result['CheckFreqType'] = self.check_freq_type
        if self.dep_list is not None:
            result['DepList'] = self.dep_list
        if self.group_list is not None:
            result['GroupList'] = self.group_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.scope_type is not None:
            result['ScopeType'] = self.scope_type
        if self.servicer_list is not None:
            result['ServicerList'] = self.servicer_list
        if self.time_range_end is not None:
            result['TimeRangeEnd'] = self.time_range_end
        if self.time_range_start is not None:
            result['TimeRangeStart'] = self.time_range_start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnalysisIds') is not None:
            self.analysis_ids = m.get('AnalysisIds')
        if m.get('ChannelTouchType') is not None:
            self.channel_touch_type = m.get('ChannelTouchType')
        if m.get('CheckFreqType') is not None:
            self.check_freq_type = m.get('CheckFreqType')
        if m.get('DepList') is not None:
            self.dep_list = m.get('DepList')
        if m.get('GroupList') is not None:
            self.group_list = m.get('GroupList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ScopeType') is not None:
            self.scope_type = m.get('ScopeType')
        if m.get('ServicerList') is not None:
            self.servicer_list = m.get('ServicerList')
        if m.get('TimeRangeEnd') is not None:
            self.time_range_end = m.get('TimeRangeEnd')
        if m.get('TimeRangeStart') is not None:
            self.time_range_start = m.get('TimeRangeStart')
        return self


class CreateQualityProjectResponseBodyData(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        project_id: int = None,
        version: int = None,
    ):
        self.instance_id = instance_id
        self.project_id = project_id
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class CreateQualityProjectResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateQualityProjectResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateQualityProjectResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateQualityProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateQualityProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityRuleRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        key_words: List[str] = None,
        match_type: int = None,
        name: str = None,
        rule_tag: int = None,
    ):
        self.instance_id = instance_id
        self.key_words = key_words
        self.match_type = match_type
        self.name = name
        self.rule_tag = rule_tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.key_words is not None:
            result['KeyWords'] = self.key_words
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_tag is not None:
            result['RuleTag'] = self.rule_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('KeyWords') is not None:
            self.key_words = m.get('KeyWords')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleTag') is not None:
            self.rule_tag = m.get('RuleTag')
        return self


class CreateQualityRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateQualityRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSkillGroupRequest(TeaModel):
    def __init__(
        self,
        channel_type: int = None,
        client_token: str = None,
        department_id: int = None,
        description: str = None,
        display_name: str = None,
        instance_id: str = None,
        skill_group_name: str = None,
    ):
        self.channel_type = channel_type
        self.client_token = client_token
        self.department_id = department_id
        self.description = description
        self.display_name = display_name
        self.instance_id = instance_id
        self.skill_group_name = skill_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        return self


class CreateSkillGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSkillGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSkillGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTaskRequest(TeaModel):
    def __init__(
        self,
        call_string: str = None,
        call_string_type: str = None,
        caller: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        retry_count: int = None,
        retry_flag: int = None,
        retry_interval: int = None,
        retry_status_code: str = None,
        robot_id: str = None,
        seat_count: str = None,
        start_now: bool = None,
        task_name: str = None,
        work_day: str = None,
        work_time_list: str = None,
    ):
        self.call_string = call_string
        self.call_string_type = call_string_type
        self.caller = caller
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.retry_count = retry_count
        self.retry_flag = retry_flag
        self.retry_interval = retry_interval
        self.retry_status_code = retry_status_code
        self.robot_id = robot_id
        self.seat_count = seat_count
        self.start_now = start_now
        self.task_name = task_name
        self.work_day = work_day
        self.work_time_list = work_time_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_string is not None:
            result['CallString'] = self.call_string
        if self.call_string_type is not None:
            result['CallStringType'] = self.call_string_type
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.retry_flag is not None:
            result['RetryFlag'] = self.retry_flag
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_status_code is not None:
            result['RetryStatusCode'] = self.retry_status_code
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        if self.seat_count is not None:
            result['SeatCount'] = self.seat_count
        if self.start_now is not None:
            result['StartNow'] = self.start_now
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.work_day is not None:
            result['WorkDay'] = self.work_day
        if self.work_time_list is not None:
            result['WorkTimeList'] = self.work_time_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallString') is not None:
            self.call_string = m.get('CallString')
        if m.get('CallStringType') is not None:
            self.call_string_type = m.get('CallStringType')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('RetryFlag') is not None:
            self.retry_flag = m.get('RetryFlag')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryStatusCode') is not None:
            self.retry_status_code = m.get('RetryStatusCode')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        if m.get('SeatCount') is not None:
            self.seat_count = m.get('SeatCount')
        if m.get('StartNow') is not None:
            self.start_now = m.get('StartNow')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('WorkDay') is not None:
            self.work_day = m.get('WorkDay')
        if m.get('WorkTimeList') is not None:
            self.work_time_list = m.get('WorkTimeList')
        return self


class CreateTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateThirdSsoAgentRequest(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        client_id: str = None,
        client_token: str = None,
        display_name: str = None,
        instance_id: str = None,
        role_ids: List[int] = None,
        skill_group_ids: List[int] = None,
    ):
        self.account_id = account_id
        self.account_name = account_name
        self.client_id = client_id
        self.client_token = client_token
        self.display_name = display_name
        self.instance_id = instance_id
        self.role_ids = role_ids
        self.skill_group_ids = skill_group_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_ids is not None:
            result['RoleIds'] = self.role_ids
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleIds') is not None:
            self.role_ids = m.get('RoleIds')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        return self


class CreateThirdSsoAgentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        # requestId
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateThirdSsoAgentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateThirdSsoAgentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateThirdSsoAgentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAgentRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteAgentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteAgentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAgentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAgentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAiOutboundTaskRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        task_id: int = None,
    ):
        self.instance_id = instance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteAiOutboundTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteAiOutboundTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAiOutboundTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAiOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDepartmentRequest(TeaModel):
    def __init__(
        self,
        department_id: int = None,
        instance_id: str = None,
    ):
        self.department_id = department_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDepartmentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDepartmentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDepartmentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDepartmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHotlineNumberRequest(TeaModel):
    def __init__(
        self,
        hotline_number: str = None,
        instance_id: str = None,
    ):
        self.hotline_number = hotline_number
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteHotlineNumberResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHotlineNumberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHotlineNumberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHotlineNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOutboundTaskRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        outbound_task_id: int = None,
    ):
        self.instance_id = instance_id
        self.outbound_task_id = outbound_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_task_id is not None:
            result['OutboundTaskId'] = self.outbound_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundTaskId') is not None:
            self.outbound_task_id = m.get('OutboundTaskId')
        return self


class DeleteOutboundTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOutboundTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteOutboundTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOuterAccountRequest(TeaModel):
    def __init__(
        self,
        outer_account_id: str = None,
        outer_account_type: str = None,
    ):
        self.outer_account_id = outer_account_id
        self.outer_account_type = outer_account_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outer_account_id is not None:
            result['OuterAccountId'] = self.outer_account_id
        if self.outer_account_type is not None:
            result['OuterAccountType'] = self.outer_account_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OuterAccountId') is not None:
            self.outer_account_id = m.get('OuterAccountId')
        if m.get('OuterAccountType') is not None:
            self.outer_account_type = m.get('OuterAccountType')
        return self


class DeleteOuterAccountResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOuterAccountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteOuterAccountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOuterAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityProjectRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        project_id: int = None,
    ):
        self.instance_id = instance_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteQualityProjectResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteQualityProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteQualityProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityRuleRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
        instance_id: str = None,
    ):
        self.id = id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteQualityRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteQualityRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSkillGroupRequest(TeaModel):
    def __init__(
        self,
        outer_group_id: str = None,
        outer_group_type: str = None,
    ):
        self.outer_group_id = outer_group_id
        self.outer_group_type = outer_group_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outer_group_id is not None:
            result['OuterGroupId'] = self.outer_group_id
        if self.outer_group_type is not None:
            result['OuterGroupType'] = self.outer_group_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OuterGroupId') is not None:
            self.outer_group_id = m.get('OuterGroupId')
        if m.get('OuterGroupType') is not None:
            self.outer_group_type = m.get('OuterGroupType')
        return self


class DeleteSkillGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSkillGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSkillGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRecordDataRequest(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_type: str = None,
        acid: str = None,
        owner_id: int = None,
        prod_code: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        sec_level: int = None,
    ):
        self.account_id = account_id
        self.account_type = account_type
        self.acid = acid
        self.owner_id = owner_id
        self.prod_code = prod_code
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.sec_level = sec_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.sec_level is not None:
            result['SecLevel'] = self.sec_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecLevel') is not None:
            self.sec_level = m.get('SecLevel')
        return self


class DescribeRecordDataResponseBody(TeaModel):
    def __init__(
        self,
        acid: str = None,
        agent_id: str = None,
        code: str = None,
        message: str = None,
        oss_link: str = None,
        request_id: str = None,
    ):
        self.acid = acid
        self.agent_id = agent_id
        self.code = code
        self.message = message
        self.oss_link = oss_link
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.oss_link is not None:
            result['OssLink'] = self.oss_link
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OssLink') is not None:
            self.oss_link = m.get('OssLink')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRecordDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRecordDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRecordDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EditQualityProjectRequest(TeaModel):
    def __init__(
        self,
        analysis_ids: List[int] = None,
        channel_touch_type: List[int] = None,
        check_freq_type: int = None,
        dep_list: List[int] = None,
        group_list: List[int] = None,
        instance_id: str = None,
        project_id: int = None,
        project_name: str = None,
        project_version: int = None,
        scope_type: int = None,
        servicer_list: List[str] = None,
        time_range_end: str = None,
        time_range_start: str = None,
    ):
        self.analysis_ids = analysis_ids
        self.channel_touch_type = channel_touch_type
        self.check_freq_type = check_freq_type
        self.dep_list = dep_list
        self.group_list = group_list
        self.instance_id = instance_id
        self.project_id = project_id
        self.project_name = project_name
        self.project_version = project_version
        self.scope_type = scope_type
        self.servicer_list = servicer_list
        self.time_range_end = time_range_end
        self.time_range_start = time_range_start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_ids is not None:
            result['AnalysisIds'] = self.analysis_ids
        if self.channel_touch_type is not None:
            result['ChannelTouchType'] = self.channel_touch_type
        if self.check_freq_type is not None:
            result['CheckFreqType'] = self.check_freq_type
        if self.dep_list is not None:
            result['DepList'] = self.dep_list
        if self.group_list is not None:
            result['GroupList'] = self.group_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_version is not None:
            result['ProjectVersion'] = self.project_version
        if self.scope_type is not None:
            result['ScopeType'] = self.scope_type
        if self.servicer_list is not None:
            result['ServicerList'] = self.servicer_list
        if self.time_range_end is not None:
            result['TimeRangeEnd'] = self.time_range_end
        if self.time_range_start is not None:
            result['TimeRangeStart'] = self.time_range_start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AnalysisIds') is not None:
            self.analysis_ids = m.get('AnalysisIds')
        if m.get('ChannelTouchType') is not None:
            self.channel_touch_type = m.get('ChannelTouchType')
        if m.get('CheckFreqType') is not None:
            self.check_freq_type = m.get('CheckFreqType')
        if m.get('DepList') is not None:
            self.dep_list = m.get('DepList')
        if m.get('GroupList') is not None:
            self.group_list = m.get('GroupList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectVersion') is not None:
            self.project_version = m.get('ProjectVersion')
        if m.get('ScopeType') is not None:
            self.scope_type = m.get('ScopeType')
        if m.get('ServicerList') is not None:
            self.servicer_list = m.get('ServicerList')
        if m.get('TimeRangeEnd') is not None:
            self.time_range_end = m.get('TimeRangeEnd')
        if m.get('TimeRangeStart') is not None:
            self.time_range_start = m.get('TimeRangeStart')
        return self


class EditQualityProjectResponseBodyData(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        project_id: int = None,
        version: int = None,
    ):
        self.instance_id = instance_id
        self.project_id = project_id
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class EditQualityProjectResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[EditQualityProjectResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = EditQualityProjectResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EditQualityProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EditQualityProjectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EditQualityProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EditQualityRuleRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        key_words: List[str] = None,
        match_type: int = None,
        name: str = None,
        quality_rule_id: int = None,
        rule_tag: int = None,
    ):
        self.instance_id = instance_id
        self.key_words = key_words
        self.match_type = match_type
        self.name = name
        self.quality_rule_id = quality_rule_id
        self.rule_tag = rule_tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.key_words is not None:
            result['KeyWords'] = self.key_words
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.name is not None:
            result['Name'] = self.name
        if self.quality_rule_id is not None:
            result['QualityRuleId'] = self.quality_rule_id
        if self.rule_tag is not None:
            result['RuleTag'] = self.rule_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('KeyWords') is not None:
            self.key_words = m.get('KeyWords')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('QualityRuleId') is not None:
            self.quality_rule_id = m.get('QualityRuleId')
        if m.get('RuleTag') is not None:
            self.rule_tag = m.get('RuleTag')
        return self


class EditQualityRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EditQualityRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EditQualityRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EditQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EditQualityRuleTagRequestAnalysisTypes(TeaModel):
    def __init__(
        self,
        id: int = None,
        name: str = None,
    ):
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class EditQualityRuleTagRequest(TeaModel):
    def __init__(
        self,
        analysis_types: List[EditQualityRuleTagRequestAnalysisTypes] = None,
        instance_id: str = None,
    ):
        self.analysis_types = analysis_types
        self.instance_id = instance_id

    def validate(self):
        if self.analysis_types:
            for k in self.analysis_types:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AnalysisTypes'] = []
        if self.analysis_types is not None:
            for k in self.analysis_types:
                result['AnalysisTypes'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.analysis_types = []
        if m.get('AnalysisTypes') is not None:
            for k in m.get('AnalysisTypes'):
                temp_model = EditQualityRuleTagRequestAnalysisTypes()
                self.analysis_types.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class EditQualityRuleTagResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EditQualityRuleTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EditQualityRuleTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EditQualityRuleTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EncryptPhoneNumRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        phone_num: str = None,
    ):
        self.instance_id = instance_id
        self.phone_num = phone_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        return self


class EncryptPhoneNumResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EncryptPhoneNumResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EncryptPhoneNumResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EncryptPhoneNumResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FetchCallRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        call_id: str = None,
        client_token: str = None,
        connection_id: str = None,
        hold_connection_id: str = None,
        instance_id: str = None,
        job_id: str = None,
    ):
        self.account_name = account_name
        self.call_id = call_id
        self.client_token = client_token
        self.connection_id = connection_id
        self.hold_connection_id = hold_connection_id
        self.instance_id = instance_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.hold_connection_id is not None:
            result['HoldConnectionId'] = self.hold_connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('HoldConnectionId') is not None:
            self.hold_connection_id = m.get('HoldConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class FetchCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class FetchCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FetchCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FetchCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FinishHotlineServiceRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class FinishHotlineServiceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class FinishHotlineServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FinishHotlineServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FinishHotlineServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateWebSocketSignRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GenerateWebSocketSignResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateWebSocketSignResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GenerateWebSocketSignResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateWebSocketSignResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetAgentResponseBodyDataGroupList(TeaModel):
    def __init__(
        self,
        channel_type: int = None,
        description: str = None,
        display_name: str = None,
        name: str = None,
        skill_group_id: int = None,
    ):
        self.channel_type = channel_type
        self.description = description
        self.display_name = display_name
        self.name = name
        self.skill_group_id = skill_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.name is not None:
            result['Name'] = self.name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class GetAgentResponseBodyData(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        agent_id: int = None,
        display_name: str = None,
        group_list: List[GetAgentResponseBodyDataGroupList] = None,
        status: int = None,
        tenant_id: int = None,
    ):
        self.account_name = account_name
        self.agent_id = agent_id
        self.display_name = display_name
        self.group_list = group_list
        self.status = status
        self.tenant_id = tenant_id

    def validate(self):
        if self.group_list:
            for k in self.group_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        result['GroupList'] = []
        if self.group_list is not None:
            for k in self.group_list:
                result['GroupList'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        self.group_list = []
        if m.get('GroupList') is not None:
            for k in m.get('GroupList'):
                temp_model = GetAgentResponseBodyDataGroupList()
                self.group_list.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetAgentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAgentResponseBodyData = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAgentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentBasisStatusRequest(TeaModel):
    def __init__(
        self,
        agent_ids: List[int] = None,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.agent_ids = agent_ids
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetAgentBasisStatusShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_ids_shrink: str = None,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.agent_ids_shrink = agent_ids_shrink
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetAgentBasisStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetAgentBasisStatusResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAgentBasisStatusResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentBasisStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentBasisStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAgentBasisStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentBasisStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentByIdRequest(TeaModel):
    def __init__(
        self,
        agent_id: int = None,
        instance_id: str = None,
    ):
        self.agent_id = agent_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetAgentByIdResponseBodyData(TeaModel):
    def __init__(
        self,
        agent_id: int = None,
        create_user_name: str = None,
        foreign_key: str = None,
        foreign_nick: str = None,
        real_name: str = None,
        servicer_type: int = None,
        show_name: str = None,
    ):
        self.agent_id = agent_id
        self.create_user_name = create_user_name
        self.foreign_key = foreign_key
        self.foreign_nick = foreign_nick
        self.real_name = real_name
        self.servicer_type = servicer_type
        self.show_name = show_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.create_user_name is not None:
            result['CreateUserName'] = self.create_user_name
        if self.foreign_key is not None:
            result['ForeignKey'] = self.foreign_key
        if self.foreign_nick is not None:
            result['ForeignNick'] = self.foreign_nick
        if self.real_name is not None:
            result['RealName'] = self.real_name
        if self.servicer_type is not None:
            result['ServicerType'] = self.servicer_type
        if self.show_name is not None:
            result['ShowName'] = self.show_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('CreateUserName') is not None:
            self.create_user_name = m.get('CreateUserName')
        if m.get('ForeignKey') is not None:
            self.foreign_key = m.get('ForeignKey')
        if m.get('ForeignNick') is not None:
            self.foreign_nick = m.get('ForeignNick')
        if m.get('RealName') is not None:
            self.real_name = m.get('RealName')
        if m.get('ServicerType') is not None:
            self.servicer_type = m.get('ServicerType')
        if m.get('ShowName') is not None:
            self.show_name = m.get('ShowName')
        return self


class GetAgentByIdResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAgentByIdResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentByIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentByIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAgentByIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentByIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentDetailReportRequest(TeaModel):
    def __init__(
        self,
        agent_ids: List[int] = None,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_department_grouping: bool = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids = agent_ids
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_department_grouping = exist_department_grouping
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetAgentDetailReportShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_ids_shrink: str = None,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_department_grouping: bool = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids_shrink = agent_ids_shrink
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_department_grouping = exist_department_grouping
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetAgentDetailReportResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetAgentDetailReportResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAgentDetailReportResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentDetailReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentDetailReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAgentDetailReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentDetailReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentIndexRealTimeRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids: List[int] = None,
        group_ids: List[int] = None,
        instance_id: str = None,
        page_size: int = None,
    ):
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.group_ids = group_ids
        self.instance_id = instance_id
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetAgentIndexRealTimeResponseBodyDataColumns(TeaModel):
    def __init__(
        self,
        key: str = None,
        title: str = None,
    ):
        self.key = key
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetAgentIndexRealTimeResponseBodyData(TeaModel):
    def __init__(
        self,
        columns: List[GetAgentIndexRealTimeResponseBodyDataColumns] = None,
        page: int = None,
        page_size: int = None,
        rows: List[Dict[str, Any]] = None,
        total: int = None,
    ):
        self.columns = columns
        self.page = page
        self.page_size = page_size
        self.rows = rows
        self.total = total

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = GetAgentIndexRealTimeResponseBodyDataColumns()
                self.columns.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetAgentIndexRealTimeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAgentIndexRealTimeResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentIndexRealTimeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentIndexRealTimeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAgentIndexRealTimeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentIndexRealTimeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentServiceStatusRequest(TeaModel):
    def __init__(
        self,
        agent_ids: List[int] = None,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_department_grouping: bool = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids = agent_ids
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_department_grouping = exist_department_grouping
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetAgentServiceStatusShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_ids_shrink: str = None,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_department_grouping: bool = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids_shrink = agent_ids_shrink
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_department_grouping = exist_department_grouping
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetAgentServiceStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetAgentServiceStatusResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAgentServiceStatusResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentServiceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentServiceStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAgentServiceStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentServiceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentStatisticsRequest(TeaModel):
    def __init__(
        self,
        agent_ids: List[int] = None,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_department_grouping: bool = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids = agent_ids
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_department_grouping = exist_department_grouping
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetAgentStatisticsShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_ids_shrink: str = None,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_department_grouping: bool = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids_shrink = agent_ids_shrink
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_department_grouping = exist_department_grouping
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetAgentStatisticsResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetAgentStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAgentStatisticsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentStatisticsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAgentStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAiOutboundTaskBizDataRequest(TeaModel):
    def __init__(
        self,
        channel_id: str = None,
        instance_id: str = None,
    ):
        self.channel_id = channel_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetAiOutboundTaskBizDataResponseBodyData(TeaModel):
    def __init__(
        self,
        biz_data: str = None,
        case_id: int = None,
        phone_num: str = None,
        task_id: int = None,
    ):
        self.biz_data = biz_data
        self.case_id = case_id
        self.phone_num = phone_num
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_data is not None:
            result['BizData'] = self.biz_data
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizData') is not None:
            self.biz_data = m.get('BizData')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetAiOutboundTaskBizDataResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAiOutboundTaskBizDataResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAiOutboundTaskBizDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAiOutboundTaskBizDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAiOutboundTaskBizDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAiOutboundTaskBizDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAiOutboundTaskDetailRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        task_id: int = None,
    ):
        self.instance_id = instance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetAiOutboundTaskDetailResponseBodyDataRecallRule(TeaModel):
    def __init__(
        self,
        count: int = None,
        interval: int = None,
    ):
        self.count = count
        self.interval = interval

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class GetAiOutboundTaskDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        concurrent_rate: int = None,
        description: str = None,
        execution_time: str = None,
        forecast_call_rate: float = None,
        handler_id: int = None,
        handler_name: str = None,
        name: str = None,
        num_repeated: int = None,
        outbound_nums: List[str] = None,
        recall_rule: GetAiOutboundTaskDetailResponseBodyDataRecallRule = None,
        status: int = None,
        status_desc: str = None,
        task_id: int = None,
        type: int = None,
    ):
        self.concurrent_rate = concurrent_rate
        self.description = description
        self.execution_time = execution_time
        self.forecast_call_rate = forecast_call_rate
        self.handler_id = handler_id
        self.handler_name = handler_name
        self.name = name
        self.num_repeated = num_repeated
        self.outbound_nums = outbound_nums
        self.recall_rule = recall_rule
        self.status = status
        self.status_desc = status_desc
        self.task_id = task_id
        self.type = type

    def validate(self):
        if self.recall_rule:
            self.recall_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrent_rate is not None:
            result['ConcurrentRate'] = self.concurrent_rate
        if self.description is not None:
            result['Description'] = self.description
        if self.execution_time is not None:
            result['ExecutionTime'] = self.execution_time
        if self.forecast_call_rate is not None:
            result['ForecastCallRate'] = self.forecast_call_rate
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.handler_name is not None:
            result['HandlerName'] = self.handler_name
        if self.name is not None:
            result['Name'] = self.name
        if self.num_repeated is not None:
            result['NumRepeated'] = self.num_repeated
        if self.outbound_nums is not None:
            result['OutboundNums'] = self.outbound_nums
        if self.recall_rule is not None:
            result['RecallRule'] = self.recall_rule.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcurrentRate') is not None:
            self.concurrent_rate = m.get('ConcurrentRate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExecutionTime') is not None:
            self.execution_time = m.get('ExecutionTime')
        if m.get('ForecastCallRate') is not None:
            self.forecast_call_rate = m.get('ForecastCallRate')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('HandlerName') is not None:
            self.handler_name = m.get('HandlerName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumRepeated') is not None:
            self.num_repeated = m.get('NumRepeated')
        if m.get('OutboundNums') is not None:
            self.outbound_nums = m.get('OutboundNums')
        if m.get('RecallRule') is not None:
            temp_model = GetAiOutboundTaskDetailResponseBodyDataRecallRule()
            self.recall_rule = temp_model.from_map(m['RecallRule'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetAiOutboundTaskDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAiOutboundTaskDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAiOutboundTaskDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAiOutboundTaskDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAiOutboundTaskDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAiOutboundTaskDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAiOutboundTaskExecDetailRequest(TeaModel):
    def __init__(
        self,
        batch_version: int = None,
        case_id: int = None,
        case_status: int = None,
        create_time_end: int = None,
        create_time_start: int = None,
        current_page: int = None,
        instance_id: str = None,
        page_size: int = None,
        phone_num: str = None,
        task_id: int = None,
    ):
        self.batch_version = batch_version
        self.case_id = case_id
        self.case_status = case_status
        self.create_time_end = create_time_end
        self.create_time_start = create_time_start
        self.current_page = current_page
        self.instance_id = instance_id
        self.page_size = page_size
        self.phone_num = phone_num
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_version is not None:
            result['BatchVersion'] = self.batch_version
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.case_status is not None:
            result['CaseStatus'] = self.case_status
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchVersion') is not None:
            self.batch_version = m.get('BatchVersion')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('CaseStatus') is not None:
            self.case_status = m.get('CaseStatus')
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetAiOutboundTaskExecDetailResponseBodyDataList(TeaModel):
    def __init__(
        self,
        batch_version: int = None,
        biz_data: str = None,
        call_count: int = None,
        case_id: int = None,
        create_time: int = None,
        last_call_result: str = None,
        phone_num: str = None,
        status: int = None,
        status_desc: int = None,
    ):
        self.batch_version = batch_version
        self.biz_data = biz_data
        self.call_count = call_count
        self.case_id = case_id
        self.create_time = create_time
        self.last_call_result = last_call_result
        self.phone_num = phone_num
        self.status = status
        self.status_desc = status_desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_version is not None:
            result['BatchVersion'] = self.batch_version
        if self.biz_data is not None:
            result['BizData'] = self.biz_data
        if self.call_count is not None:
            result['CallCount'] = self.call_count
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_call_result is not None:
            result['LastCallResult'] = self.last_call_result
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        if self.status is not None:
            result['Status'] = self.status
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchVersion') is not None:
            self.batch_version = m.get('BatchVersion')
        if m.get('BizData') is not None:
            self.biz_data = m.get('BizData')
        if m.get('CallCount') is not None:
            self.call_count = m.get('CallCount')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastCallResult') is not None:
            self.last_call_result = m.get('LastCallResult')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        return self


class GetAiOutboundTaskExecDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        has_next_page: bool = None,
        list: List[GetAiOutboundTaskExecDetailResponseBodyDataList] = None,
        page_size: int = None,
        total_results: int = None,
    ):
        self.current_page = current_page
        self.has_next_page = has_next_page
        self.list = list
        self.page_size = page_size
        self.total_results = total_results

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.has_next_page is not None:
            result['HasNextPage'] = self.has_next_page
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('HasNextPage') is not None:
            self.has_next_page = m.get('HasNextPage')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetAiOutboundTaskExecDetailResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class GetAiOutboundTaskExecDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAiOutboundTaskExecDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAiOutboundTaskExecDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAiOutboundTaskExecDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAiOutboundTaskExecDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAiOutboundTaskExecDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAiOutboundTaskListRequest(TeaModel):
    def __init__(
        self,
        create_time_end: int = None,
        create_time_start: int = None,
        current_page: int = None,
        instance_id: str = None,
        page_size: int = None,
        search_key: str = None,
        status: int = None,
        type: int = None,
    ):
        self.create_time_end = create_time_end
        self.create_time_start = create_time_start
        self.current_page = current_page
        self.instance_id = instance_id
        self.page_size = page_size
        self.search_key = search_key
        self.status = status
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetAiOutboundTaskListResponseBodyDataList(TeaModel):
    def __init__(
        self,
        concurrent_rate: int = None,
        create_time: int = None,
        description: str = None,
        finish_count: int = None,
        finish_rate: float = None,
        handler_id: int = None,
        handler_name: str = None,
        name: str = None,
        status: int = None,
        status_desc: str = None,
        task_id: int = None,
        total_count: int = None,
    ):
        self.concurrent_rate = concurrent_rate
        self.create_time = create_time
        self.description = description
        self.finish_count = finish_count
        self.finish_rate = finish_rate
        self.handler_id = handler_id
        self.handler_name = handler_name
        self.name = name
        self.status = status
        self.status_desc = status_desc
        self.task_id = task_id
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrent_rate is not None:
            result['ConcurrentRate'] = self.concurrent_rate
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.finish_count is not None:
            result['FinishCount'] = self.finish_count
        if self.finish_rate is not None:
            result['FinishRate'] = self.finish_rate
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.handler_name is not None:
            result['HandlerName'] = self.handler_name
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcurrentRate') is not None:
            self.concurrent_rate = m.get('ConcurrentRate')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FinishCount') is not None:
            self.finish_count = m.get('FinishCount')
        if m.get('FinishRate') is not None:
            self.finish_rate = m.get('FinishRate')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('HandlerName') is not None:
            self.handler_name = m.get('HandlerName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetAiOutboundTaskListResponseBodyData(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        has_next_page: bool = None,
        list: List[GetAiOutboundTaskListResponseBodyDataList] = None,
        page_size: int = None,
        total_results: int = None,
    ):
        self.current_page = current_page
        self.has_next_page = has_next_page
        self.list = list
        self.page_size = page_size
        self.total_results = total_results

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.has_next_page is not None:
            result['HasNextPage'] = self.has_next_page
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('HasNextPage') is not None:
            self.has_next_page = m.get('HasNextPage')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetAiOutboundTaskListResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class GetAiOutboundTaskListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAiOutboundTaskListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAiOutboundTaskListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAiOutboundTaskListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAiOutboundTaskListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAiOutboundTaskListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAiOutboundTaskProgressRequest(TeaModel):
    def __init__(
        self,
        batch_version: int = None,
        instance_id: str = None,
        task_id: int = None,
    ):
        self.batch_version = batch_version
        self.instance_id = instance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_version is not None:
            result['BatchVersion'] = self.batch_version
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchVersion') is not None:
            self.batch_version = m.get('BatchVersion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetAiOutboundTaskProgressResponseBodyDataCalloutProgress(TeaModel):
    def __init__(
        self,
        call_loss_count: int = None,
        call_loss_rate: float = None,
        call_out_connect_count: int = None,
        call_out_connect_rate: float = None,
        call_out_count: int = None,
        call_out_servicer_pickup_count: int = None,
        call_out_servicer_pickup_rate: float = None,
        call_out_user_pickup_count: int = None,
        call_out_user_pickup_rate: float = None,
    ):
        self.call_loss_count = call_loss_count
        self.call_loss_rate = call_loss_rate
        self.call_out_connect_count = call_out_connect_count
        self.call_out_connect_rate = call_out_connect_rate
        self.call_out_count = call_out_count
        self.call_out_servicer_pickup_count = call_out_servicer_pickup_count
        self.call_out_servicer_pickup_rate = call_out_servicer_pickup_rate
        self.call_out_user_pickup_count = call_out_user_pickup_count
        self.call_out_user_pickup_rate = call_out_user_pickup_rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_loss_count is not None:
            result['CallLossCount'] = self.call_loss_count
        if self.call_loss_rate is not None:
            result['CallLossRate'] = self.call_loss_rate
        if self.call_out_connect_count is not None:
            result['CallOutConnectCount'] = self.call_out_connect_count
        if self.call_out_connect_rate is not None:
            result['CallOutConnectRate'] = self.call_out_connect_rate
        if self.call_out_count is not None:
            result['CallOutCount'] = self.call_out_count
        if self.call_out_servicer_pickup_count is not None:
            result['CallOutServicerPickupCount'] = self.call_out_servicer_pickup_count
        if self.call_out_servicer_pickup_rate is not None:
            result['CallOutServicerPickupRate'] = self.call_out_servicer_pickup_rate
        if self.call_out_user_pickup_count is not None:
            result['CallOutUserPickupCount'] = self.call_out_user_pickup_count
        if self.call_out_user_pickup_rate is not None:
            result['CallOutUserPickupRate'] = self.call_out_user_pickup_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallLossCount') is not None:
            self.call_loss_count = m.get('CallLossCount')
        if m.get('CallLossRate') is not None:
            self.call_loss_rate = m.get('CallLossRate')
        if m.get('CallOutConnectCount') is not None:
            self.call_out_connect_count = m.get('CallOutConnectCount')
        if m.get('CallOutConnectRate') is not None:
            self.call_out_connect_rate = m.get('CallOutConnectRate')
        if m.get('CallOutCount') is not None:
            self.call_out_count = m.get('CallOutCount')
        if m.get('CallOutServicerPickupCount') is not None:
            self.call_out_servicer_pickup_count = m.get('CallOutServicerPickupCount')
        if m.get('CallOutServicerPickupRate') is not None:
            self.call_out_servicer_pickup_rate = m.get('CallOutServicerPickupRate')
        if m.get('CallOutUserPickupCount') is not None:
            self.call_out_user_pickup_count = m.get('CallOutUserPickupCount')
        if m.get('CallOutUserPickupRate') is not None:
            self.call_out_user_pickup_rate = m.get('CallOutUserPickupRate')
        return self


class GetAiOutboundTaskProgressResponseBodyDataTaskProgress(TeaModel):
    def __init__(
        self,
        calling_count: int = None,
        connect_count: int = None,
        connect_rate: float = None,
        finish_count: int = None,
        finish_rate: float = None,
        servicer_pickup_count: int = None,
        servicer_pickup_rate: float = None,
        terminate_count: int = None,
        total_count: int = None,
        user_pickup_count: int = None,
        user_pickup_rate: float = None,
        waiting_call_count: int = None,
        waiting_recall_count: int = None,
    ):
        self.calling_count = calling_count
        self.connect_count = connect_count
        self.connect_rate = connect_rate
        self.finish_count = finish_count
        self.finish_rate = finish_rate
        self.servicer_pickup_count = servicer_pickup_count
        self.servicer_pickup_rate = servicer_pickup_rate
        self.terminate_count = terminate_count
        self.total_count = total_count
        self.user_pickup_count = user_pickup_count
        self.user_pickup_rate = user_pickup_rate
        self.waiting_call_count = waiting_call_count
        self.waiting_recall_count = waiting_recall_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calling_count is not None:
            result['CallingCount'] = self.calling_count
        if self.connect_count is not None:
            result['ConnectCount'] = self.connect_count
        if self.connect_rate is not None:
            result['ConnectRate'] = self.connect_rate
        if self.finish_count is not None:
            result['FinishCount'] = self.finish_count
        if self.finish_rate is not None:
            result['FinishRate'] = self.finish_rate
        if self.servicer_pickup_count is not None:
            result['ServicerPickupCount'] = self.servicer_pickup_count
        if self.servicer_pickup_rate is not None:
            result['ServicerPickupRate'] = self.servicer_pickup_rate
        if self.terminate_count is not None:
            result['TerminateCount'] = self.terminate_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.user_pickup_count is not None:
            result['UserPickupCount'] = self.user_pickup_count
        if self.user_pickup_rate is not None:
            result['UserPickupRate'] = self.user_pickup_rate
        if self.waiting_call_count is not None:
            result['WaitingCallCount'] = self.waiting_call_count
        if self.waiting_recall_count is not None:
            result['WaitingRecallCount'] = self.waiting_recall_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallingCount') is not None:
            self.calling_count = m.get('CallingCount')
        if m.get('ConnectCount') is not None:
            self.connect_count = m.get('ConnectCount')
        if m.get('ConnectRate') is not None:
            self.connect_rate = m.get('ConnectRate')
        if m.get('FinishCount') is not None:
            self.finish_count = m.get('FinishCount')
        if m.get('FinishRate') is not None:
            self.finish_rate = m.get('FinishRate')
        if m.get('ServicerPickupCount') is not None:
            self.servicer_pickup_count = m.get('ServicerPickupCount')
        if m.get('ServicerPickupRate') is not None:
            self.servicer_pickup_rate = m.get('ServicerPickupRate')
        if m.get('TerminateCount') is not None:
            self.terminate_count = m.get('TerminateCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('UserPickupCount') is not None:
            self.user_pickup_count = m.get('UserPickupCount')
        if m.get('UserPickupRate') is not None:
            self.user_pickup_rate = m.get('UserPickupRate')
        if m.get('WaitingCallCount') is not None:
            self.waiting_call_count = m.get('WaitingCallCount')
        if m.get('WaitingRecallCount') is not None:
            self.waiting_recall_count = m.get('WaitingRecallCount')
        return self


class GetAiOutboundTaskProgressResponseBodyData(TeaModel):
    def __init__(
        self,
        callout_progress: GetAiOutboundTaskProgressResponseBodyDataCalloutProgress = None,
        task_id: int = None,
        task_progress: GetAiOutboundTaskProgressResponseBodyDataTaskProgress = None,
        type: int = None,
    ):
        self.callout_progress = callout_progress
        self.task_id = task_id
        self.task_progress = task_progress
        self.type = type

    def validate(self):
        if self.callout_progress:
            self.callout_progress.validate()
        if self.task_progress:
            self.task_progress.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callout_progress is not None:
            result['CalloutProgress'] = self.callout_progress.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_progress is not None:
            result['TaskProgress'] = self.task_progress.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalloutProgress') is not None:
            temp_model = GetAiOutboundTaskProgressResponseBodyDataCalloutProgress()
            self.callout_progress = temp_model.from_map(m['CalloutProgress'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskProgress') is not None:
            temp_model = GetAiOutboundTaskProgressResponseBodyDataTaskProgress()
            self.task_progress = temp_model.from_map(m['TaskProgress'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetAiOutboundTaskProgressResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAiOutboundTaskProgressResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAiOutboundTaskProgressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAiOutboundTaskProgressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAiOutboundTaskProgressResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAiOutboundTaskProgressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAllDepartmentRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetAllDepartmentResponseBodyData(TeaModel):
    def __init__(
        self,
        department_id: int = None,
        department_name: str = None,
    ):
        self.department_id = department_id
        self.department_name = department_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.department_name is not None:
            result['DepartmentName'] = self.department_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('DepartmentName') is not None:
            self.department_name = m.get('DepartmentName')
        return self


class GetAllDepartmentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[GetAllDepartmentResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetAllDepartmentResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAllDepartmentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAllDepartmentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAllDepartmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCallSoundRecordRequest(TeaModel):
    def __init__(
        self,
        call_id: str = None,
        create_time: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.call_id = call_id
        self.create_time = create_time
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetCallSoundRecordResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCallSoundRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCallSoundRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCallSoundRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigNumListRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        department_id: int = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.department_id = department_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetConfigNumListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[str] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetConfigNumListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetConfigNumListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetConfigNumListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomerInfoRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        member_id: int = None,
    ):
        self.instance_id = instance_id
        self.member_id = member_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        return self


class GetCustomerInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        customize_fields: Dict[str, Any] = None,
        nick: str = None,
        outer_id: str = None,
        photo: str = None,
        real_name: str = None,
        user_id: int = None,
    ):
        self.customize_fields = customize_fields
        self.nick = nick
        self.outer_id = outer_id
        self.photo = photo
        self.real_name = real_name
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customize_fields is not None:
            result['CustomizeFields'] = self.customize_fields
        if self.nick is not None:
            result['Nick'] = self.nick
        if self.outer_id is not None:
            result['OuterId'] = self.outer_id
        if self.photo is not None:
            result['Photo'] = self.photo
        if self.real_name is not None:
            result['RealName'] = self.real_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomizeFields') is not None:
            self.customize_fields = m.get('CustomizeFields')
        if m.get('Nick') is not None:
            self.nick = m.get('Nick')
        if m.get('OuterId') is not None:
            self.outer_id = m.get('OuterId')
        if m.get('Photo') is not None:
            self.photo = m.get('Photo')
        if m.get('RealName') is not None:
            self.real_name = m.get('RealName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetCustomerInfoResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetCustomerInfoResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCustomerInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCustomerInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCustomerInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomerInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDepGroupTreeDataRequest(TeaModel):
    def __init__(
        self,
        agent_id: int = None,
        instance_id: str = None,
    ):
        self.agent_id = agent_id
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDepGroupTreeDataResponseBodyDataGroupDTOS(TeaModel):
    def __init__(
        self,
        name: str = None,
        skill_group_id: int = None,
    ):
        self.name = name
        self.skill_group_id = skill_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class GetDepGroupTreeDataResponseBodyData(TeaModel):
    def __init__(
        self,
        dep_group_id: str = None,
        dep_group_name: str = None,
        group_dtos: List[GetDepGroupTreeDataResponseBodyDataGroupDTOS] = None,
    ):
        self.dep_group_id = dep_group_id
        self.dep_group_name = dep_group_name
        self.group_dtos = group_dtos

    def validate(self):
        if self.group_dtos:
            for k in self.group_dtos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dep_group_id is not None:
            result['DepGroupId'] = self.dep_group_id
        if self.dep_group_name is not None:
            result['DepGroupName'] = self.dep_group_name
        result['GroupDTOS'] = []
        if self.group_dtos is not None:
            for k in self.group_dtos:
                result['GroupDTOS'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepGroupId') is not None:
            self.dep_group_id = m.get('DepGroupId')
        if m.get('DepGroupName') is not None:
            self.dep_group_name = m.get('DepGroupName')
        self.group_dtos = []
        if m.get('GroupDTOS') is not None:
            for k in m.get('GroupDTOS'):
                temp_model = GetDepGroupTreeDataResponseBodyDataGroupDTOS()
                self.group_dtos.append(temp_model.from_map(k))
        return self


class GetDepGroupTreeDataResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[GetDepGroupTreeDataResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetDepGroupTreeDataResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDepGroupTreeDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDepGroupTreeDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDepGroupTreeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDepartmentalLatitudeAgentStatusRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetDepartmentalLatitudeAgentStatusShrinkRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetDepartmentalLatitudeAgentStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetDepartmentalLatitudeAgentStatusResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetDepartmentalLatitudeAgentStatusResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDepartmentalLatitudeAgentStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDepartmentalLatitudeAgentStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetDepartmentalLatitudeAgentStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDepartmentalLatitudeAgentStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineAgentDetailRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHotlineAgentDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        agent_id: int = None,
        agent_status: int = None,
        agent_status_code: str = None,
        assigned: bool = None,
        rest_type: int = None,
        tenant_id: int = None,
        token: str = None,
    ):
        self.agent_id = agent_id
        self.agent_status = agent_status
        self.agent_status_code = agent_status_code
        self.assigned = assigned
        self.rest_type = rest_type
        self.tenant_id = tenant_id
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_status is not None:
            result['AgentStatus'] = self.agent_status
        if self.agent_status_code is not None:
            result['AgentStatusCode'] = self.agent_status_code
        if self.assigned is not None:
            result['Assigned'] = self.assigned
        if self.rest_type is not None:
            result['RestType'] = self.rest_type
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentStatus') is not None:
            self.agent_status = m.get('AgentStatus')
        if m.get('AgentStatusCode') is not None:
            self.agent_status_code = m.get('AgentStatusCode')
        if m.get('Assigned') is not None:
            self.assigned = m.get('Assigned')
        if m.get('RestType') is not None:
            self.rest_type = m.get('RestType')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class GetHotlineAgentDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetHotlineAgentDetailResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHotlineAgentDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineAgentDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHotlineAgentDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineAgentDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineAgentDetailReportRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        group_ids: List[int] = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.group_ids = group_ids
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetHotlineAgentDetailReportResponseBodyDataColumns(TeaModel):
    def __init__(
        self,
        key: str = None,
        title: str = None,
    ):
        self.key = key
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetHotlineAgentDetailReportResponseBodyData(TeaModel):
    def __init__(
        self,
        columns: List[GetHotlineAgentDetailReportResponseBodyDataColumns] = None,
        page: int = None,
        page_size: int = None,
        rows: List[Dict[str, Any]] = None,
        total: int = None,
    ):
        self.columns = columns
        self.page = page
        self.page_size = page_size
        self.rows = rows
        self.total = total

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = GetHotlineAgentDetailReportResponseBodyDataColumns()
                self.columns.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetHotlineAgentDetailReportResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetHotlineAgentDetailReportResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHotlineAgentDetailReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineAgentDetailReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHotlineAgentDetailReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineAgentDetailReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineAgentStatusRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHotlineAgentStatusResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineAgentStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHotlineAgentStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineAgentStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineCallActionRequest(TeaModel):
    def __init__(
        self,
        acc: str = None,
        account_name: str = None,
        act: int = None,
        biz: str = None,
        client_token: str = None,
        from_source: str = None,
        instance_id: str = None,
    ):
        self.acc = acc
        self.account_name = account_name
        self.act = act
        self.biz = biz
        self.client_token = client_token
        self.from_source = from_source
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acc is not None:
            result['Acc'] = self.acc
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.act is not None:
            result['Act'] = self.act
        if self.biz is not None:
            result['Biz'] = self.biz
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.from_source is not None:
            result['FromSource'] = self.from_source
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acc') is not None:
            self.acc = m.get('Acc')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('Act') is not None:
            self.act = m.get('Act')
        if m.get('Biz') is not None:
            self.biz = m.get('Biz')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('FromSource') is not None:
            self.from_source = m.get('FromSource')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHotlineCallActionResponseBodyData(TeaModel):
    def __init__(
        self,
        action_id: int = None,
        bu_id: int = None,
        callout_id: int = None,
        callout_name: str = None,
        case_id: int = None,
        channel_id: str = None,
        channel_type: int = None,
        dep_id: int = None,
        is_transfer: str = None,
        member_id: int = None,
        member_list: str = None,
        member_name: str = None,
        servicer_id: int = None,
        servicer_name: str = None,
        sub_touch_id: int = None,
        task_id: int = None,
        touch_id: int = None,
    ):
        self.action_id = action_id
        self.bu_id = bu_id
        self.callout_id = callout_id
        self.callout_name = callout_name
        self.case_id = case_id
        self.channel_id = channel_id
        self.channel_type = channel_type
        self.dep_id = dep_id
        self.is_transfer = is_transfer
        self.member_id = member_id
        self.member_list = member_list
        self.member_name = member_name
        self.servicer_id = servicer_id
        self.servicer_name = servicer_name
        self.sub_touch_id = sub_touch_id
        self.task_id = task_id
        self.touch_id = touch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        if self.bu_id is not None:
            result['BuId'] = self.bu_id
        if self.callout_id is not None:
            result['CalloutId'] = self.callout_id
        if self.callout_name is not None:
            result['CalloutName'] = self.callout_name
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.dep_id is not None:
            result['DepId'] = self.dep_id
        if self.is_transfer is not None:
            result['IsTransfer'] = self.is_transfer
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_list is not None:
            result['MemberList'] = self.member_list
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.sub_touch_id is not None:
            result['SubTouchId'] = self.sub_touch_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.touch_id is not None:
            result['TouchId'] = self.touch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        if m.get('BuId') is not None:
            self.bu_id = m.get('BuId')
        if m.get('CalloutId') is not None:
            self.callout_id = m.get('CalloutId')
        if m.get('CalloutName') is not None:
            self.callout_name = m.get('CalloutName')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('DepId') is not None:
            self.dep_id = m.get('DepId')
        if m.get('IsTransfer') is not None:
            self.is_transfer = m.get('IsTransfer')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberList') is not None:
            self.member_list = m.get('MemberList')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('SubTouchId') is not None:
            self.sub_touch_id = m.get('SubTouchId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TouchId') is not None:
            self.touch_id = m.get('TouchId')
        return self


class GetHotlineCallActionResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetHotlineCallActionResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHotlineCallActionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineCallActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHotlineCallActionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineCallActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineGroupDetailReportRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        group_ids: List[int] = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.group_ids = group_ids
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetHotlineGroupDetailReportResponseBodyDataColumns(TeaModel):
    def __init__(
        self,
        key: str = None,
        title: str = None,
    ):
        self.key = key
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetHotlineGroupDetailReportResponseBodyData(TeaModel):
    def __init__(
        self,
        columns: List[GetHotlineGroupDetailReportResponseBodyDataColumns] = None,
        page: int = None,
        page_size: int = None,
        rows: List[Dict[str, Any]] = None,
        total: int = None,
    ):
        self.columns = columns
        self.page = page
        self.page_size = page_size
        self.rows = rows
        self.total = total

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = GetHotlineGroupDetailReportResponseBodyDataColumns()
                self.columns.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetHotlineGroupDetailReportResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetHotlineGroupDetailReportResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHotlineGroupDetailReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineGroupDetailReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHotlineGroupDetailReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineGroupDetailReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineMessageLogRequest(TeaModel):
    def __init__(
        self,
        acid: str = None,
        instance_id: str = None,
    ):
        self.acid = acid
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHotlineMessageLogResponseBodyData(TeaModel):
    def __init__(
        self,
        acid: str = None,
        content: str = None,
        end_time: int = None,
        mid: str = None,
        sender_type: int = None,
        start_time: int = None,
    ):
        self.acid = acid
        self.content = content
        self.end_time = end_time
        self.mid = mid
        self.sender_type = sender_type
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.content is not None:
            result['Content'] = self.content
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.mid is not None:
            result['Mid'] = self.mid
        if self.sender_type is not None:
            result['SenderType'] = self.sender_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Mid') is not None:
            self.mid = m.get('Mid')
        if m.get('SenderType') is not None:
            self.sender_type = m.get('SenderType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetHotlineMessageLogResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[GetHotlineMessageLogResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetHotlineMessageLogResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineMessageLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHotlineMessageLogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineMessageLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineRuntimeInfoRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHotlineRuntimeInfoResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: Dict[str, Any] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineRuntimeInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHotlineRuntimeInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineRuntimeInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineServiceStatisticsRequest(TeaModel):
    def __init__(
        self,
        agent_ids: List[int] = None,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids: List[int] = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids = agent_ids
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids = group_ids
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetHotlineServiceStatisticsShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_ids_shrink: str = None,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids_shrink: str = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids_shrink = agent_ids_shrink
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids_shrink = group_ids_shrink
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetHotlineServiceStatisticsResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetHotlineServiceStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetHotlineServiceStatisticsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHotlineServiceStatisticsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineServiceStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHotlineServiceStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineServiceStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineWaitingNumberRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHotlineWaitingNumberResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: int = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineWaitingNumberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetHotlineWaitingNumberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineWaitingNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIndexCurrentValueRequest(TeaModel):
    def __init__(
        self,
        dep_ids: str = None,
        group_ids: str = None,
        instance_id: str = None,
    ):
        self.dep_ids = dep_ids
        self.group_ids = group_ids
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetIndexCurrentValueResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[Dict[str, Any]] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetIndexCurrentValueResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetIndexCurrentValueResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetIndexCurrentValueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceListRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.name = name
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetInstanceListResponseBodyCommodityInstances(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        name: str = None,
    ):
        self.instance_id = instance_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetInstanceListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        commodity_instances: List[GetInstanceListResponseBodyCommodityInstances] = None,
        http_status_code: int = None,
        message: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total_count: int = None,
    ):
        self.code = code
        self.commodity_instances = commodity_instances
        self.http_status_code = http_status_code
        self.message = message
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.success = success
        self.total_count = total_count

    def validate(self):
        if self.commodity_instances:
            for k in self.commodity_instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['CommodityInstances'] = []
        if self.commodity_instances is not None:
            for k in self.commodity_instances:
                result['CommodityInstances'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.commodity_instances = []
        if m.get('CommodityInstances') is not None:
            for k in m.get('CommodityInstances'):
                temp_model = GetInstanceListResponseBodyCommodityInstances()
                self.commodity_instances.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetInstanceListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetInstanceListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMcuLvsIpRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetMcuLvsIpResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMcuLvsIpResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMcuLvsIpResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMcuLvsIpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNumLocationRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        instance_id: str = None,
        phone_num: str = None,
    ):
        self.client_token = client_token
        self.instance_id = instance_id
        self.phone_num = phone_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        return self


class GetNumLocationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetNumLocationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetNumLocationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetNumLocationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOnlineSeatInformationRequest(TeaModel):
    def __init__(
        self,
        agent_ids: List[int] = None,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.agent_ids = agent_ids
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetOnlineSeatInformationShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_ids_shrink: str = None,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.agent_ids_shrink = agent_ids_shrink
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetOnlineSeatInformationResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetOnlineSeatInformationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetOnlineSeatInformationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetOnlineSeatInformationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetOnlineSeatInformationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetOnlineSeatInformationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOnlineSeatInformationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOnlineServiceVolumeRequest(TeaModel):
    def __init__(
        self,
        agent_ids: List[int] = None,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids: List[int] = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids = agent_ids
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids = group_ids
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetOnlineServiceVolumeShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_ids_shrink: str = None,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids_shrink: str = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids_shrink = agent_ids_shrink
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids_shrink = group_ids_shrink
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetOnlineServiceVolumeResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetOnlineServiceVolumeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetOnlineServiceVolumeResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetOnlineServiceVolumeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetOnlineServiceVolumeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetOnlineServiceVolumeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOnlineServiceVolumeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOutbounNumListRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetOutbounNumListResponseBodyDataNum(TeaModel):
    def __init__(
        self,
        description: str = None,
        type: int = None,
        value: str = None,
    ):
        self.description = description
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetOutbounNumListResponseBodyDataNumGroup(TeaModel):
    def __init__(
        self,
        description: str = None,
        type: int = None,
        value: str = None,
    ):
        self.description = description
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetOutbounNumListResponseBodyData(TeaModel):
    def __init__(
        self,
        num: List[GetOutbounNumListResponseBodyDataNum] = None,
        num_group: List[GetOutbounNumListResponseBodyDataNumGroup] = None,
    ):
        self.num = num
        self.num_group = num_group

    def validate(self):
        if self.num:
            for k in self.num:
                if k:
                    k.validate()
        if self.num_group:
            for k in self.num_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Num'] = []
        if self.num is not None:
            for k in self.num:
                result['Num'].append(k.to_map() if k else None)
        result['NumGroup'] = []
        if self.num_group is not None:
            for k in self.num_group:
                result['NumGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.num = []
        if m.get('Num') is not None:
            for k in m.get('Num'):
                temp_model = GetOutbounNumListResponseBodyDataNum()
                self.num.append(temp_model.from_map(k))
        self.num_group = []
        if m.get('NumGroup') is not None:
            for k in m.get('NumGroup'):
                temp_model = GetOutbounNumListResponseBodyDataNumGroup()
                self.num_group.append(temp_model.from_map(k))
        return self


class GetOutbounNumListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetOutbounNumListResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetOutbounNumListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetOutbounNumListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetOutbounNumListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOutbounNumListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityProjectDetailRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        project_id: int = None,
    ):
        self.instance_id = instance_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetQualityProjectDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        check_freq_type: int = None,
        create_time: str = None,
        dep_list: List[int] = None,
        group_list: List[int] = None,
        id: int = None,
        modify_time: str = None,
        project_name: str = None,
        quality_rule_ids: List[int] = None,
        quality_type: int = None,
        servicer_list: List[int] = None,
        status: int = None,
        version: int = None,
    ):
        self.check_freq_type = check_freq_type
        self.create_time = create_time
        self.dep_list = dep_list
        self.group_list = group_list
        self.id = id
        self.modify_time = modify_time
        self.project_name = project_name
        self.quality_rule_ids = quality_rule_ids
        self.quality_type = quality_type
        self.servicer_list = servicer_list
        self.status = status
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_freq_type is not None:
            result['CheckFreqType'] = self.check_freq_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dep_list is not None:
            result['DepList'] = self.dep_list
        if self.group_list is not None:
            result['GroupList'] = self.group_list
        if self.id is not None:
            result['Id'] = self.id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.quality_rule_ids is not None:
            result['QualityRuleIds'] = self.quality_rule_ids
        if self.quality_type is not None:
            result['QualityType'] = self.quality_type
        if self.servicer_list is not None:
            result['ServicerList'] = self.servicer_list
        if self.status is not None:
            result['Status'] = self.status
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckFreqType') is not None:
            self.check_freq_type = m.get('CheckFreqType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DepList') is not None:
            self.dep_list = m.get('DepList')
        if m.get('GroupList') is not None:
            self.group_list = m.get('GroupList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('QualityRuleIds') is not None:
            self.quality_rule_ids = m.get('QualityRuleIds')
        if m.get('QualityType') is not None:
            self.quality_type = m.get('QualityType')
        if m.get('ServicerList') is not None:
            self.servicer_list = m.get('ServicerList')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetQualityProjectDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQualityProjectDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQualityProjectDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityProjectDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQualityProjectDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityProjectDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityProjectListRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        page_no: int = None,
        page_size: int = None,
        project_id: int = None,
        project_name: str = None,
        status: int = None,
        check_freq_type: int = None,
    ):
        self.instance_id = instance_id
        self.page_no = page_no
        self.page_size = page_size
        self.project_id = project_id
        self.project_name = project_name
        self.status = status
        self.check_freq_type = check_freq_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.status is not None:
            result['Status'] = self.status
        if self.check_freq_type is not None:
            result['checkFreqType'] = self.check_freq_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('checkFreqType') is not None:
            self.check_freq_type = m.get('checkFreqType')
        return self


class GetQualityProjectListResponseBodyDataQualityProjectList(TeaModel):
    def __init__(
        self,
        check_freq_type: int = None,
        create_time: str = None,
        dep_list: List[int] = None,
        group_list: List[int] = None,
        id: int = None,
        modify_time: str = None,
        project_name: str = None,
        quality_rule_ids: List[int] = None,
        quality_type: int = None,
        servicer_list: List[int] = None,
        status: int = None,
        version: int = None,
    ):
        self.check_freq_type = check_freq_type
        self.create_time = create_time
        self.dep_list = dep_list
        self.group_list = group_list
        self.id = id
        self.modify_time = modify_time
        self.project_name = project_name
        self.quality_rule_ids = quality_rule_ids
        self.quality_type = quality_type
        self.servicer_list = servicer_list
        self.status = status
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_freq_type is not None:
            result['CheckFreqType'] = self.check_freq_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dep_list is not None:
            result['DepList'] = self.dep_list
        if self.group_list is not None:
            result['GroupList'] = self.group_list
        if self.id is not None:
            result['Id'] = self.id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.quality_rule_ids is not None:
            result['QualityRuleIds'] = self.quality_rule_ids
        if self.quality_type is not None:
            result['QualityType'] = self.quality_type
        if self.servicer_list is not None:
            result['ServicerList'] = self.servicer_list
        if self.status is not None:
            result['Status'] = self.status
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckFreqType') is not None:
            self.check_freq_type = m.get('CheckFreqType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DepList') is not None:
            self.dep_list = m.get('DepList')
        if m.get('GroupList') is not None:
            self.group_list = m.get('GroupList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('QualityRuleIds') is not None:
            self.quality_rule_ids = m.get('QualityRuleIds')
        if m.get('QualityType') is not None:
            self.quality_type = m.get('QualityType')
        if m.get('ServicerList') is not None:
            self.servicer_list = m.get('ServicerList')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetQualityProjectListResponseBodyData(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        quality_project_list: List[GetQualityProjectListResponseBodyDataQualityProjectList] = None,
        total: int = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.quality_project_list = quality_project_list
        self.total = total

    def validate(self):
        if self.quality_project_list:
            for k in self.quality_project_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QualityProjectList'] = []
        if self.quality_project_list is not None:
            for k in self.quality_project_list:
                result['QualityProjectList'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.quality_project_list = []
        if m.get('QualityProjectList') is not None:
            for k in m.get('QualityProjectList'):
                temp_model = GetQualityProjectListResponseBodyDataQualityProjectList()
                self.quality_project_list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetQualityProjectListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQualityProjectListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQualityProjectListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityProjectListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQualityProjectListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityProjectListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityProjectLogRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        project_id: int = None,
    ):
        self.instance_id = instance_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetQualityProjectLogResponseBodyData(TeaModel):
    def __init__(
        self,
        action_data: str = None,
        action_time: str = None,
        action_type: str = None,
        project_create_time: str = None,
        project_id: int = None,
    ):
        self.action_data = action_data
        self.action_time = action_time
        self.action_type = action_type
        self.project_create_time = project_create_time
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_data is not None:
            result['ActionData'] = self.action_data
        if self.action_time is not None:
            result['ActionTime'] = self.action_time
        if self.action_type is not None:
            result['ActionType'] = self.action_type
        if self.project_create_time is not None:
            result['ProjectCreateTime'] = self.project_create_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionData') is not None:
            self.action_data = m.get('ActionData')
        if m.get('ActionTime') is not None:
            self.action_time = m.get('ActionTime')
        if m.get('ActionType') is not None:
            self.action_type = m.get('ActionType')
        if m.get('ProjectCreateTime') is not None:
            self.project_create_time = m.get('ProjectCreateTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetQualityProjectLogResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[GetQualityProjectLogResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetQualityProjectLogResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityProjectLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQualityProjectLogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityProjectLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityResultRequest(TeaModel):
    def __init__(
        self,
        channel_type: str = None,
        group_ids: List[int] = None,
        hit_status: int = None,
        instance_id: str = None,
        page_no: int = None,
        page_size: int = None,
        project_ids: List[int] = None,
        quality_rule_ids: List[int] = None,
        touch_end_time: str = None,
        touch_start_time: str = None,
    ):
        self.channel_type = channel_type
        self.group_ids = group_ids
        self.hit_status = hit_status
        self.instance_id = instance_id
        self.page_no = page_no
        self.page_size = page_size
        self.project_ids = project_ids
        self.quality_rule_ids = quality_rule_ids
        self.touch_end_time = touch_end_time
        self.touch_start_time = touch_start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.hit_status is not None:
            result['HitStatus'] = self.hit_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_ids is not None:
            result['ProjectIds'] = self.project_ids
        if self.quality_rule_ids is not None:
            result['QualityRuleIds'] = self.quality_rule_ids
        if self.touch_end_time is not None:
            result['TouchEndTime'] = self.touch_end_time
        if self.touch_start_time is not None:
            result['TouchStartTime'] = self.touch_start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('HitStatus') is not None:
            self.hit_status = m.get('HitStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectIds') is not None:
            self.project_ids = m.get('ProjectIds')
        if m.get('QualityRuleIds') is not None:
            self.quality_rule_ids = m.get('QualityRuleIds')
        if m.get('TouchEndTime') is not None:
            self.touch_end_time = m.get('TouchEndTime')
        if m.get('TouchStartTime') is not None:
            self.touch_start_time = m.get('TouchStartTime')
        return self


class GetQualityResultResponseBodyDataQualityResultResponseList(TeaModel):
    def __init__(
        self,
        channel_type: str = None,
        channel_type_name: str = None,
        group_id: str = None,
        group_name: str = None,
        hit_detail: str = None,
        hit_status: bool = None,
        instance_name: str = None,
        member_name: str = None,
        project_id: str = None,
        project_name: str = None,
        rule_id: str = None,
        rule_name: str = None,
        servicer_id: str = None,
        servicer_name: str = None,
        touch_id: str = None,
        touch_start_time: str = None,
    ):
        self.channel_type = channel_type
        self.channel_type_name = channel_type_name
        self.group_id = group_id
        self.group_name = group_name
        self.hit_detail = hit_detail
        self.hit_status = hit_status
        self.instance_name = instance_name
        self.member_name = member_name
        self.project_id = project_id
        self.project_name = project_name
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.servicer_id = servicer_id
        self.servicer_name = servicer_name
        self.touch_id = touch_id
        self.touch_start_time = touch_start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.channel_type_name is not None:
            result['ChannelTypeName'] = self.channel_type_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.hit_detail is not None:
            result['HitDetail'] = self.hit_detail
        if self.hit_status is not None:
            result['HitStatus'] = self.hit_status
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.touch_id is not None:
            result['TouchId'] = self.touch_id
        if self.touch_start_time is not None:
            result['TouchStartTime'] = self.touch_start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('ChannelTypeName') is not None:
            self.channel_type_name = m.get('ChannelTypeName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HitDetail') is not None:
            self.hit_detail = m.get('HitDetail')
        if m.get('HitStatus') is not None:
            self.hit_status = m.get('HitStatus')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('TouchId') is not None:
            self.touch_id = m.get('TouchId')
        if m.get('TouchStartTime') is not None:
            self.touch_start_time = m.get('TouchStartTime')
        return self


class GetQualityResultResponseBodyData(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        quality_result_response_list: List[GetQualityResultResponseBodyDataQualityResultResponseList] = None,
        total_num: int = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.quality_result_response_list = quality_result_response_list
        self.total_num = total_num

    def validate(self):
        if self.quality_result_response_list:
            for k in self.quality_result_response_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QualityResultResponseList'] = []
        if self.quality_result_response_list is not None:
            for k in self.quality_result_response_list:
                result['QualityResultResponseList'].append(k.to_map() if k else None)
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.quality_result_response_list = []
        if m.get('QualityResultResponseList') is not None:
            for k in m.get('QualityResultResponseList'):
                temp_model = GetQualityResultResponseBodyDataQualityResultResponseList()
                self.quality_result_response_list.append(temp_model.from_map(k))
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetQualityResultResponseBody(TeaModel):
    def __init__(
        self,
        channel_type_name: str = None,
        code: str = None,
        data: GetQualityResultResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.channel_type_name = channel_type_name
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type_name is not None:
            result['ChannelTypeName'] = self.channel_type_name
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelTypeName') is not None:
            self.channel_type_name = m.get('ChannelTypeName')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQualityResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQualityResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityRuleDetailRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        quality_rule_id: int = None,
    ):
        self.instance_id = instance_id
        self.quality_rule_id = quality_rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.quality_rule_id is not None:
            result['QualityRuleId'] = self.quality_rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('QualityRuleId') is not None:
            self.quality_rule_id = m.get('QualityRuleId')
        return self


class GetQualityRuleDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        key_words: List[str] = None,
        match_type: int = None,
        name: str = None,
        rule_create_time: str = None,
        rule_id: int = None,
        rule_tag: int = None,
    ):
        self.key_words = key_words
        self.match_type = match_type
        self.name = name
        self.rule_create_time = rule_create_time
        self.rule_id = rule_id
        self.rule_tag = rule_tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_words is not None:
            result['KeyWords'] = self.key_words
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_create_time is not None:
            result['RuleCreateTime'] = self.rule_create_time
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_tag is not None:
            result['RuleTag'] = self.rule_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeyWords') is not None:
            self.key_words = m.get('KeyWords')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleCreateTime') is not None:
            self.rule_create_time = m.get('RuleCreateTime')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleTag') is not None:
            self.rule_tag = m.get('RuleTag')
        return self


class GetQualityRuleDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQualityRuleDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQualityRuleDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityRuleDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQualityRuleDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityRuleDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityRuleListRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        page_no: int = None,
        page_size: int = None,
    ):
        self.instance_id = instance_id
        self.page_no = page_no
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetQualityRuleListResponseBodyDataQualityRuleList(TeaModel):
    def __init__(
        self,
        key_words: List[str] = None,
        match_type: int = None,
        name: str = None,
        rule_create_time: str = None,
        rule_id: int = None,
        rule_tag: int = None,
    ):
        self.key_words = key_words
        self.match_type = match_type
        self.name = name
        self.rule_create_time = rule_create_time
        self.rule_id = rule_id
        self.rule_tag = rule_tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_words is not None:
            result['KeyWords'] = self.key_words
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_create_time is not None:
            result['RuleCreateTime'] = self.rule_create_time
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_tag is not None:
            result['RuleTag'] = self.rule_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeyWords') is not None:
            self.key_words = m.get('KeyWords')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleCreateTime') is not None:
            self.rule_create_time = m.get('RuleCreateTime')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleTag') is not None:
            self.rule_tag = m.get('RuleTag')
        return self


class GetQualityRuleListResponseBodyData(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        quality_rule_list: List[GetQualityRuleListResponseBodyDataQualityRuleList] = None,
        total: int = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.quality_rule_list = quality_rule_list
        self.total = total

    def validate(self):
        if self.quality_rule_list:
            for k in self.quality_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QualityRuleList'] = []
        if self.quality_rule_list is not None:
            for k in self.quality_rule_list:
                result['QualityRuleList'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.quality_rule_list = []
        if m.get('QualityRuleList') is not None:
            for k in m.get('QualityRuleList'):
                temp_model = GetQualityRuleListResponseBodyDataQualityRuleList()
                self.quality_rule_list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetQualityRuleListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQualityRuleListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQualityRuleListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityRuleListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQualityRuleListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityRuleTagListRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetQualityRuleTagListResponseBodyData(TeaModel):
    def __init__(
        self,
        rule_tag_id: int = None,
        rule_tag_name: str = None,
    ):
        self.rule_tag_id = rule_tag_id
        self.rule_tag_name = rule_tag_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_tag_id is not None:
            result['RuleTagId'] = self.rule_tag_id
        if self.rule_tag_name is not None:
            result['RuleTagName'] = self.rule_tag_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleTagId') is not None:
            self.rule_tag_id = m.get('RuleTagId')
        if m.get('RuleTagName') is not None:
            self.rule_tag_name = m.get('RuleTagName')
        return self


class GetQualityRuleTagListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[GetQualityRuleTagListResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetQualityRuleTagListResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityRuleTagListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQualityRuleTagListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityRuleTagListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueueInformationRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids: List[int] = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids = group_ids
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetQueueInformationShrinkRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids_shrink: str = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids_shrink = group_ids_shrink
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetQueueInformationResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetQueueInformationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetQueueInformationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQueueInformationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQueueInformationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetQueueInformationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQueueInformationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRecordDataRequest(TeaModel):
    def __init__(
        self,
        acid: str = None,
        instance_id: str = None,
    ):
        self.acid = acid
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetRecordDataResponseBodyData(TeaModel):
    def __init__(
        self,
        acid: str = None,
        oss_link: str = None,
    ):
        self.acid = acid
        self.oss_link = oss_link

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.oss_link is not None:
            result['OssLink'] = self.oss_link
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('OssLink') is not None:
            self.oss_link = m.get('OssLink')
        return self


class GetRecordDataResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetRecordDataResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetRecordDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRecordDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRecordDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRecordDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRecordUrlRequest(TeaModel):
    def __init__(
        self,
        acid: str = None,
        instance_id: str = None,
        record_type: str = None,
    ):
        self.acid = acid
        self.instance_id = instance_id
        self.record_type = record_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        return self


class GetRecordUrlResponseBodyData(TeaModel):
    def __init__(
        self,
        acid: str = None,
        oss_link: str = None,
    ):
        self.acid = acid
        self.oss_link = oss_link

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.oss_link is not None:
            result['OssLink'] = self.oss_link
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('OssLink') is not None:
            self.oss_link = m.get('OssLink')
        return self


class GetRecordUrlResponseBody(TeaModel):
    def __init__(
        self,
        data: GetRecordUrlResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetRecordUrlResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRecordUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRecordUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRecordUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRtcTokenRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetRtcTokenResponseBodyData(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        rtc_id: str = None,
        token: str = None,
    ):
        self.account_name = account_name
        self.rtc_id = rtc_id
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.rtc_id is not None:
            result['RtcId'] = self.rtc_id
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('RtcId') is not None:
            self.rtc_id = m.get('RtcId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class GetRtcTokenResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetRtcTokenResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetRtcTokenResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRtcTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetRtcTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRtcTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSeatInformationRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.instance_id = instance_id
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_page is not None:
            result['currentPage'] = self.current_page
        if self.dep_ids is not None:
            result['depIds'] = self.dep_ids
        if self.end_date is not None:
            result['endDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['existDepartmentGrouping'] = self.exist_department_grouping
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.start_date is not None:
            result['startDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('currentPage') is not None:
            self.current_page = m.get('currentPage')
        if m.get('depIds') is not None:
            self.dep_ids = m.get('depIds')
        if m.get('endDate') is not None:
            self.end_date = m.get('endDate')
        if m.get('existDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('existDepartmentGrouping')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('startDate') is not None:
            self.start_date = m.get('startDate')
        return self


class GetSeatInformationShrinkRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.instance_id = instance_id
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_page is not None:
            result['currentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['depIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['endDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['existDepartmentGrouping'] = self.exist_department_grouping
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.start_date is not None:
            result['startDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('currentPage') is not None:
            self.current_page = m.get('currentPage')
        if m.get('depIds') is not None:
            self.dep_ids_shrink = m.get('depIds')
        if m.get('endDate') is not None:
            self.end_date = m.get('endDate')
        if m.get('existDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('existDepartmentGrouping')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('startDate') is not None:
            self.start_date = m.get('startDate')
        return self


class GetSeatInformationResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rowr: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rowr = rowr
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rowr is not None:
            result['Rowr'] = self.rowr
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rowr') is not None:
            self.rowr = m.get('Rowr')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSeatInformationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetSeatInformationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSeatInformationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSeatInformationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSeatInformationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSeatInformationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupAgentStatusDetailsRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids: List[int] = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids = group_ids
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupAgentStatusDetailsShrinkRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids_shrink: str = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids_shrink = group_ids_shrink
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupAgentStatusDetailsResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSkillGroupAgentStatusDetailsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetSkillGroupAgentStatusDetailsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupAgentStatusDetailsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSkillGroupAgentStatusDetailsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSkillGroupAgentStatusDetailsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupAgentStatusDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupAndAgentStatusSummaryRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids: List[int] = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids = group_ids
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupAndAgentStatusSummaryShrinkRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids_shrink: str = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids_shrink = group_ids_shrink
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupAndAgentStatusSummaryResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSkillGroupAndAgentStatusSummaryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetSkillGroupAndAgentStatusSummaryResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupAndAgentStatusSummaryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSkillGroupAndAgentStatusSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSkillGroupAndAgentStatusSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupAndAgentStatusSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupLatitudeStateRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids: List[int] = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids = group_ids
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupLatitudeStateShrinkRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids_shrink: str = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids_shrink = group_ids_shrink
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupLatitudeStateResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSkillGroupLatitudeStateResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetSkillGroupLatitudeStateResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupLatitudeStateResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSkillGroupLatitudeStateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSkillGroupLatitudeStateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupLatitudeStateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupServiceCapabilityRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids: List[int] = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids = group_ids
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupServiceCapabilityShrinkRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids_shrink: str = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
    ):
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids_shrink = group_ids_shrink
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupServiceCapabilityResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSkillGroupServiceCapabilityResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetSkillGroupServiceCapabilityResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupServiceCapabilityResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSkillGroupServiceCapabilityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSkillGroupServiceCapabilityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupServiceCapabilityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupServiceStatusRequest(TeaModel):
    def __init__(
        self,
        agent_ids: List[int] = None,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_channel_instance_grouping: bool = None,
        exist_department_grouping: bool = None,
        exist_robot_instance_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids: List[int] = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids = agent_ids
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_channel_instance_grouping = exist_channel_instance_grouping
        self.exist_department_grouping = exist_department_grouping
        self.exist_robot_instance_grouping = exist_robot_instance_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids = group_ids
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_channel_instance_grouping is not None:
            result['ExistChannelInstanceGrouping'] = self.exist_channel_instance_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_robot_instance_grouping is not None:
            result['ExistRobotInstanceGrouping'] = self.exist_robot_instance_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistChannelInstanceGrouping') is not None:
            self.exist_channel_instance_grouping = m.get('ExistChannelInstanceGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistRobotInstanceGrouping') is not None:
            self.exist_robot_instance_grouping = m.get('ExistRobotInstanceGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetSkillGroupServiceStatusShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_ids_shrink: str = None,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_channel_instance_grouping: bool = None,
        exist_department_grouping: bool = None,
        exist_robot_instance_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids_shrink: str = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids_shrink = agent_ids_shrink
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_channel_instance_grouping = exist_channel_instance_grouping
        self.exist_department_grouping = exist_department_grouping
        self.exist_robot_instance_grouping = exist_robot_instance_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids_shrink = group_ids_shrink
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_channel_instance_grouping is not None:
            result['ExistChannelInstanceGrouping'] = self.exist_channel_instance_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_robot_instance_grouping is not None:
            result['ExistRobotInstanceGrouping'] = self.exist_robot_instance_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistChannelInstanceGrouping') is not None:
            self.exist_channel_instance_grouping = m.get('ExistChannelInstanceGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistRobotInstanceGrouping') is not None:
            self.exist_robot_instance_grouping = m.get('ExistRobotInstanceGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetSkillGroupServiceStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSkillGroupServiceStatusResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetSkillGroupServiceStatusResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupServiceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSkillGroupServiceStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSkillGroupServiceStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupServiceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupStatusTotalRequest(TeaModel):
    def __init__(
        self,
        agent_ids: List[int] = None,
        current_page: int = None,
        dep_ids: List[int] = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids: List[int] = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids = agent_ids
        self.current_page = current_page
        self.dep_ids = dep_ids
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids = group_ids
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetSkillGroupStatusTotalShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_ids_shrink: str = None,
        current_page: int = None,
        dep_ids_shrink: str = None,
        end_date: int = None,
        exist_agent_grouping: bool = None,
        exist_department_grouping: bool = None,
        exist_skill_group_grouping: bool = None,
        group_ids_shrink: str = None,
        instance_id: str = None,
        page_size: int = None,
        start_date: int = None,
        time_latitude_type: str = None,
    ):
        self.agent_ids_shrink = agent_ids_shrink
        self.current_page = current_page
        self.dep_ids_shrink = dep_ids_shrink
        self.end_date = end_date
        self.exist_agent_grouping = exist_agent_grouping
        self.exist_department_grouping = exist_department_grouping
        self.exist_skill_group_grouping = exist_skill_group_grouping
        self.group_ids_shrink = group_ids_shrink
        self.instance_id = instance_id
        self.page_size = page_size
        self.start_date = start_date
        self.time_latitude_type = time_latitude_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetSkillGroupStatusTotalResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        rows: str = None,
        total_num: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.rows = rows
        self.total_num = total_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSkillGroupStatusTotalResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetSkillGroupStatusTotalResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupStatusTotalResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSkillGroupStatusTotalResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSkillGroupStatusTotalResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupStatusTotalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HangUpDoubleCallRequest(TeaModel):
    def __init__(
        self,
        acid: str = None,
        instance_id: str = None,
    ):
        self.acid = acid
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class HangUpDoubleCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class HangUpDoubleCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: HangUpDoubleCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HangUpDoubleCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HangupCallRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        call_id: str = None,
        client_token: str = None,
        connection_id: str = None,
        instance_id: str = None,
        job_id: str = None,
    ):
        self.account_name = account_name
        self.call_id = call_id
        self.client_token = client_token
        self.connection_id = connection_id
        self.instance_id = instance_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class HangupCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class HangupCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: HangupCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HangupCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HangupThirdCallRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        call_id: str = None,
        client_token: str = None,
        connection_id: str = None,
        instance_id: str = None,
        job_id: str = None,
    ):
        self.account_name = account_name
        self.call_id = call_id
        self.client_token = client_token
        self.connection_id = connection_id
        self.instance_id = instance_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class HangupThirdCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class HangupThirdCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: HangupThirdCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HangupThirdCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HoldCallRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        call_id: str = None,
        client_token: str = None,
        connection_id: str = None,
        instance_id: str = None,
        job_id: str = None,
    ):
        self.account_name = account_name
        self.call_id = call_id
        self.client_token = client_token
        self.connection_id = connection_id
        self.instance_id = instance_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class HoldCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class HoldCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: HoldCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HoldCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HotlineSessionQueryRequest(TeaModel):
    def __init__(
        self,
        acid: str = None,
        acid_list: List[str] = None,
        call_result: str = None,
        call_result_list: List[str] = None,
        call_type: int = None,
        call_type_list: List[int] = None,
        called_number: str = None,
        called_number_list: List[str] = None,
        calling_number: str = None,
        calling_number_list: List[str] = None,
        group_id: int = None,
        group_id_list: List[int] = None,
        group_name: str = None,
        id: str = None,
        instance_id: str = None,
        member_id: str = None,
        member_id_list: List[str] = None,
        member_name: str = None,
        page_no: int = None,
        page_size: int = None,
        params: str = None,
        query_end_time: int = None,
        query_start_time: int = None,
        request_id: str = None,
        servicer_id: str = None,
        servicer_id_list: List[str] = None,
        servicer_name: str = None,
    ):
        self.acid = acid
        self.acid_list = acid_list
        self.call_result = call_result
        self.call_result_list = call_result_list
        self.call_type = call_type
        self.call_type_list = call_type_list
        self.called_number = called_number
        self.called_number_list = called_number_list
        self.calling_number = calling_number
        self.calling_number_list = calling_number_list
        self.group_id = group_id
        self.group_id_list = group_id_list
        self.group_name = group_name
        self.id = id
        self.instance_id = instance_id
        self.member_id = member_id
        self.member_id_list = member_id_list
        self.member_name = member_name
        self.page_no = page_no
        self.page_size = page_size
        self.params = params
        self.query_end_time = query_end_time
        self.query_start_time = query_start_time
        self.request_id = request_id
        self.servicer_id = servicer_id
        self.servicer_id_list = servicer_id_list
        self.servicer_name = servicer_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.acid_list is not None:
            result['AcidList'] = self.acid_list
        if self.call_result is not None:
            result['CallResult'] = self.call_result
        if self.call_result_list is not None:
            result['CallResultList'] = self.call_result_list
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.call_type_list is not None:
            result['CallTypeList'] = self.call_type_list
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.called_number_list is not None:
            result['CalledNumberList'] = self.called_number_list
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.calling_number_list is not None:
            result['CallingNumberList'] = self.calling_number_list
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_id_list is not None:
            result['MemberIdList'] = self.member_id_list
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.params is not None:
            result['Params'] = self.params
        if self.query_end_time is not None:
            result['QueryEndTime'] = self.query_end_time
        if self.query_start_time is not None:
            result['QueryStartTime'] = self.query_start_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_id_list is not None:
            result['ServicerIdList'] = self.servicer_id_list
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('AcidList') is not None:
            self.acid_list = m.get('AcidList')
        if m.get('CallResult') is not None:
            self.call_result = m.get('CallResult')
        if m.get('CallResultList') is not None:
            self.call_result_list = m.get('CallResultList')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('CallTypeList') is not None:
            self.call_type_list = m.get('CallTypeList')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CalledNumberList') is not None:
            self.called_number_list = m.get('CalledNumberList')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('CallingNumberList') is not None:
            self.calling_number_list = m.get('CallingNumberList')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberIdList') is not None:
            self.member_id_list = m.get('MemberIdList')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('QueryEndTime') is not None:
            self.query_end_time = m.get('QueryEndTime')
        if m.get('QueryStartTime') is not None:
            self.query_start_time = m.get('QueryStartTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerIdList') is not None:
            self.servicer_id_list = m.get('ServicerIdList')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        return self


class HotlineSessionQueryResponseBodyDataCallDetailRecord(TeaModel):
    def __init__(
        self,
        acid: str = None,
        active_transfer_id: str = None,
        call_continue_time: int = None,
        call_result: str = None,
        call_type: int = None,
        called_number: str = None,
        calling_number: str = None,
        create_time: str = None,
        evaluation_level: int = None,
        evaluation_score: int = None,
        group_id: int = None,
        group_name: str = None,
        hang_up_role: str = None,
        hang_up_time: str = None,
        id: str = None,
        in_queue_time: str = None,
        member_id: str = None,
        member_name: str = None,
        out_queue_time: str = None,
        passive_transfer_id: str = None,
        passive_transfer_id_type: str = None,
        pick_up_time: str = None,
        queue_up_continue_time: int = None,
        ring_continue_time: int = None,
        ring_end_time: str = None,
        ring_start_time: str = None,
        servicer_id: str = None,
        servicer_name: str = None,
        trunk_call: str = None,
    ):
        self.acid = acid
        self.active_transfer_id = active_transfer_id
        self.call_continue_time = call_continue_time
        self.call_result = call_result
        self.call_type = call_type
        self.called_number = called_number
        self.calling_number = calling_number
        self.create_time = create_time
        self.evaluation_level = evaluation_level
        self.evaluation_score = evaluation_score
        self.group_id = group_id
        self.group_name = group_name
        self.hang_up_role = hang_up_role
        self.hang_up_time = hang_up_time
        self.id = id
        self.in_queue_time = in_queue_time
        self.member_id = member_id
        self.member_name = member_name
        self.out_queue_time = out_queue_time
        self.passive_transfer_id = passive_transfer_id
        self.passive_transfer_id_type = passive_transfer_id_type
        self.pick_up_time = pick_up_time
        self.queue_up_continue_time = queue_up_continue_time
        self.ring_continue_time = ring_continue_time
        self.ring_end_time = ring_end_time
        self.ring_start_time = ring_start_time
        self.servicer_id = servicer_id
        self.servicer_name = servicer_name
        self.trunk_call = trunk_call

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.active_transfer_id is not None:
            result['ActiveTransferId'] = self.active_transfer_id
        if self.call_continue_time is not None:
            result['CallContinueTime'] = self.call_continue_time
        if self.call_result is not None:
            result['CallResult'] = self.call_result
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.evaluation_score is not None:
            result['EvaluationScore'] = self.evaluation_score
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.hang_up_role is not None:
            result['HangUpRole'] = self.hang_up_role
        if self.hang_up_time is not None:
            result['HangUpTime'] = self.hang_up_time
        if self.id is not None:
            result['Id'] = self.id
        if self.in_queue_time is not None:
            result['InQueueTime'] = self.in_queue_time
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.out_queue_time is not None:
            result['OutQueueTime'] = self.out_queue_time
        if self.passive_transfer_id is not None:
            result['PassiveTransferId'] = self.passive_transfer_id
        if self.passive_transfer_id_type is not None:
            result['PassiveTransferIdType'] = self.passive_transfer_id_type
        if self.pick_up_time is not None:
            result['PickUpTime'] = self.pick_up_time
        if self.queue_up_continue_time is not None:
            result['QueueUpContinueTime'] = self.queue_up_continue_time
        if self.ring_continue_time is not None:
            result['RingContinueTime'] = self.ring_continue_time
        if self.ring_end_time is not None:
            result['RingEndTime'] = self.ring_end_time
        if self.ring_start_time is not None:
            result['RingStartTime'] = self.ring_start_time
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.trunk_call is not None:
            result['TrunkCall'] = self.trunk_call
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('ActiveTransferId') is not None:
            self.active_transfer_id = m.get('ActiveTransferId')
        if m.get('CallContinueTime') is not None:
            self.call_continue_time = m.get('CallContinueTime')
        if m.get('CallResult') is not None:
            self.call_result = m.get('CallResult')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('EvaluationScore') is not None:
            self.evaluation_score = m.get('EvaluationScore')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HangUpRole') is not None:
            self.hang_up_role = m.get('HangUpRole')
        if m.get('HangUpTime') is not None:
            self.hang_up_time = m.get('HangUpTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InQueueTime') is not None:
            self.in_queue_time = m.get('InQueueTime')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('OutQueueTime') is not None:
            self.out_queue_time = m.get('OutQueueTime')
        if m.get('PassiveTransferId') is not None:
            self.passive_transfer_id = m.get('PassiveTransferId')
        if m.get('PassiveTransferIdType') is not None:
            self.passive_transfer_id_type = m.get('PassiveTransferIdType')
        if m.get('PickUpTime') is not None:
            self.pick_up_time = m.get('PickUpTime')
        if m.get('QueueUpContinueTime') is not None:
            self.queue_up_continue_time = m.get('QueueUpContinueTime')
        if m.get('RingContinueTime') is not None:
            self.ring_continue_time = m.get('RingContinueTime')
        if m.get('RingEndTime') is not None:
            self.ring_end_time = m.get('RingEndTime')
        if m.get('RingStartTime') is not None:
            self.ring_start_time = m.get('RingStartTime')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('TrunkCall') is not None:
            self.trunk_call = m.get('TrunkCall')
        return self


class HotlineSessionQueryResponseBodyData(TeaModel):
    def __init__(
        self,
        call_detail_record: List[HotlineSessionQueryResponseBodyDataCallDetailRecord] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.call_detail_record = call_detail_record
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.call_detail_record:
            for k in self.call_detail_record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CallDetailRecord'] = []
        if self.call_detail_record is not None:
            for k in self.call_detail_record:
                result['CallDetailRecord'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.call_detail_record = []
        if m.get('CallDetailRecord') is not None:
            for k in m.get('CallDetailRecord'):
                temp_model = HotlineSessionQueryResponseBodyDataCallDetailRecord()
                self.call_detail_record.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class HotlineSessionQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: HotlineSessionQueryResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = HotlineSessionQueryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class HotlineSessionQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: HotlineSessionQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HotlineSessionQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InsertAiOutboundPhoneNumsRequestDetails(TeaModel):
    def __init__(
        self,
        biz_data: str = None,
        phone_num: str = None,
    ):
        self.biz_data = biz_data
        self.phone_num = phone_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_data is not None:
            result['BizData'] = self.biz_data
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizData') is not None:
            self.biz_data = m.get('BizData')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        return self


class InsertAiOutboundPhoneNumsRequest(TeaModel):
    def __init__(
        self,
        batch_version: int = None,
        details: List[InsertAiOutboundPhoneNumsRequestDetails] = None,
        instance_id: str = None,
        task_id: int = None,
    ):
        self.batch_version = batch_version
        self.details = details
        self.instance_id = instance_id
        self.task_id = task_id

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_version is not None:
            result['BatchVersion'] = self.batch_version
        result['Details'] = []
        if self.details is not None:
            for k in self.details:
                result['Details'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchVersion') is not None:
            self.batch_version = m.get('BatchVersion')
        self.details = []
        if m.get('Details') is not None:
            for k in m.get('Details'):
                temp_model = InsertAiOutboundPhoneNumsRequestDetails()
                self.details.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class InsertAiOutboundPhoneNumsShrinkRequest(TeaModel):
    def __init__(
        self,
        batch_version: int = None,
        details_shrink: str = None,
        instance_id: str = None,
        task_id: int = None,
    ):
        self.batch_version = batch_version
        self.details_shrink = details_shrink
        self.instance_id = instance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_version is not None:
            result['BatchVersion'] = self.batch_version
        if self.details_shrink is not None:
            result['Details'] = self.details_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchVersion') is not None:
            self.batch_version = m.get('BatchVersion')
        if m.get('Details') is not None:
            self.details_shrink = m.get('Details')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class InsertAiOutboundPhoneNumsResponseBodyDataFailInfo(TeaModel):
    def __init__(
        self,
        biz_data: str = None,
        msg: str = None,
        phone_num: str = None,
    ):
        self.biz_data = biz_data
        self.msg = msg
        self.phone_num = phone_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_data is not None:
            result['BizData'] = self.biz_data
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizData') is not None:
            self.biz_data = m.get('BizData')
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        return self


class InsertAiOutboundPhoneNumsResponseBodyData(TeaModel):
    def __init__(
        self,
        fail_info: List[InsertAiOutboundPhoneNumsResponseBodyDataFailInfo] = None,
        success_count: int = None,
        total_count: int = None,
    ):
        self.fail_info = fail_info
        self.success_count = success_count
        self.total_count = total_count

    def validate(self):
        if self.fail_info:
            for k in self.fail_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FailInfo'] = []
        if self.fail_info is not None:
            for k in self.fail_info:
                result['FailInfo'].append(k.to_map() if k else None)
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fail_info = []
        if m.get('FailInfo') is not None:
            for k in m.get('FailInfo'):
                temp_model = InsertAiOutboundPhoneNumsResponseBodyDataFailInfo()
                self.fail_info.append(temp_model.from_map(k))
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class InsertAiOutboundPhoneNumsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: InsertAiOutboundPhoneNumsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = InsertAiOutboundPhoneNumsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InsertAiOutboundPhoneNumsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InsertAiOutboundPhoneNumsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InsertAiOutboundPhoneNumsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InsertTaskDetailRequest(TeaModel):
    def __init__(
        self,
        call_infos: str = None,
        instance_id: str = None,
        outbound_task_id: int = None,
    ):
        self.call_infos = call_infos
        self.instance_id = instance_id
        self.outbound_task_id = outbound_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_infos is not None:
            result['CallInfos'] = self.call_infos
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_task_id is not None:
            result['OutboundTaskId'] = self.outbound_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallInfos') is not None:
            self.call_infos = m.get('CallInfos')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundTaskId') is not None:
            self.outbound_task_id = m.get('OutboundTaskId')
        return self


class InsertTaskDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InsertTaskDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InsertTaskDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InsertTaskDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class JoinThirdCallRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        call_id: str = None,
        client_token: str = None,
        connection_id: str = None,
        hold_connection_id: str = None,
        instance_id: str = None,
        job_id: str = None,
    ):
        self.account_name = account_name
        self.call_id = call_id
        self.client_token = client_token
        self.connection_id = connection_id
        self.hold_connection_id = hold_connection_id
        self.instance_id = instance_id
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.hold_connection_id is not None:
            result['HoldConnectionId'] = self.hold_connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('HoldConnectionId') is not None:
            self.hold_connection_id = m.get('HoldConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class JoinThirdCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class JoinThirdCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: JoinThirdCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = JoinThirdCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentBySkillGroupIdRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        instance_id: str = None,
        skill_group_id: int = None,
    ):
        self.client_token = client_token
        self.instance_id = instance_id
        self.skill_group_id = skill_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class ListAgentBySkillGroupIdResponseBodyData(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        agent_id: int = None,
        display_name: str = None,
        status: int = None,
        tenant_id: int = None,
    ):
        self.account_name = account_name
        self.agent_id = agent_id
        self.display_name = display_name
        self.status = status
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListAgentBySkillGroupIdResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListAgentBySkillGroupIdResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAgentBySkillGroupIdResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAgentBySkillGroupIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAgentBySkillGroupIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAgentBySkillGroupIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAiccsRobotRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        robot_name: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.robot_name = robot_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.robot_name is not None:
            result['RobotName'] = self.robot_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RobotName') is not None:
            self.robot_name = m.get('RobotName')
        return self


class ListAiccsRobotResponseBodyData(TeaModel):
    def __init__(
        self,
        at_profession: str = None,
        at_sence: str = None,
        id: int = None,
        robot_name: str = None,
        robot_type: str = None,
    ):
        self.at_profession = at_profession
        self.at_sence = at_sence
        self.id = id
        self.robot_name = robot_name
        self.robot_type = robot_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.at_profession is not None:
            result['AtProfession'] = self.at_profession
        if self.at_sence is not None:
            result['AtSence'] = self.at_sence
        if self.id is not None:
            result['Id'] = self.id
        if self.robot_name is not None:
            result['RobotName'] = self.robot_name
        if self.robot_type is not None:
            result['RobotType'] = self.robot_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AtProfession') is not None:
            self.at_profession = m.get('AtProfession')
        if m.get('AtSence') is not None:
            self.at_sence = m.get('AtSence')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RobotName') is not None:
            self.robot_name = m.get('RobotName')
        if m.get('RobotType') is not None:
            self.robot_type = m.get('RobotType')
        return self


class ListAiccsRobotResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListAiccsRobotResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAiccsRobotResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAiccsRobotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListAiccsRobotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAiccsRobotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListChatRecordDetailRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        close_time_end: int = None,
        close_time_start: int = None,
        current_page: int = None,
        instance_id: str = None,
        page_size: int = None,
    ):
        self.client_token = client_token
        self.close_time_end = close_time_end
        self.close_time_start = close_time_start
        self.current_page = current_page
        self.instance_id = instance_id
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.close_time_end is not None:
            result['CloseTimeEnd'] = self.close_time_end
        if self.close_time_start is not None:
            result['CloseTimeStart'] = self.close_time_start
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CloseTimeEnd') is not None:
            self.close_time_end = m.get('CloseTimeEnd')
        if m.get('CloseTimeStart') is not None:
            self.close_time_start = m.get('CloseTimeStart')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListChatRecordDetailResponseBodyResultDataDataMessageList(TeaModel):
    def __init__(
        self,
        content: str = None,
        create_time: int = None,
        msg_type: str = None,
        sender_name: str = None,
        sender_type: int = None,
    ):
        self.content = content
        self.create_time = create_time
        self.msg_type = msg_type
        self.sender_name = sender_name
        self.sender_type = sender_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.msg_type is not None:
            result['MsgType'] = self.msg_type
        if self.sender_name is not None:
            result['SenderName'] = self.sender_name
        if self.sender_type is not None:
            result['SenderType'] = self.sender_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('MsgType') is not None:
            self.msg_type = m.get('MsgType')
        if m.get('SenderName') is not None:
            self.sender_name = m.get('SenderName')
        if m.get('SenderType') is not None:
            self.sender_type = m.get('SenderType')
        return self


class ListChatRecordDetailResponseBodyResultDataData(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        message_list: List[ListChatRecordDetailResponseBodyResultDataDataMessageList] = None,
        servicer_name: str = None,
        start_time: int = None,
    ):
        self.end_time = end_time
        self.message_list = message_list
        self.servicer_name = servicer_name
        self.start_time = start_time

    def validate(self):
        if self.message_list:
            for k in self.message_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        result['MessageList'] = []
        if self.message_list is not None:
            for k in self.message_list:
                result['MessageList'].append(k.to_map() if k else None)
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        self.message_list = []
        if m.get('MessageList') is not None:
            for k in m.get('MessageList'):
                temp_model = ListChatRecordDetailResponseBodyResultDataDataMessageList()
                self.message_list.append(temp_model.from_map(k))
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListChatRecordDetailResponseBodyResultData(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        data: List[ListChatRecordDetailResponseBodyResultDataData] = None,
        one_page_size: int = None,
        total_page: int = None,
        total_results: int = None,
    ):
        self.current_page = current_page
        self.data = data
        self.one_page_size = one_page_size
        self.total_page = total_page
        self.total_results = total_results

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.one_page_size is not None:
            result['OnePageSize'] = self.one_page_size
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListChatRecordDetailResponseBodyResultDataData()
                self.data.append(temp_model.from_map(k))
        if m.get('OnePageSize') is not None:
            self.one_page_size = m.get('OnePageSize')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class ListChatRecordDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        result_data: ListChatRecordDetailResponseBodyResultData = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.result_data = result_data
        self.success = success

    def validate(self):
        if self.result_data:
            self.result_data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result_data is not None:
            result['ResultData'] = self.result_data.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResultData') is not None:
            temp_model = ListChatRecordDetailResponseBodyResultData()
            self.result_data = temp_model.from_map(m['ResultData'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListChatRecordDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListChatRecordDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListChatRecordDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDialogRequest(TeaModel):
    def __init__(
        self,
        called: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        task_id: int = None,
    ):
        self.called = called
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.called is not None:
            result['Called'] = self.called
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Called') is not None:
            self.called = m.get('Called')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ListDialogResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        node_type: str = None,
        role: str = None,
        tag: str = None,
        time: str = None,
    ):
        self.content = content
        self.node_type = node_type
        self.role = role
        self.tag = tag
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.role is not None:
            result['Role'] = self.role
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class ListDialogResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListDialogResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListDialogResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListDialogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListDialogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDialogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHotlineRecordRequest(TeaModel):
    def __init__(
        self,
        call_id: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.call_id = call_id
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListHotlineRecordResponseBodyData(TeaModel):
    def __init__(
        self,
        call_id: str = None,
        connection_id: str = None,
        end_time: int = None,
        start_time: int = None,
        url: str = None,
    ):
        self.call_id = call_id
        self.connection_id = connection_id
        self.end_time = end_time
        self.start_time = start_time
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListHotlineRecordResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListHotlineRecordResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListHotlineRecordResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListHotlineRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListHotlineRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListHotlineRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHotlineRecordDetailRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        close_time_end: int = None,
        close_time_start: int = None,
        current_page: int = None,
        instance_id: str = None,
        page_size: int = None,
    ):
        self.client_token = client_token
        self.close_time_end = close_time_end
        self.close_time_start = close_time_start
        self.current_page = current_page
        self.instance_id = instance_id
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.close_time_end is not None:
            result['CloseTimeEnd'] = self.close_time_end
        if self.close_time_start is not None:
            result['CloseTimeStart'] = self.close_time_start
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CloseTimeEnd') is not None:
            self.close_time_end = m.get('CloseTimeEnd')
        if m.get('CloseTimeStart') is not None:
            self.close_time_start = m.get('CloseTimeStart')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListHotlineRecordDetailResponseBodyResultDataData(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        oss_url: str = None,
        servicer_name: str = None,
        start_time: int = None,
    ):
        self.end_time = end_time
        self.oss_url = oss_url
        self.servicer_name = servicer_name
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.oss_url is not None:
            result['OssUrl'] = self.oss_url
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OssUrl') is not None:
            self.oss_url = m.get('OssUrl')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListHotlineRecordDetailResponseBodyResultData(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        data: List[ListHotlineRecordDetailResponseBodyResultDataData] = None,
        one_page_size: int = None,
        total_page: int = None,
        total_results: int = None,
    ):
        self.current_page = current_page
        self.data = data
        self.one_page_size = one_page_size
        self.total_page = total_page
        self.total_results = total_results

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.one_page_size is not None:
            result['OnePageSize'] = self.one_page_size
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListHotlineRecordDetailResponseBodyResultDataData()
                self.data.append(temp_model.from_map(k))
        if m.get('OnePageSize') is not None:
            self.one_page_size = m.get('OnePageSize')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class ListHotlineRecordDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        result_data: ListHotlineRecordDetailResponseBodyResultData = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.result_data = result_data
        self.success = success

    def validate(self):
        if self.result_data:
            self.result_data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result_data is not None:
            result['ResultData'] = self.result_data.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResultData') is not None:
            temp_model = ListHotlineRecordDetailResponseBodyResultData()
            self.result_data = temp_model.from_map(m['ResultData'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListHotlineRecordDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListHotlineRecordDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListHotlineRecordDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOutboundPhoneNumberRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListOutboundPhoneNumberResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[str] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListOutboundPhoneNumberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListOutboundPhoneNumberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListOutboundPhoneNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOuterOrderedNumbersRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        prod_code: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_id = owner_id
        self.prod_code = prod_code
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListOuterOrderedNumbersResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        numbers: List[str] = None,
        request_id: str = None,
    ):
        self.code = code
        self.message = message
        self.numbers = numbers
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.numbers is not None:
            result['Numbers'] = self.numbers
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Numbers') is not None:
            self.numbers = m.get('Numbers')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListOuterOrderedNumbersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListOuterOrderedNumbersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListOuterOrderedNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRobotCallDialogRequest(TeaModel):
    def __init__(
        self,
        call_id: str = None,
        create_time: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.call_id = call_id
        self.create_time = create_time
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListRobotCallDialogResponseBodyData(TeaModel):
    def __init__(
        self,
        content: str = None,
        node_type: str = None,
        role: str = None,
        tag: str = None,
        time: str = None,
    ):
        self.content = content
        self.node_type = node_type
        self.role = role
        self.tag = tag
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.role is not None:
            result['Role'] = self.role
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class ListRobotCallDialogResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListRobotCallDialogResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListRobotCallDialogResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListRobotCallDialogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListRobotCallDialogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRobotCallDialogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRobotNodeRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        robot_id: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.robot_id = robot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        return self


class ListRobotNodeResponseBodyData(TeaModel):
    def __init__(
        self,
        is_output: int = None,
        model_name: str = None,
        node_identifier: str = None,
        node_name: str = None,
        process_name: str = None,
    ):
        self.is_output = is_output
        self.model_name = model_name
        self.node_identifier = node_identifier
        self.node_name = node_name
        self.process_name = process_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_output is not None:
            result['IsOutput'] = self.is_output
        if self.model_name is not None:
            result['ModelName'] = self.model_name
        if self.node_identifier is not None:
            result['NodeIdentifier'] = self.node_identifier
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsOutput') is not None:
            self.is_output = m.get('IsOutput')
        if m.get('ModelName') is not None:
            self.model_name = m.get('ModelName')
        if m.get('NodeIdentifier') is not None:
            self.node_identifier = m.get('NodeIdentifier')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        return self


class ListRobotNodeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListRobotNodeResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListRobotNodeResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListRobotNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListRobotNodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRobotNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRobotParamsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        robot_id: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.robot_id = robot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        return self


class ListRobotParamsResponseBodyData(TeaModel):
    def __init__(
        self,
        is_empty: int = None,
        param_code: str = None,
        param_name: str = None,
    ):
        self.is_empty = is_empty
        self.param_code = param_code
        self.param_name = param_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_empty is not None:
            result['IsEmpty'] = self.is_empty
        if self.param_code is not None:
            result['ParamCode'] = self.param_code
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsEmpty') is not None:
            self.is_empty = m.get('IsEmpty')
        if m.get('ParamCode') is not None:
            self.param_code = m.get('ParamCode')
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        return self


class ListRobotParamsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListRobotParamsResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListRobotParamsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListRobotParamsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListRobotParamsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRobotParamsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRolesRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListRolesResponseBodyData(TeaModel):
    def __init__(
        self,
        bu_id: int = None,
        code: str = None,
        create_time: str = None,
        description: str = None,
        role_group_id: int = None,
        role_group_name: str = None,
        role_id: int = None,
        title: str = None,
    ):
        self.bu_id = bu_id
        self.code = code
        self.create_time = create_time
        self.description = description
        self.role_group_id = role_group_id
        self.role_group_name = role_group_name
        self.role_id = role_id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bu_id is not None:
            result['BuId'] = self.bu_id
        if self.code is not None:
            result['Code'] = self.code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.role_group_id is not None:
            result['RoleGroupId'] = self.role_group_id
        if self.role_group_name is not None:
            result['RoleGroupName'] = self.role_group_name
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BuId') is not None:
            self.bu_id = m.get('BuId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RoleGroupId') is not None:
            self.role_group_id = m.get('RoleGroupId')
        if m.get('RoleGroupName') is not None:
            self.role_group_name = m.get('RoleGroupName')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class ListRolesResponseBody(TeaModel):
    def __init__(
        self,
        data: List[ListRolesResponseBodyData] = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListRolesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListRolesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListRolesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRolesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSkillGroupRequest(TeaModel):
    def __init__(
        self,
        channel_type: int = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.channel_type = channel_type
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListSkillGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        channel_type: int = None,
        description: str = None,
        display_name: str = None,
        name: str = None,
        skill_group_id: int = None,
    ):
        self.channel_type = channel_type
        self.description = description
        self.display_name = display_name
        self.name = name
        self.skill_group_id = skill_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.name is not None:
            result['Name'] = self.name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class ListSkillGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ListSkillGroupResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListSkillGroupResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListSkillGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListSkillGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTaskRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        page_no: int = None,
        page_size: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        robot_name: str = None,
        status: str = None,
        task_id: int = None,
        task_name: str = None,
    ):
        self.owner_id = owner_id
        self.page_no = page_no
        self.page_size = page_size
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.robot_name = robot_name
        self.status = status
        self.task_id = task_id
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.robot_name is not None:
            result['RobotName'] = self.robot_name
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RobotName') is not None:
            self.robot_name = m.get('RobotName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class ListTaskResponseBodyDataRecord(TeaModel):
    def __init__(
        self,
        complete_count: int = None,
        fire_time: str = None,
        gmt_create: str = None,
        id: int = None,
        robot_id: int = None,
        robot_name: str = None,
        status: str = None,
        task_name: str = None,
        total_count: int = None,
    ):
        self.complete_count = complete_count
        self.fire_time = fire_time
        self.gmt_create = gmt_create
        self.id = id
        self.robot_id = robot_id
        self.robot_name = robot_name
        self.status = status
        self.task_name = task_name
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete_count is not None:
            result['CompleteCount'] = self.complete_count
        if self.fire_time is not None:
            result['FireTime'] = self.fire_time
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        if self.robot_name is not None:
            result['RobotName'] = self.robot_name
        if self.status is not None:
            result['Status'] = self.status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompleteCount') is not None:
            self.complete_count = m.get('CompleteCount')
        if m.get('FireTime') is not None:
            self.fire_time = m.get('FireTime')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        if m.get('RobotName') is not None:
            self.robot_name = m.get('RobotName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        record: List[ListTaskResponseBodyDataRecord] = None,
        total: int = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.record = record
        self.total = total

    def validate(self):
        if self.record:
            for k in self.record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Record'] = []
        if self.record is not None:
            for k in self.record:
                result['Record'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.record = []
        if m.get('Record') is not None:
            for k in m.get('Record'):
                temp_model = ListTaskResponseBodyDataRecord()
                self.record.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListTaskResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTaskDetailRequest(TeaModel):
    def __init__(
        self,
        called: str = None,
        id: int = None,
        owner_id: int = None,
        page_no: int = None,
        page_size: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        status: str = None,
        status_code: str = None,
        task_id: int = None,
    ):
        self.called = called
        self.id = id
        self.owner_id = owner_id
        self.page_no = page_no
        self.page_size = page_size
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.status = status
        self.status_code = status_code
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.called is not None:
            result['Called'] = self.called
        if self.id is not None:
            result['Id'] = self.id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        if self.status_code is not None:
            result['StatusCode'] = self.status_code
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Called') is not None:
            self.called = m.get('Called')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusCode') is not None:
            self.status_code = m.get('StatusCode')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ListTaskDetailResponseBodyDataRecord(TeaModel):
    def __init__(
        self,
        called: str = None,
        caller: str = None,
        direction: str = None,
        duration: int = None,
        end_time: str = None,
        id: int = None,
        retry_cur_times: int = None,
        retry_times: int = None,
        start_time: str = None,
        status: str = None,
        status_code: str = None,
        status_code_desc: str = None,
        tags: str = None,
    ):
        self.called = called
        self.caller = caller
        self.direction = direction
        self.duration = duration
        self.end_time = end_time
        self.id = id
        self.retry_cur_times = retry_cur_times
        self.retry_times = retry_times
        self.start_time = start_time
        self.status = status
        self.status_code = status_code
        self.status_code_desc = status_code_desc
        self.tags = tags

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.called is not None:
            result['Called'] = self.called
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.id is not None:
            result['Id'] = self.id
        if self.retry_cur_times is not None:
            result['RetryCurTimes'] = self.retry_cur_times
        if self.retry_times is not None:
            result['RetryTimes'] = self.retry_times
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.status_code is not None:
            result['StatusCode'] = self.status_code
        if self.status_code_desc is not None:
            result['StatusCodeDesc'] = self.status_code_desc
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Called') is not None:
            self.called = m.get('Called')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RetryCurTimes') is not None:
            self.retry_cur_times = m.get('RetryCurTimes')
        if m.get('RetryTimes') is not None:
            self.retry_times = m.get('RetryTimes')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusCode') is not None:
            self.status_code = m.get('StatusCode')
        if m.get('StatusCodeDesc') is not None:
            self.status_code_desc = m.get('StatusCodeDesc')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class ListTaskDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        record: List[ListTaskDetailResponseBodyDataRecord] = None,
        total: int = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.record = record
        self.total = total

    def validate(self):
        if self.record:
            for k in self.record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Record'] = []
        if self.record is not None:
            for k in self.record:
                result['Record'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.record = []
        if m.get('Record') is not None:
            for k in m.get('Record'):
                temp_model = ListTaskDetailResponseBodyDataRecord()
                self.record.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListTaskDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ListTaskDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListTaskDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListTaskDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListTaskDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTaskDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MakeCallRequest(TeaModel):
    def __init__(
        self,
        called_number: str = None,
        calling_number: str = None,
        command_code: str = None,
        ext_info: str = None,
        outer_account_id: str = None,
        outer_account_type: str = None,
    ):
        self.called_number = called_number
        self.calling_number = calling_number
        self.command_code = command_code
        self.ext_info = ext_info
        self.outer_account_id = outer_account_id
        self.outer_account_type = outer_account_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.command_code is not None:
            result['CommandCode'] = self.command_code
        if self.ext_info is not None:
            result['ExtInfo'] = self.ext_info
        if self.outer_account_id is not None:
            result['OuterAccountId'] = self.outer_account_id
        if self.outer_account_type is not None:
            result['OuterAccountType'] = self.outer_account_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('CommandCode') is not None:
            self.command_code = m.get('CommandCode')
        if m.get('ExtInfo') is not None:
            self.ext_info = m.get('ExtInfo')
        if m.get('OuterAccountId') is not None:
            self.outer_account_id = m.get('OuterAccountId')
        if m.get('OuterAccountType') is not None:
            self.outer_account_type = m.get('OuterAccountType')
        return self


class MakeCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class MakeCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: MakeCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = MakeCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MakeDoubleCallRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        biz_data: str = None,
        instance_id: str = None,
        member_phone: str = None,
        outbound_call_number: str = None,
        servicer_phone: str = None,
    ):
        self.account_name = account_name
        self.biz_data = biz_data
        self.instance_id = instance_id
        self.member_phone = member_phone
        self.outbound_call_number = outbound_call_number
        self.servicer_phone = servicer_phone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.biz_data is not None:
            result['BizData'] = self.biz_data
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.member_phone is not None:
            result['MemberPhone'] = self.member_phone
        if self.outbound_call_number is not None:
            result['OutboundCallNumber'] = self.outbound_call_number
        if self.servicer_phone is not None:
            result['ServicerPhone'] = self.servicer_phone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('BizData') is not None:
            self.biz_data = m.get('BizData')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MemberPhone') is not None:
            self.member_phone = m.get('MemberPhone')
        if m.get('OutboundCallNumber') is not None:
            self.outbound_call_number = m.get('OutboundCallNumber')
        if m.get('ServicerPhone') is not None:
            self.servicer_phone = m.get('ServicerPhone')
        return self


class MakeDoubleCallResponseBodyData(TeaModel):
    def __init__(
        self,
        acid: str = None,
    ):
        self.acid = acid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        return self


class MakeDoubleCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: MakeDoubleCallResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = MakeDoubleCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class MakeDoubleCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: MakeDoubleCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = MakeDoubleCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryHotlineInQueueRequest(TeaModel):
    def __init__(
        self,
        outer_group_id: str = None,
        outer_group_type: str = None,
    ):
        self.outer_group_id = outer_group_id
        self.outer_group_type = outer_group_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outer_group_id is not None:
            result['OuterGroupId'] = self.outer_group_id
        if self.outer_group_type is not None:
            result['OuterGroupType'] = self.outer_group_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OuterGroupId') is not None:
            self.outer_group_id = m.get('OuterGroupId')
        if m.get('OuterGroupType') is not None:
            self.outer_group_type = m.get('OuterGroupType')
        return self


class QueryHotlineInQueueResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryHotlineInQueueResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryHotlineInQueueResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryHotlineInQueueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryHotlineNumberRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        department_id: int = None,
        group_ids: List[int] = None,
        hotline_number: str = None,
        instance_id: str = None,
        page_size: int = None,
    ):
        self.current_page = current_page
        self.department_id = department_id
        self.group_ids = group_ids
        self.hotline_number = hotline_number
        self.instance_id = instance_id
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryHotlineNumberShrinkRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        department_id: int = None,
        group_ids_shrink: str = None,
        hotline_number: str = None,
        instance_id: str = None,
        page_size: int = None,
    ):
        self.current_page = current_page
        self.department_id = department_id
        self.group_ids_shrink = group_ids_shrink
        self.hotline_number = hotline_number
        self.instance_id = instance_id
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeListGroupDOList(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        group_name: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeList(TeaModel):
    def __init__(
        self,
        department_id: int = None,
        department_name: str = None,
        group_dolist: List[QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeListGroupDOList] = None,
    ):
        self.department_id = department_id
        self.department_name = department_name
        self.group_dolist = group_dolist

    def validate(self):
        if self.group_dolist:
            for k in self.group_dolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.department_name is not None:
            result['DepartmentName'] = self.department_name
        result['GroupDOList'] = []
        if self.group_dolist is not None:
            for k in self.group_dolist:
                result['GroupDOList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('DepartmentName') is not None:
            self.department_name = m.get('DepartmentName')
        self.group_dolist = []
        if m.get('GroupDOList') is not None:
            for k in m.get('GroupDOList'):
                temp_model = QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeListGroupDOList()
                self.group_dolist.append(temp_model.from_map(k))
        return self


class QueryHotlineNumberResponseBodyDataHotlineNumList(TeaModel):
    def __init__(
        self,
        callout_all_department: bool = None,
        callout_range_list: List[QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeList] = None,
        description: str = None,
        evaluation_status: int = None,
        flow_id: int = None,
        flow_name: str = None,
        hotline_number: str = None,
        in_bound_enabled: bool = None,
        location: str = None,
        outbound_enabled: bool = None,
        sp: str = None,
    ):
        self.callout_all_department = callout_all_department
        self.callout_range_list = callout_range_list
        self.description = description
        self.evaluation_status = evaluation_status
        self.flow_id = flow_id
        self.flow_name = flow_name
        self.hotline_number = hotline_number
        self.in_bound_enabled = in_bound_enabled
        self.location = location
        self.outbound_enabled = outbound_enabled
        self.sp = sp

    def validate(self):
        if self.callout_range_list:
            for k in self.callout_range_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callout_all_department is not None:
            result['CalloutAllDepartment'] = self.callout_all_department
        result['CalloutRangeList'] = []
        if self.callout_range_list is not None:
            for k in self.callout_range_list:
                result['CalloutRangeList'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.evaluation_status is not None:
            result['EvaluationStatus'] = self.evaluation_status
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.in_bound_enabled is not None:
            result['InBoundEnabled'] = self.in_bound_enabled
        if self.location is not None:
            result['Location'] = self.location
        if self.outbound_enabled is not None:
            result['OutboundEnabled'] = self.outbound_enabled
        if self.sp is not None:
            result['Sp'] = self.sp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalloutAllDepartment') is not None:
            self.callout_all_department = m.get('CalloutAllDepartment')
        self.callout_range_list = []
        if m.get('CalloutRangeList') is not None:
            for k in m.get('CalloutRangeList'):
                temp_model = QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeList()
                self.callout_range_list.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EvaluationStatus') is not None:
            self.evaluation_status = m.get('EvaluationStatus')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InBoundEnabled') is not None:
            self.in_bound_enabled = m.get('InBoundEnabled')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('OutboundEnabled') is not None:
            self.outbound_enabled = m.get('OutboundEnabled')
        if m.get('Sp') is not None:
            self.sp = m.get('Sp')
        return self


class QueryHotlineNumberResponseBodyData(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        hotline_num_list: List[QueryHotlineNumberResponseBodyDataHotlineNumList] = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.current_page = current_page
        self.hotline_num_list = hotline_num_list
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.hotline_num_list:
            for k in self.hotline_num_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['HotlineNumList'] = []
        if self.hotline_num_list is not None:
            for k in self.hotline_num_list:
                result['HotlineNumList'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.hotline_num_list = []
        if m.get('HotlineNumList') is not None:
            for k in m.get('HotlineNumList'):
                temp_model = QueryHotlineNumberResponseBodyDataHotlineNumList()
                self.hotline_num_list.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryHotlineNumberResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryHotlineNumberResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryHotlineNumberResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryHotlineNumberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryHotlineNumberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryHotlineNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryOutboundTaskRequest(TeaModel):
    def __init__(
        self,
        ani: str = None,
        current_page: int = None,
        department_id: str = None,
        end_date: str = None,
        end_time: str = None,
        group_name: str = None,
        instance_id: str = None,
        page_size: int = None,
        skill_group: int = None,
        start_date: str = None,
        start_time: str = None,
        status: str = None,
        task_id: int = None,
        task_name: str = None,
        task_type: int = None,
    ):
        self.ani = ani
        self.current_page = current_page
        self.department_id = department_id
        self.end_date = end_date
        self.end_time = end_time
        self.group_name = group_name
        self.instance_id = instance_id
        self.page_size = page_size
        self.skill_group = skill_group
        self.start_date = start_date
        self.start_time = start_time
        self.status = status
        self.task_id = task_id
        self.task_name = task_name
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ani is not None:
            result['Ani'] = self.ani
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group is not None:
            result['SkillGroup'] = self.skill_group
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ani') is not None:
            self.ani = m.get('Ani')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroup') is not None:
            self.skill_group = m.get('SkillGroup')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class QueryOutboundTaskResponseBodyDataList(TeaModel):
    def __init__(
        self,
        bu_id: int = None,
        caller_num: str = None,
        creator: str = None,
        department_id: int = None,
        description: str = None,
        end_date: str = None,
        end_time: str = None,
        ext_attrs: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        group_name: str = None,
        id: int = None,
        model: int = None,
        modifier: str = None,
        name: str = None,
        retry_interval: int = None,
        retry_time: int = None,
        skill_group: int = None,
        start_date: str = None,
        start_time: str = None,
        status: int = None,
        type: int = None,
    ):
        self.bu_id = bu_id
        self.caller_num = caller_num
        self.creator = creator
        self.department_id = department_id
        self.description = description
        self.end_date = end_date
        self.end_time = end_time
        self.ext_attrs = ext_attrs
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.group_name = group_name
        self.id = id
        self.model = model
        self.modifier = modifier
        self.name = name
        self.retry_interval = retry_interval
        self.retry_time = retry_time
        self.skill_group = skill_group
        self.start_date = start_date
        self.start_time = start_time
        self.status = status
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bu_id is not None:
            result['BuId'] = self.bu_id
        if self.caller_num is not None:
            result['CallerNum'] = self.caller_num
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.description is not None:
            result['Description'] = self.description
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ext_attrs is not None:
            result['ExtAttrs'] = self.ext_attrs
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.id is not None:
            result['Id'] = self.id
        if self.model is not None:
            result['Model'] = self.model
        if self.modifier is not None:
            result['Modifier'] = self.modifier
        if self.name is not None:
            result['Name'] = self.name
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_time is not None:
            result['RetryTime'] = self.retry_time
        if self.skill_group is not None:
            result['SkillGroup'] = self.skill_group
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BuId') is not None:
            self.bu_id = m.get('BuId')
        if m.get('CallerNum') is not None:
            self.caller_num = m.get('CallerNum')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExtAttrs') is not None:
            self.ext_attrs = m.get('ExtAttrs')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Modifier') is not None:
            self.modifier = m.get('Modifier')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryTime') is not None:
            self.retry_time = m.get('RetryTime')
        if m.get('SkillGroup') is not None:
            self.skill_group = m.get('SkillGroup')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryOutboundTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        list: List[QueryOutboundTaskResponseBodyDataList] = None,
        page_size: str = None,
        total_results: str = None,
    ):
        self.current_page = current_page
        self.list = list
        self.page_size = page_size
        self.total_results = total_results

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = QueryOutboundTaskResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class QueryOutboundTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryOutboundTaskResponseBodyData = None,
        http_status_code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryOutboundTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryOutboundTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryOutboundTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QuerySkillGroupsRequest(TeaModel):
    def __init__(
        self,
        channel_type: int = None,
        client_token: str = None,
        department_id: int = None,
        instance_id: str = None,
        page_no: int = None,
        page_size: int = None,
    ):
        self.channel_type = channel_type
        self.client_token = client_token
        self.department_id = department_id
        self.instance_id = instance_id
        self.page_no = page_no
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QuerySkillGroupsResponseBodyData(TeaModel):
    def __init__(
        self,
        channel_type: int = None,
        description: str = None,
        display_name: str = None,
        skill_group_id: int = None,
        skill_group_name: str = None,
    ):
        self.channel_type = channel_type
        self.description = description
        self.display_name = display_name
        self.skill_group_id = skill_group_id
        self.skill_group_name = skill_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        return self


class QuerySkillGroupsResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        data: List[QuerySkillGroupsResponseBodyData] = None,
        one_page_size: int = None,
        request_id: str = None,
        total_page: int = None,
        total_results: int = None,
    ):
        self.current_page = current_page
        self.data = data
        self.one_page_size = one_page_size
        self.request_id = request_id
        self.total_page = total_page
        self.total_results = total_results

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.one_page_size is not None:
            result['OnePageSize'] = self.one_page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QuerySkillGroupsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('OnePageSize') is not None:
            self.one_page_size = m.get('OnePageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class QuerySkillGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QuerySkillGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QuerySkillGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryTaskDetailRequest(TeaModel):
    def __init__(
        self,
        ani: str = None,
        current_page: int = None,
        department_id_list: str = None,
        dnis: str = None,
        end_reason_list: str = None,
        instance_id: str = None,
        outbound_task_id: str = None,
        page_size: int = None,
        priority_list: str = None,
        servicer_id: str = None,
        servicer_name: str = None,
        sid: str = None,
        skill_group: str = None,
        status_list: str = None,
        task_id: int = None,
    ):
        self.ani = ani
        self.current_page = current_page
        self.department_id_list = department_id_list
        self.dnis = dnis
        self.end_reason_list = end_reason_list
        self.instance_id = instance_id
        self.outbound_task_id = outbound_task_id
        self.page_size = page_size
        self.priority_list = priority_list
        self.servicer_id = servicer_id
        self.servicer_name = servicer_name
        self.sid = sid
        self.skill_group = skill_group
        self.status_list = status_list
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ani is not None:
            result['Ani'] = self.ani
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department_id_list is not None:
            result['DepartmentIdList'] = self.department_id_list
        if self.dnis is not None:
            result['Dnis'] = self.dnis
        if self.end_reason_list is not None:
            result['EndReasonList'] = self.end_reason_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_task_id is not None:
            result['OutboundTaskId'] = self.outbound_task_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.priority_list is not None:
            result['PriorityList'] = self.priority_list
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.sid is not None:
            result['Sid'] = self.sid
        if self.skill_group is not None:
            result['SkillGroup'] = self.skill_group
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ani') is not None:
            self.ani = m.get('Ani')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepartmentIdList') is not None:
            self.department_id_list = m.get('DepartmentIdList')
        if m.get('Dnis') is not None:
            self.dnis = m.get('Dnis')
        if m.get('EndReasonList') is not None:
            self.end_reason_list = m.get('EndReasonList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundTaskId') is not None:
            self.outbound_task_id = m.get('OutboundTaskId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PriorityList') is not None:
            self.priority_list = m.get('PriorityList')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('Sid') is not None:
            self.sid = m.get('Sid')
        if m.get('SkillGroup') is not None:
            self.skill_group = m.get('SkillGroup')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class QueryTaskDetailResponseBodyDataList(TeaModel):
    def __init__(
        self,
        ani: str = None,
        bu_id: int = None,
        department_id: int = None,
        dnis: str = None,
        end_reason: int = None,
        ext_attrs: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        id: int = None,
        member_id: int = None,
        member_name: str = None,
        outbound_num: int = None,
        outbound_task_id: int = None,
        priority: int = None,
        retry_time: str = None,
        servicer_id: int = None,
        servicer_name: str = None,
        skill_group: int = None,
        status: int = None,
    ):
        self.ani = ani
        self.bu_id = bu_id
        self.department_id = department_id
        self.dnis = dnis
        self.end_reason = end_reason
        self.ext_attrs = ext_attrs
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.member_id = member_id
        self.member_name = member_name
        self.outbound_num = outbound_num
        self.outbound_task_id = outbound_task_id
        self.priority = priority
        self.retry_time = retry_time
        self.servicer_id = servicer_id
        self.servicer_name = servicer_name
        self.skill_group = skill_group
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ani is not None:
            result['Ani'] = self.ani
        if self.bu_id is not None:
            result['BuId'] = self.bu_id
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.dnis is not None:
            result['Dnis'] = self.dnis
        if self.end_reason is not None:
            result['EndReason'] = self.end_reason
        if self.ext_attrs is not None:
            result['ExtAttrs'] = self.ext_attrs
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.outbound_num is not None:
            result['OutboundNum'] = self.outbound_num
        if self.outbound_task_id is not None:
            result['OutboundTaskId'] = self.outbound_task_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.retry_time is not None:
            result['RetryTime'] = self.retry_time
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.skill_group is not None:
            result['SkillGroup'] = self.skill_group
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ani') is not None:
            self.ani = m.get('Ani')
        if m.get('BuId') is not None:
            self.bu_id = m.get('BuId')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Dnis') is not None:
            self.dnis = m.get('Dnis')
        if m.get('EndReason') is not None:
            self.end_reason = m.get('EndReason')
        if m.get('ExtAttrs') is not None:
            self.ext_attrs = m.get('ExtAttrs')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('OutboundNum') is not None:
            self.outbound_num = m.get('OutboundNum')
        if m.get('OutboundTaskId') is not None:
            self.outbound_task_id = m.get('OutboundTaskId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RetryTime') is not None:
            self.retry_time = m.get('RetryTime')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('SkillGroup') is not None:
            self.skill_group = m.get('SkillGroup')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class QueryTaskDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        list: List[QueryTaskDetailResponseBodyDataList] = None,
        page_size: str = None,
        total_results: str = None,
    ):
        self.current_page = current_page
        self.list = list
        self.page_size = page_size
        self.total_results = total_results

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = QueryTaskDetailResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class QueryTaskDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryTaskDetailResponseBodyData = None,
        http_status_code: str = None,
        message: str = None,
        request_id: str = None,
        success: str = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryTaskDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryTaskDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryTaskDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryTaskDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryTicketsRequest(TeaModel):
    def __init__(
        self,
        case_id: int = None,
        case_status: int = None,
        case_type: int = None,
        channel_id: str = None,
        channel_type: int = None,
        current_page: int = None,
        deal_id: int = None,
        extra: Dict[str, Any] = None,
        instance_id: str = None,
        page_size: int = None,
        sr_type: int = None,
        task_status: int = None,
        touch_id: int = None,
    ):
        self.case_id = case_id
        self.case_status = case_status
        self.case_type = case_type
        self.channel_id = channel_id
        self.channel_type = channel_type
        self.current_page = current_page
        self.deal_id = deal_id
        self.extra = extra
        self.instance_id = instance_id
        self.page_size = page_size
        self.sr_type = sr_type
        self.task_status = task_status
        self.touch_id = touch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.case_status is not None:
            result['CaseStatus'] = self.case_status
        if self.case_type is not None:
            result['CaseType'] = self.case_type
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.deal_id is not None:
            result['DealId'] = self.deal_id
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sr_type is not None:
            result['SrType'] = self.sr_type
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.touch_id is not None:
            result['TouchId'] = self.touch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('CaseStatus') is not None:
            self.case_status = m.get('CaseStatus')
        if m.get('CaseType') is not None:
            self.case_type = m.get('CaseType')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DealId') is not None:
            self.deal_id = m.get('DealId')
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SrType') is not None:
            self.sr_type = m.get('SrType')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TouchId') is not None:
            self.touch_id = m.get('TouchId')
        return self


class QueryTicketsShrinkRequest(TeaModel):
    def __init__(
        self,
        case_id: int = None,
        case_status: int = None,
        case_type: int = None,
        channel_id: str = None,
        channel_type: int = None,
        current_page: int = None,
        deal_id: int = None,
        extra_shrink: str = None,
        instance_id: str = None,
        page_size: int = None,
        sr_type: int = None,
        task_status: int = None,
        touch_id: int = None,
    ):
        self.case_id = case_id
        self.case_status = case_status
        self.case_type = case_type
        self.channel_id = channel_id
        self.channel_type = channel_type
        self.current_page = current_page
        self.deal_id = deal_id
        self.extra_shrink = extra_shrink
        self.instance_id = instance_id
        self.page_size = page_size
        self.sr_type = sr_type
        self.task_status = task_status
        self.touch_id = touch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.case_status is not None:
            result['CaseStatus'] = self.case_status
        if self.case_type is not None:
            result['CaseType'] = self.case_type
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.deal_id is not None:
            result['DealId'] = self.deal_id
        if self.extra_shrink is not None:
            result['Extra'] = self.extra_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sr_type is not None:
            result['SrType'] = self.sr_type
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.touch_id is not None:
            result['TouchId'] = self.touch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('CaseStatus') is not None:
            self.case_status = m.get('CaseStatus')
        if m.get('CaseType') is not None:
            self.case_type = m.get('CaseType')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DealId') is not None:
            self.deal_id = m.get('DealId')
        if m.get('Extra') is not None:
            self.extra_shrink = m.get('Extra')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SrType') is not None:
            self.sr_type = m.get('SrType')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TouchId') is not None:
            self.touch_id = m.get('TouchId')
        return self


class QueryTicketsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryTicketsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryTicketsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryTicketsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryTouchListRequest(TeaModel):
    def __init__(
        self,
        channel_id: List[str] = None,
        channel_type: List[int] = None,
        close_time_end: int = None,
        close_time_start: int = None,
        current_page: int = None,
        evaluation_level: List[int] = None,
        evaluation_score: List[int] = None,
        evaluation_status: List[int] = None,
        first_time_end: int = None,
        first_time_start: int = None,
        instance_id: str = None,
        member_id: List[int] = None,
        member_name: List[str] = None,
        page_size: int = None,
        queue_id: List[int] = None,
        servicer_id: List[int] = None,
        servicer_name: List[str] = None,
        touch_id: List[int] = None,
        touch_type: List[int] = None,
    ):
        self.channel_id = channel_id
        self.channel_type = channel_type
        self.close_time_end = close_time_end
        self.close_time_start = close_time_start
        self.current_page = current_page
        self.evaluation_level = evaluation_level
        self.evaluation_score = evaluation_score
        self.evaluation_status = evaluation_status
        self.first_time_end = first_time_end
        self.first_time_start = first_time_start
        self.instance_id = instance_id
        self.member_id = member_id
        self.member_name = member_name
        self.page_size = page_size
        self.queue_id = queue_id
        self.servicer_id = servicer_id
        self.servicer_name = servicer_name
        self.touch_id = touch_id
        self.touch_type = touch_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.close_time_end is not None:
            result['CloseTimeEnd'] = self.close_time_end
        if self.close_time_start is not None:
            result['CloseTimeStart'] = self.close_time_start
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.evaluation_score is not None:
            result['EvaluationScore'] = self.evaluation_score
        if self.evaluation_status is not None:
            result['EvaluationStatus'] = self.evaluation_status
        if self.first_time_end is not None:
            result['FirstTimeEnd'] = self.first_time_end
        if self.first_time_start is not None:
            result['FirstTimeStart'] = self.first_time_start
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.touch_id is not None:
            result['TouchId'] = self.touch_id
        if self.touch_type is not None:
            result['TouchType'] = self.touch_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('CloseTimeEnd') is not None:
            self.close_time_end = m.get('CloseTimeEnd')
        if m.get('CloseTimeStart') is not None:
            self.close_time_start = m.get('CloseTimeStart')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('EvaluationScore') is not None:
            self.evaluation_score = m.get('EvaluationScore')
        if m.get('EvaluationStatus') is not None:
            self.evaluation_status = m.get('EvaluationStatus')
        if m.get('FirstTimeEnd') is not None:
            self.first_time_end = m.get('FirstTimeEnd')
        if m.get('FirstTimeStart') is not None:
            self.first_time_start = m.get('FirstTimeStart')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('TouchId') is not None:
            self.touch_id = m.get('TouchId')
        if m.get('TouchType') is not None:
            self.touch_type = m.get('TouchType')
        return self


class QueryTouchListResponseBodyResultDataDataExtAttrs(TeaModel):
    def __init__(
        self,
        ani: str = None,
        dnis: str = None,
        evaluation_level: int = None,
        evaluation_score: int = None,
        evaluation_solution: int = None,
        evaluation_status: int = None,
        online_join_resp_interval: int = None,
        online_session_source: int = None,
        out_call_route_number: str = None,
    ):
        self.ani = ani
        self.dnis = dnis
        self.evaluation_level = evaluation_level
        self.evaluation_score = evaluation_score
        self.evaluation_solution = evaluation_solution
        self.evaluation_status = evaluation_status
        self.online_join_resp_interval = online_join_resp_interval
        self.online_session_source = online_session_source
        self.out_call_route_number = out_call_route_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ani is not None:
            result['Ani'] = self.ani
        if self.dnis is not None:
            result['Dnis'] = self.dnis
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.evaluation_score is not None:
            result['EvaluationScore'] = self.evaluation_score
        if self.evaluation_solution is not None:
            result['EvaluationSolution'] = self.evaluation_solution
        if self.evaluation_status is not None:
            result['EvaluationStatus'] = self.evaluation_status
        if self.online_join_resp_interval is not None:
            result['OnlineJoinRespInterval'] = self.online_join_resp_interval
        if self.online_session_source is not None:
            result['OnlineSessionSource'] = self.online_session_source
        if self.out_call_route_number is not None:
            result['OutCallRouteNumber'] = self.out_call_route_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ani') is not None:
            self.ani = m.get('Ani')
        if m.get('Dnis') is not None:
            self.dnis = m.get('Dnis')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('EvaluationScore') is not None:
            self.evaluation_score = m.get('EvaluationScore')
        if m.get('EvaluationSolution') is not None:
            self.evaluation_solution = m.get('EvaluationSolution')
        if m.get('EvaluationStatus') is not None:
            self.evaluation_status = m.get('EvaluationStatus')
        if m.get('OnlineJoinRespInterval') is not None:
            self.online_join_resp_interval = m.get('OnlineJoinRespInterval')
        if m.get('OnlineSessionSource') is not None:
            self.online_session_source = m.get('OnlineSessionSource')
        if m.get('OutCallRouteNumber') is not None:
            self.out_call_route_number = m.get('OutCallRouteNumber')
        return self


class QueryTouchListResponseBodyResultDataData(TeaModel):
    def __init__(
        self,
        bu_id: int = None,
        channel_id: str = None,
        channel_type: int = None,
        close_time: int = None,
        common_queue_name: str = None,
        dep_id: int = None,
        ext_attrs: QueryTouchListResponseBodyResultDataDataExtAttrs = None,
        ext_attrs_string: Dict[str, Any] = None,
        feedback: str = None,
        first_time: int = None,
        from_id: int = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        member_id: int = None,
        member_name: str = None,
        parent_touch_id: int = None,
        queue_id: int = None,
        servicer_id: int = None,
        servicer_name: str = None,
        status: int = None,
        switch_user: str = None,
        to_id: int = None,
        touch_content: str = None,
        touch_end_reason: int = None,
        touch_id: str = None,
        touch_time: str = None,
        touch_type: int = None,
        user_touch_id: int = None,
    ):
        self.bu_id = bu_id
        self.channel_id = channel_id
        self.channel_type = channel_type
        self.close_time = close_time
        self.common_queue_name = common_queue_name
        self.dep_id = dep_id
        self.ext_attrs = ext_attrs
        self.ext_attrs_string = ext_attrs_string
        self.feedback = feedback
        self.first_time = first_time
        self.from_id = from_id
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.member_id = member_id
        self.member_name = member_name
        self.parent_touch_id = parent_touch_id
        self.queue_id = queue_id
        self.servicer_id = servicer_id
        self.servicer_name = servicer_name
        self.status = status
        self.switch_user = switch_user
        self.to_id = to_id
        self.touch_content = touch_content
        self.touch_end_reason = touch_end_reason
        self.touch_id = touch_id
        self.touch_time = touch_time
        self.touch_type = touch_type
        self.user_touch_id = user_touch_id

    def validate(self):
        if self.ext_attrs:
            self.ext_attrs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bu_id is not None:
            result['BuId'] = self.bu_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.close_time is not None:
            result['CloseTime'] = self.close_time
        if self.common_queue_name is not None:
            result['CommonQueueName'] = self.common_queue_name
        if self.dep_id is not None:
            result['DepId'] = self.dep_id
        if self.ext_attrs is not None:
            result['ExtAttrs'] = self.ext_attrs.to_map()
        if self.ext_attrs_string is not None:
            result['ExtAttrsString'] = self.ext_attrs_string
        if self.feedback is not None:
            result['Feedback'] = self.feedback
        if self.first_time is not None:
            result['FirstTime'] = self.first_time
        if self.from_id is not None:
            result['FromId'] = self.from_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.parent_touch_id is not None:
            result['ParentTouchId'] = self.parent_touch_id
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.status is not None:
            result['Status'] = self.status
        if self.switch_user is not None:
            result['SwitchUser'] = self.switch_user
        if self.to_id is not None:
            result['ToId'] = self.to_id
        if self.touch_content is not None:
            result['TouchContent'] = self.touch_content
        if self.touch_end_reason is not None:
            result['TouchEndReason'] = self.touch_end_reason
        if self.touch_id is not None:
            result['TouchId'] = self.touch_id
        if self.touch_time is not None:
            result['TouchTime'] = self.touch_time
        if self.touch_type is not None:
            result['TouchType'] = self.touch_type
        if self.user_touch_id is not None:
            result['UserTouchId'] = self.user_touch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BuId') is not None:
            self.bu_id = m.get('BuId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('CloseTime') is not None:
            self.close_time = m.get('CloseTime')
        if m.get('CommonQueueName') is not None:
            self.common_queue_name = m.get('CommonQueueName')
        if m.get('DepId') is not None:
            self.dep_id = m.get('DepId')
        if m.get('ExtAttrs') is not None:
            temp_model = QueryTouchListResponseBodyResultDataDataExtAttrs()
            self.ext_attrs = temp_model.from_map(m['ExtAttrs'])
        if m.get('ExtAttrsString') is not None:
            self.ext_attrs_string = m.get('ExtAttrsString')
        if m.get('Feedback') is not None:
            self.feedback = m.get('Feedback')
        if m.get('FirstTime') is not None:
            self.first_time = m.get('FirstTime')
        if m.get('FromId') is not None:
            self.from_id = m.get('FromId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('ParentTouchId') is not None:
            self.parent_touch_id = m.get('ParentTouchId')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SwitchUser') is not None:
            self.switch_user = m.get('SwitchUser')
        if m.get('ToId') is not None:
            self.to_id = m.get('ToId')
        if m.get('TouchContent') is not None:
            self.touch_content = m.get('TouchContent')
        if m.get('TouchEndReason') is not None:
            self.touch_end_reason = m.get('TouchEndReason')
        if m.get('TouchId') is not None:
            self.touch_id = m.get('TouchId')
        if m.get('TouchTime') is not None:
            self.touch_time = m.get('TouchTime')
        if m.get('TouchType') is not None:
            self.touch_type = m.get('TouchType')
        if m.get('UserTouchId') is not None:
            self.user_touch_id = m.get('UserTouchId')
        return self


class QueryTouchListResponseBodyResultData(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        data: List[QueryTouchListResponseBodyResultDataData] = None,
        empty: bool = None,
        next_page: int = None,
        one_page_size: int = None,
        previous_page: int = None,
        total_page: int = None,
        total_results: int = None,
    ):
        self.current_page = current_page
        self.data = data
        self.empty = empty
        self.next_page = next_page
        self.one_page_size = one_page_size
        self.previous_page = previous_page
        self.total_page = total_page
        self.total_results = total_results

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.empty is not None:
            result['Empty'] = self.empty
        if self.next_page is not None:
            result['NextPage'] = self.next_page
        if self.one_page_size is not None:
            result['OnePageSize'] = self.one_page_size
        if self.previous_page is not None:
            result['PreviousPage'] = self.previous_page
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryTouchListResponseBodyResultDataData()
                self.data.append(temp_model.from_map(k))
        if m.get('Empty') is not None:
            self.empty = m.get('Empty')
        if m.get('NextPage') is not None:
            self.next_page = m.get('NextPage')
        if m.get('OnePageSize') is not None:
            self.one_page_size = m.get('OnePageSize')
        if m.get('PreviousPage') is not None:
            self.previous_page = m.get('PreviousPage')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class QueryTouchListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        result_data: QueryTouchListResponseBodyResultData = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.result_data = result_data
        self.success = success

    def validate(self):
        if self.result_data:
            self.result_data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result_data is not None:
            result['ResultData'] = self.result_data.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResultData') is not None:
            temp_model = QueryTouchListResponseBodyResultData()
            self.result_data = temp_model.from_map(m['ResultData'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryTouchListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryTouchListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryTouchListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveAgentFromSkillGroupRequest(TeaModel):
    def __init__(
        self,
        agent_ids: List[int] = None,
        instance_id: str = None,
        skill_group_id: int = None,
    ):
        self.agent_ids = agent_ids
        self.instance_id = instance_id
        self.skill_group_id = skill_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class RemoveAgentFromSkillGroupShrinkRequest(TeaModel):
    def __init__(
        self,
        agent_ids_shrink: str = None,
        instance_id: str = None,
        skill_group_id: int = None,
    ):
        self.agent_ids_shrink = agent_ids_shrink
        self.instance_id = instance_id
        self.skill_group_id = skill_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class RemoveAgentFromSkillGroupResponseBodyData(TeaModel):
    def __init__(
        self,
        success_count: int = None,
    ):
        self.success_count = success_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class RemoveAgentFromSkillGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: RemoveAgentFromSkillGroupResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = RemoveAgentFromSkillGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveAgentFromSkillGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RemoveAgentFromSkillGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RemoveAgentFromSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveSkillGroupRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        instance_id: str = None,
        skill_group_id: str = None,
    ):
        self.client_token = client_token
        self.instance_id = instance_id
        self.skill_group_id = skill_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class RemoveSkillGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveSkillGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RemoveSkillGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RemoveSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ResetHotlineNumberRequestOutboundRangeList(TeaModel):
    def __init__(
        self,
        department_id: int = None,
        group_id_list: List[int] = None,
    ):
        self.department_id = department_id
        self.group_id_list = group_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        return self


class ResetHotlineNumberRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        enable_inbound: bool = None,
        enable_inbound_evaluation: bool = None,
        enable_outbound: bool = None,
        enable_outbound_evaluation: bool = None,
        evaluation_level: int = None,
        hotline_number: str = None,
        inbound_flow_id: int = None,
        instance_id: str = None,
        outbound_all_depart: bool = None,
        outbound_range_list: List[ResetHotlineNumberRequestOutboundRangeList] = None,
    ):
        self.description = description
        self.enable_inbound = enable_inbound
        self.enable_inbound_evaluation = enable_inbound_evaluation
        self.enable_outbound = enable_outbound
        self.enable_outbound_evaluation = enable_outbound_evaluation
        self.evaluation_level = evaluation_level
        self.hotline_number = hotline_number
        self.inbound_flow_id = inbound_flow_id
        self.instance_id = instance_id
        self.outbound_all_depart = outbound_all_depart
        self.outbound_range_list = outbound_range_list

    def validate(self):
        if self.outbound_range_list:
            for k in self.outbound_range_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_inbound is not None:
            result['EnableInbound'] = self.enable_inbound
        if self.enable_inbound_evaluation is not None:
            result['EnableInboundEvaluation'] = self.enable_inbound_evaluation
        if self.enable_outbound is not None:
            result['EnableOutbound'] = self.enable_outbound
        if self.enable_outbound_evaluation is not None:
            result['EnableOutboundEvaluation'] = self.enable_outbound_evaluation
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.inbound_flow_id is not None:
            result['InboundFlowId'] = self.inbound_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_all_depart is not None:
            result['OutboundAllDepart'] = self.outbound_all_depart
        result['OutboundRangeList'] = []
        if self.outbound_range_list is not None:
            for k in self.outbound_range_list:
                result['OutboundRangeList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableInbound') is not None:
            self.enable_inbound = m.get('EnableInbound')
        if m.get('EnableInboundEvaluation') is not None:
            self.enable_inbound_evaluation = m.get('EnableInboundEvaluation')
        if m.get('EnableOutbound') is not None:
            self.enable_outbound = m.get('EnableOutbound')
        if m.get('EnableOutboundEvaluation') is not None:
            self.enable_outbound_evaluation = m.get('EnableOutboundEvaluation')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InboundFlowId') is not None:
            self.inbound_flow_id = m.get('InboundFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundAllDepart') is not None:
            self.outbound_all_depart = m.get('OutboundAllDepart')
        self.outbound_range_list = []
        if m.get('OutboundRangeList') is not None:
            for k in m.get('OutboundRangeList'):
                temp_model = ResetHotlineNumberRequestOutboundRangeList()
                self.outbound_range_list.append(temp_model.from_map(k))
        return self


class ResetHotlineNumberShrinkRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        enable_inbound: bool = None,
        enable_inbound_evaluation: bool = None,
        enable_outbound: bool = None,
        enable_outbound_evaluation: bool = None,
        evaluation_level: int = None,
        hotline_number: str = None,
        inbound_flow_id: int = None,
        instance_id: str = None,
        outbound_all_depart: bool = None,
        outbound_range_list_shrink: str = None,
    ):
        self.description = description
        self.enable_inbound = enable_inbound
        self.enable_inbound_evaluation = enable_inbound_evaluation
        self.enable_outbound = enable_outbound
        self.enable_outbound_evaluation = enable_outbound_evaluation
        self.evaluation_level = evaluation_level
        self.hotline_number = hotline_number
        self.inbound_flow_id = inbound_flow_id
        self.instance_id = instance_id
        self.outbound_all_depart = outbound_all_depart
        self.outbound_range_list_shrink = outbound_range_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_inbound is not None:
            result['EnableInbound'] = self.enable_inbound
        if self.enable_inbound_evaluation is not None:
            result['EnableInboundEvaluation'] = self.enable_inbound_evaluation
        if self.enable_outbound is not None:
            result['EnableOutbound'] = self.enable_outbound
        if self.enable_outbound_evaluation is not None:
            result['EnableOutboundEvaluation'] = self.enable_outbound_evaluation
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.inbound_flow_id is not None:
            result['InboundFlowId'] = self.inbound_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_all_depart is not None:
            result['OutboundAllDepart'] = self.outbound_all_depart
        if self.outbound_range_list_shrink is not None:
            result['OutboundRangeList'] = self.outbound_range_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableInbound') is not None:
            self.enable_inbound = m.get('EnableInbound')
        if m.get('EnableInboundEvaluation') is not None:
            self.enable_inbound_evaluation = m.get('EnableInboundEvaluation')
        if m.get('EnableOutbound') is not None:
            self.enable_outbound = m.get('EnableOutbound')
        if m.get('EnableOutboundEvaluation') is not None:
            self.enable_outbound_evaluation = m.get('EnableOutboundEvaluation')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InboundFlowId') is not None:
            self.inbound_flow_id = m.get('InboundFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundAllDepart') is not None:
            self.outbound_all_depart = m.get('OutboundAllDepart')
        if m.get('OutboundRangeList') is not None:
            self.outbound_range_list_shrink = m.get('OutboundRangeList')
        return self


class ResetHotlineNumberResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ResetHotlineNumberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ResetHotlineNumberResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ResetHotlineNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RestartOutboundTaskRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        outbound_task_id: int = None,
    ):
        self.instance_id = instance_id
        self.outbound_task_id = outbound_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_task_id is not None:
            result['OutboundTaskId'] = self.outbound_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundTaskId') is not None:
            self.outbound_task_id = m.get('OutboundTaskId')
        return self


class RestartOutboundTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RestartOutboundTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RestartOutboundTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RestartOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RobotCallRequest(TeaModel):
    def __init__(
        self,
        called_number: str = None,
        called_show_number: str = None,
        early_media_asr: bool = None,
        out_id: str = None,
        owner_id: int = None,
        params: str = None,
        record_flag: bool = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        robot_id: int = None,
    ):
        self.called_number = called_number
        self.called_show_number = called_show_number
        self.early_media_asr = early_media_asr
        self.out_id = out_id
        self.owner_id = owner_id
        self.params = params
        self.record_flag = record_flag
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.robot_id = robot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.called_show_number is not None:
            result['CalledShowNumber'] = self.called_show_number
        if self.early_media_asr is not None:
            result['EarlyMediaAsr'] = self.early_media_asr
        if self.out_id is not None:
            result['OutId'] = self.out_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.params is not None:
            result['Params'] = self.params
        if self.record_flag is not None:
            result['RecordFlag'] = self.record_flag
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CalledShowNumber') is not None:
            self.called_show_number = m.get('CalledShowNumber')
        if m.get('EarlyMediaAsr') is not None:
            self.early_media_asr = m.get('EarlyMediaAsr')
        if m.get('OutId') is not None:
            self.out_id = m.get('OutId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RecordFlag') is not None:
            self.record_flag = m.get('RecordFlag')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        return self


class RobotCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RobotCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RobotCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RobotCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SendCcoSmartCallRequest(TeaModel):
    def __init__(
        self,
        action_code_break: bool = None,
        action_code_time_break: int = None,
        asr_als_am_id: str = None,
        asr_base_id: str = None,
        asr_model_id: str = None,
        asr_vocabulary_id: str = None,
        background_file_code: str = None,
        background_speed: int = None,
        background_volume: int = None,
        called_number: str = None,
        called_show_number: str = None,
        dynamic_id: str = None,
        early_media_asr: bool = None,
        enable_itn: bool = None,
        mute_time: int = None,
        out_id: str = None,
        owner_id: int = None,
        pause_time: int = None,
        play_times: int = None,
        prod_code: str = None,
        record_flag: bool = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        session_timeout: int = None,
        speed: int = None,
        tts_conf: bool = None,
        tts_speed: int = None,
        tts_style: str = None,
        tts_volume: int = None,
        voice_code: str = None,
        voice_code_param: str = None,
        volume: int = None,
    ):
        self.action_code_break = action_code_break
        self.action_code_time_break = action_code_time_break
        self.asr_als_am_id = asr_als_am_id
        self.asr_base_id = asr_base_id
        self.asr_model_id = asr_model_id
        self.asr_vocabulary_id = asr_vocabulary_id
        self.background_file_code = background_file_code
        self.background_speed = background_speed
        self.background_volume = background_volume
        self.called_number = called_number
        self.called_show_number = called_show_number
        self.dynamic_id = dynamic_id
        self.early_media_asr = early_media_asr
        self.enable_itn = enable_itn
        self.mute_time = mute_time
        self.out_id = out_id
        self.owner_id = owner_id
        self.pause_time = pause_time
        self.play_times = play_times
        self.prod_code = prod_code
        self.record_flag = record_flag
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.session_timeout = session_timeout
        self.speed = speed
        self.tts_conf = tts_conf
        self.tts_speed = tts_speed
        self.tts_style = tts_style
        self.tts_volume = tts_volume
        self.voice_code = voice_code
        self.voice_code_param = voice_code_param
        self.volume = volume

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_code_break is not None:
            result['ActionCodeBreak'] = self.action_code_break
        if self.action_code_time_break is not None:
            result['ActionCodeTimeBreak'] = self.action_code_time_break
        if self.asr_als_am_id is not None:
            result['AsrAlsAmId'] = self.asr_als_am_id
        if self.asr_base_id is not None:
            result['AsrBaseId'] = self.asr_base_id
        if self.asr_model_id is not None:
            result['AsrModelId'] = self.asr_model_id
        if self.asr_vocabulary_id is not None:
            result['AsrVocabularyId'] = self.asr_vocabulary_id
        if self.background_file_code is not None:
            result['BackgroundFileCode'] = self.background_file_code
        if self.background_speed is not None:
            result['BackgroundSpeed'] = self.background_speed
        if self.background_volume is not None:
            result['BackgroundVolume'] = self.background_volume
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.called_show_number is not None:
            result['CalledShowNumber'] = self.called_show_number
        if self.dynamic_id is not None:
            result['DynamicId'] = self.dynamic_id
        if self.early_media_asr is not None:
            result['EarlyMediaAsr'] = self.early_media_asr
        if self.enable_itn is not None:
            result['EnableITN'] = self.enable_itn
        if self.mute_time is not None:
            result['MuteTime'] = self.mute_time
        if self.out_id is not None:
            result['OutId'] = self.out_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pause_time is not None:
            result['PauseTime'] = self.pause_time
        if self.play_times is not None:
            result['PlayTimes'] = self.play_times
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.record_flag is not None:
            result['RecordFlag'] = self.record_flag
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.session_timeout is not None:
            result['SessionTimeout'] = self.session_timeout
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.tts_conf is not None:
            result['TtsConf'] = self.tts_conf
        if self.tts_speed is not None:
            result['TtsSpeed'] = self.tts_speed
        if self.tts_style is not None:
            result['TtsStyle'] = self.tts_style
        if self.tts_volume is not None:
            result['TtsVolume'] = self.tts_volume
        if self.voice_code is not None:
            result['VoiceCode'] = self.voice_code
        if self.voice_code_param is not None:
            result['VoiceCodeParam'] = self.voice_code_param
        if self.volume is not None:
            result['Volume'] = self.volume
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionCodeBreak') is not None:
            self.action_code_break = m.get('ActionCodeBreak')
        if m.get('ActionCodeTimeBreak') is not None:
            self.action_code_time_break = m.get('ActionCodeTimeBreak')
        if m.get('AsrAlsAmId') is not None:
            self.asr_als_am_id = m.get('AsrAlsAmId')
        if m.get('AsrBaseId') is not None:
            self.asr_base_id = m.get('AsrBaseId')
        if m.get('AsrModelId') is not None:
            self.asr_model_id = m.get('AsrModelId')
        if m.get('AsrVocabularyId') is not None:
            self.asr_vocabulary_id = m.get('AsrVocabularyId')
        if m.get('BackgroundFileCode') is not None:
            self.background_file_code = m.get('BackgroundFileCode')
        if m.get('BackgroundSpeed') is not None:
            self.background_speed = m.get('BackgroundSpeed')
        if m.get('BackgroundVolume') is not None:
            self.background_volume = m.get('BackgroundVolume')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CalledShowNumber') is not None:
            self.called_show_number = m.get('CalledShowNumber')
        if m.get('DynamicId') is not None:
            self.dynamic_id = m.get('DynamicId')
        if m.get('EarlyMediaAsr') is not None:
            self.early_media_asr = m.get('EarlyMediaAsr')
        if m.get('EnableITN') is not None:
            self.enable_itn = m.get('EnableITN')
        if m.get('MuteTime') is not None:
            self.mute_time = m.get('MuteTime')
        if m.get('OutId') is not None:
            self.out_id = m.get('OutId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PauseTime') is not None:
            self.pause_time = m.get('PauseTime')
        if m.get('PlayTimes') is not None:
            self.play_times = m.get('PlayTimes')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('RecordFlag') is not None:
            self.record_flag = m.get('RecordFlag')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SessionTimeout') is not None:
            self.session_timeout = m.get('SessionTimeout')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('TtsConf') is not None:
            self.tts_conf = m.get('TtsConf')
        if m.get('TtsSpeed') is not None:
            self.tts_speed = m.get('TtsSpeed')
        if m.get('TtsStyle') is not None:
            self.tts_style = m.get('TtsStyle')
        if m.get('TtsVolume') is not None:
            self.tts_volume = m.get('TtsVolume')
        if m.get('VoiceCode') is not None:
            self.voice_code = m.get('VoiceCode')
        if m.get('VoiceCodeParam') is not None:
            self.voice_code_param = m.get('VoiceCodeParam')
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        return self


class SendCcoSmartCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SendCcoSmartCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SendCcoSmartCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SendCcoSmartCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SendCcoSmartCallOperateRequest(TeaModel):
    def __init__(
        self,
        call_id: str = None,
        command: str = None,
        owner_id: int = None,
        param: str = None,
        prod_code: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.call_id = call_id
        self.command = command
        self.owner_id = owner_id
        self.param = param
        self.prod_code = prod_code
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.command is not None:
            result['Command'] = self.command
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.param is not None:
            result['Param'] = self.param
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class SendCcoSmartCallOperateResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SendCcoSmartCallOperateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SendCcoSmartCallOperateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SendCcoSmartCallOperateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SendHotlineHeartBeatRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        instance_id: str = None,
        token: str = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.instance_id = instance_id
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class SendHotlineHeartBeatResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SendHotlineHeartBeatResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SendHotlineHeartBeatResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SendHotlineHeartBeatResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartAiOutboundTaskRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        task_id: int = None,
    ):
        self.instance_id = instance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class StartAiOutboundTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartAiOutboundTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: StartAiOutboundTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartAiOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartCallRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        callee: str = None,
        caller: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.callee = callee
        self.caller = caller
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class StartCallResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartCallResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: StartCallResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartCallV2Request(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        callee: str = None,
        caller: str = None,
        caller_type: int = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.callee = callee
        self.caller = caller
        self.caller_type = caller_type
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.caller_type is not None:
            result['CallerType'] = self.caller_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('CallerType') is not None:
            self.caller_type = m.get('CallerType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class StartCallV2ResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartCallV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: StartCallV2ResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartCallV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartChatWorkRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class StartChatWorkResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartChatWorkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: StartChatWorkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartChatWorkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartHotlineServiceRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        instance_id: str = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class StartHotlineServiceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartHotlineServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: StartHotlineServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartHotlineServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartMicroOutboundRequest(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_type: str = None,
        app_name: str = None,
        called_number: str = None,
        calling_number: str = None,
        command_code: str = None,
        ext_info: str = None,
        owner_id: int = None,
        prod_code: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.account_id = account_id
        self.account_type = account_type
        self.app_name = app_name
        self.called_number = called_number
        self.calling_number = calling_number
        self.command_code = command_code
        self.ext_info = ext_info
        self.owner_id = owner_id
        self.prod_code = prod_code
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.command_code is not None:
            result['CommandCode'] = self.command_code
        if self.ext_info is not None:
            result['ExtInfo'] = self.ext_info
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('CommandCode') is not None:
            self.command_code = m.get('CommandCode')
        if m.get('ExtInfo') is not None:
            self.ext_info = m.get('ExtInfo')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class StartMicroOutboundResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        customer_info: str = None,
        invoke_cmd_id: str = None,
        invoke_create_time: str = None,
        message: str = None,
        request_id: str = None,
    ):
        self.code = code
        self.customer_info = customer_info
        self.invoke_cmd_id = invoke_cmd_id
        self.invoke_create_time = invoke_create_time
        self.message = message
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.customer_info is not None:
            result['CustomerInfo'] = self.customer_info
        if self.invoke_cmd_id is not None:
            result['InvokeCmdId'] = self.invoke_cmd_id
        if self.invoke_create_time is not None:
            result['InvokeCreateTime'] = self.invoke_create_time
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CustomerInfo') is not None:
            self.customer_info = m.get('CustomerInfo')
        if m.get('InvokeCmdId') is not None:
            self.invoke_cmd_id = m.get('InvokeCmdId')
        if m.get('InvokeCreateTime') is not None:
            self.invoke_create_time = m.get('InvokeCreateTime')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class StartMicroOutboundResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: StartMicroOutboundResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartMicroOutboundResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartTaskRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        start_now: bool = None,
        task_id: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.start_now = start_now
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_now is not None:
            result['StartNow'] = self.start_now
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartNow') is not None:
            self.start_now = m.get('StartNow')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class StartTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: StartTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StopAiOutboundTaskRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        task_id: int = None,
    ):
        self.instance_id = instance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class StopAiOutboundTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StopAiOutboundTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: StopAiOutboundTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StopAiOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StopTaskRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        task_id: int = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class StopTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StopTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: StopTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StopTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SuspendHotlineServiceRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        instance_id: str = None,
        type: int = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.instance_id = instance_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class SuspendHotlineServiceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SuspendHotlineServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SuspendHotlineServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SuspendHotlineServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SuspendOutboundTaskRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        outbound_task_id: int = None,
    ):
        self.instance_id = instance_id
        self.outbound_task_id = outbound_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_task_id is not None:
            result['OutboundTaskId'] = self.outbound_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundTaskId') is not None:
            self.outbound_task_id = m.get('OutboundTaskId')
        return self


class SuspendOutboundTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SuspendOutboundTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SuspendOutboundTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SuspendOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class TerminateAiOutboundTaskRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        task_id: int = None,
    ):
        self.instance_id = instance_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class TerminateAiOutboundTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class TerminateAiOutboundTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: TerminateAiOutboundTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = TerminateAiOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class TransferCallToSkillGroupRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        call_id: str = None,
        client_token: str = None,
        connection_id: str = None,
        hold_connection_id: str = None,
        instance_id: str = None,
        is_single_transfer: bool = None,
        job_id: str = None,
        skill_group_id: int = None,
        type: int = None,
    ):
        self.account_name = account_name
        self.call_id = call_id
        self.client_token = client_token
        self.connection_id = connection_id
        self.hold_connection_id = hold_connection_id
        self.instance_id = instance_id
        self.is_single_transfer = is_single_transfer
        self.job_id = job_id
        self.skill_group_id = skill_group_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.hold_connection_id is not None:
            result['HoldConnectionId'] = self.hold_connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_single_transfer is not None:
            result['IsSingleTransfer'] = self.is_single_transfer
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('HoldConnectionId') is not None:
            self.hold_connection_id = m.get('HoldConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsSingleTransfer') is not None:
            self.is_single_transfer = m.get('IsSingleTransfer')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class TransferCallToSkillGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class TransferCallToSkillGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: TransferCallToSkillGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = TransferCallToSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateAgentRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        client_token: str = None,
        display_name: str = None,
        instance_id: str = None,
        skill_group_id: List[int] = None,
        skill_group_id_list: List[int] = None,
    ):
        self.account_name = account_name
        self.client_token = client_token
        self.display_name = display_name
        self.instance_id = instance_id
        self.skill_group_id = skill_group_id
        self.skill_group_id_list = skill_group_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class UpdateAgentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class UpdateAgentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateAgentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateAgentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateAiOutboundTaskRequestRecallRule(TeaModel):
    def __init__(
        self,
        count: int = None,
        interval: int = None,
    ):
        self.count = count
        self.interval = interval

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class UpdateAiOutboundTaskRequest(TeaModel):
    def __init__(
        self,
        concurrent_rate: int = None,
        description: str = None,
        execution_time: str = None,
        forecast_call_rate: float = None,
        handler_id: int = None,
        instance_id: str = None,
        name: str = None,
        num_repeated: int = None,
        outbound_nums: List[str] = None,
        recall_rule: UpdateAiOutboundTaskRequestRecallRule = None,
        task_id: int = None,
    ):
        self.concurrent_rate = concurrent_rate
        self.description = description
        self.execution_time = execution_time
        self.forecast_call_rate = forecast_call_rate
        self.handler_id = handler_id
        self.instance_id = instance_id
        self.name = name
        self.num_repeated = num_repeated
        self.outbound_nums = outbound_nums
        self.recall_rule = recall_rule
        self.task_id = task_id

    def validate(self):
        if self.recall_rule:
            self.recall_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrent_rate is not None:
            result['ConcurrentRate'] = self.concurrent_rate
        if self.description is not None:
            result['Description'] = self.description
        if self.execution_time is not None:
            result['ExecutionTime'] = self.execution_time
        if self.forecast_call_rate is not None:
            result['ForecastCallRate'] = self.forecast_call_rate
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.num_repeated is not None:
            result['NumRepeated'] = self.num_repeated
        if self.outbound_nums is not None:
            result['OutboundNums'] = self.outbound_nums
        if self.recall_rule is not None:
            result['RecallRule'] = self.recall_rule.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcurrentRate') is not None:
            self.concurrent_rate = m.get('ConcurrentRate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExecutionTime') is not None:
            self.execution_time = m.get('ExecutionTime')
        if m.get('ForecastCallRate') is not None:
            self.forecast_call_rate = m.get('ForecastCallRate')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumRepeated') is not None:
            self.num_repeated = m.get('NumRepeated')
        if m.get('OutboundNums') is not None:
            self.outbound_nums = m.get('OutboundNums')
        if m.get('RecallRule') is not None:
            temp_model = UpdateAiOutboundTaskRequestRecallRule()
            self.recall_rule = temp_model.from_map(m['RecallRule'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class UpdateAiOutboundTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        concurrent_rate: int = None,
        description: str = None,
        execution_time: str = None,
        forecast_call_rate: float = None,
        handler_id: int = None,
        instance_id: str = None,
        name: str = None,
        num_repeated: int = None,
        outbound_nums_shrink: str = None,
        recall_rule_shrink: str = None,
        task_id: int = None,
    ):
        self.concurrent_rate = concurrent_rate
        self.description = description
        self.execution_time = execution_time
        self.forecast_call_rate = forecast_call_rate
        self.handler_id = handler_id
        self.instance_id = instance_id
        self.name = name
        self.num_repeated = num_repeated
        self.outbound_nums_shrink = outbound_nums_shrink
        self.recall_rule_shrink = recall_rule_shrink
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrent_rate is not None:
            result['ConcurrentRate'] = self.concurrent_rate
        if self.description is not None:
            result['Description'] = self.description
        if self.execution_time is not None:
            result['ExecutionTime'] = self.execution_time
        if self.forecast_call_rate is not None:
            result['ForecastCallRate'] = self.forecast_call_rate
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.num_repeated is not None:
            result['NumRepeated'] = self.num_repeated
        if self.outbound_nums_shrink is not None:
            result['OutboundNums'] = self.outbound_nums_shrink
        if self.recall_rule_shrink is not None:
            result['RecallRule'] = self.recall_rule_shrink
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcurrentRate') is not None:
            self.concurrent_rate = m.get('ConcurrentRate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExecutionTime') is not None:
            self.execution_time = m.get('ExecutionTime')
        if m.get('ForecastCallRate') is not None:
            self.forecast_call_rate = m.get('ForecastCallRate')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumRepeated') is not None:
            self.num_repeated = m.get('NumRepeated')
        if m.get('OutboundNums') is not None:
            self.outbound_nums_shrink = m.get('OutboundNums')
        if m.get('RecallRule') is not None:
            self.recall_rule_shrink = m.get('RecallRule')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class UpdateAiOutboundTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class UpdateAiOutboundTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateAiOutboundTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateAiOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateDepartmentRequest(TeaModel):
    def __init__(
        self,
        department_id: int = None,
        department_name: str = None,
        instance_id: str = None,
    ):
        self.department_id = department_id
        self.department_name = department_name
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.department_name is not None:
            result['DepartmentName'] = self.department_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('DepartmentName') is not None:
            self.department_name = m.get('DepartmentName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class UpdateDepartmentResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class UpdateDepartmentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: UpdateDepartmentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
           