"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancePolicy = exports.VersionsLists = void 0;
const iam = require("@aws-cdk/aws-iam");
/**
 *
 */
var VersionsLists;
(function (VersionsLists) {
    VersionsLists["AWS_LOAD_BALANCER_CONTROLLER_POLICY_V1"] = "v1";
    VersionsLists["AWS_LOAD_BALANCER_CONTROLLER_POLICY_V2"] = "v2";
})(VersionsLists = exports.VersionsLists || (exports.VersionsLists = {}));
const awsLoadBalancerControllerPolicyV1 = {
    actions: [
        'acm:DescribeCertificate',
        'acm:ListCertificates',
        'acm:GetCertificate',
        'ec2:AuthorizeSecurityGroupIngress',
        'ec2:CreateSecurityGroup',
        'ec2:CreateTags',
        'ec2:DeleteTags',
        'ec2:DeleteSecurityGroup',
        'ec2:DescribeAccountAttributes',
        'ec2:DescribeAddresses',
        'ec2:DescribeInstances',
        'ec2:DescribeInstanceStatus',
        'ec2:DescribeInternetGateways',
        'ec2:DescribeNetworkInterfaces',
        'ec2:DescribeSecurityGroups',
        'ec2:DescribeSubnets',
        'ec2:DescribeTags',
        'ec2:DescribeVpcs',
        'ec2:ModifyInstanceAttribute',
        'ec2:ModifyNetworkInterfaceAttribute',
        'ec2:RevokeSecurityGroupIngress',
        'elasticloadbalancing:AddListenerCertificates',
        'elasticloadbalancing:AddTags',
        'elasticloadbalancing:CreateListener',
        'elasticloadbalancing:CreateLoadBalancer',
        'elasticloadbalancing:CreateRule',
        'elasticloadbalancing:CreateTargetGroup',
        'elasticloadbalancing:DeleteListener',
        'elasticloadbalancing:DeleteLoadBalancer',
        'elasticloadbalancing:DeleteRule',
        'elasticloadbalancing:DeleteTargetGroup',
        'elasticloadbalancing:DeregisterTargets',
        'elasticloadbalancing:DescribeListenerCertificates',
        'elasticloadbalancing:DescribeListeners',
        'elasticloadbalancing:DescribeLoadBalancers',
        'elasticloadbalancing:DescribeLoadBalancerAttributes',
        'elasticloadbalancing:DescribeRules',
        'elasticloadbalancing:DescribeSSLPolicies',
        'elasticloadbalancing:DescribeTags',
        'elasticloadbalancing:DescribeTargetGroups',
        'elasticloadbalancing:DescribeTargetGroupAttributes',
        'elasticloadbalancing:DescribeTargetHealth',
        'elasticloadbalancing:ModifyListener',
        'elasticloadbalancing:ModifyLoadBalancerAttributes',
        'elasticloadbalancing:ModifyRule',
        'elasticloadbalancing:ModifyTargetGroup',
        'elasticloadbalancing:ModifyTargetGroupAttributes',
        'elasticloadbalancing:RegisterTargets',
        'elasticloadbalancing:RemoveListenerCertificates',
        'elasticloadbalancing:RemoveTags',
        'elasticloadbalancing:SetIpAddressType',
        'elasticloadbalancing:SetSecurityGroups',
        'elasticloadbalancing:SetSubnets',
        'elasticloadbalancing:SetWebAcl',
        'iam:CreateServiceLinkedRole',
        'iam:GetServerCertificate',
        'iam:ListServerCertificates',
        'cognito-idp:DescribeUserPoolClient',
        'waf-regional:GetWebACLForResource',
        'waf-regional:GetWebACL',
        'waf-regional:AssociateWebACL',
        'waf-regional:DisassociateWebACL',
        'tag:GetResources',
        'tag:TagResources',
        'waf:GetWebACL',
        'wafv2:GetWebACL',
        'wafv2:GetWebACLForResource',
        'wafv2:AssociateWebACL',
        'wafv2:DisassociateWebACL',
        'shield:DescribeProtection',
        'shield:GetSubscriptionState',
        'shield:DeleteProtection',
        'shield:CreateProtection',
        'shield:DescribeSubscription',
    ],
    resources: ['*'],
};
const awsLoadBalancerControllerPolicyV2 = [
    {
        Effect: 'Allow',
        Action: [
            'iam:CreateServiceLinkedRole',
            'ec2:DescribeAccountAttributes',
            'ec2:DescribeAddresses',
            'ec2:DescribeInternetGateways',
            'ec2:DescribeVpcs',
            'ec2:DescribeSubnets',
            'ec2:DescribeSecurityGroups',
            'ec2:DescribeInstances',
            'ec2:DescribeNetworkInterfaces',
            'ec2:DescribeTags',
            'elasticloadbalancing:DescribeLoadBalancers',
            'elasticloadbalancing:DescribeLoadBalancerAttributes',
            'elasticloadbalancing:DescribeListeners',
            'elasticloadbalancing:DescribeListenerCertificates',
            'elasticloadbalancing:DescribeSSLPolicies',
            'elasticloadbalancing:DescribeRules',
            'elasticloadbalancing:DescribeTargetGroups',
            'elasticloadbalancing:DescribeTargetGroupAttributes',
            'elasticloadbalancing:DescribeTargetHealth',
            'elasticloadbalancing:DescribeTags',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'cognito-idp:DescribeUserPoolClient',
            'acm:ListCertificates',
            'acm:DescribeCertificate',
            'iam:ListServerCertificates',
            'iam:GetServerCertificate',
            'waf-regional:GetWebACL',
            'waf-regional:GetWebACLForResource',
            'waf-regional:AssociateWebACL',
            'waf-regional:DisassociateWebACL',
            'wafv2:GetWebACL',
            'wafv2:GetWebACLForResource',
            'wafv2:AssociateWebACL',
            'wafv2:DisassociateWebACL',
            'shield:GetSubscriptionState',
            'shield:DescribeProtection',
            'shield:CreateProtection',
            'shield:DeleteProtection',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:AuthorizeSecurityGroupIngress',
            'ec2:RevokeSecurityGroupIngress',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:CreateSecurityGroup',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:CreateTags',
        ],
        Resource: 'arn:aws:ec2:*:*:security-group/*',
        Condition: {
            StringEquals: {
                'ec2:CreateAction': 'CreateSecurityGroup',
            },
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:CreateTags',
            'ec2:DeleteTags',
        ],
        Resource: 'arn:aws:ec2:*:*:security-group/*',
        Condition: {
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:AuthorizeSecurityGroupIngress',
            'ec2:RevokeSecurityGroupIngress',
            'ec2:DeleteSecurityGroup',
        ],
        Resource: '*',
        Condition: {
            Null: {
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:CreateLoadBalancer',
            'elasticloadbalancing:CreateTargetGroup',
        ],
        Resource: '*',
        Condition: {
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:CreateListener',
            'elasticloadbalancing:DeleteListener',
            'elasticloadbalancing:CreateRule',
            'elasticloadbalancing:DeleteRule',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:AddTags',
            'elasticloadbalancing:RemoveTags',
        ],
        Resource: [
            'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
            'arn:aws:elasticloadbalancing:*:*:loadbalancer/net/*/*',
            'arn:aws:elasticloadbalancing:*:*:loadbalancer/app/*/*',
        ],
        Condition: {
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:ModifyLoadBalancerAttributes',
            'elasticloadbalancing:SetIpAddressType',
            'elasticloadbalancing:SetSecurityGroups',
            'elasticloadbalancing:SetSubnets',
            'elasticloadbalancing:DeleteLoadBalancer',
            'elasticloadbalancing:ModifyTargetGroup',
            'elasticloadbalancing:ModifyTargetGroupAttributes',
            'elasticloadbalancing:DeleteTargetGroup',
        ],
        Resource: '*',
        Condition: {
            Null: {
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:RegisterTargets',
            'elasticloadbalancing:DeregisterTargets',
        ],
        Resource: 'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:SetWebAcl',
            'elasticloadbalancing:ModifyListener',
            'elasticloadbalancing:AddListenerCertificates',
            'elasticloadbalancing:RemoveListenerCertificates',
            'elasticloadbalancing:ModifyRule',
        ],
        Resource: '*',
    },
];
/**
 * awsLoadBalancePolicy class ,help you add policy to your Iam Role for service account.
 */
class AwsLoadBalancePolicy {
    /**
     *
     */
    static addPolicy(version, role) {
        if (version == 'v1') {
            role.addToPolicy(new iam.PolicyStatement(awsLoadBalancerControllerPolicyV1));
            return role;
        }
        if (version == 'v2') {
            awsLoadBalancerControllerPolicyV2.forEach(element => {
                role.addToPolicy(iam.PolicyStatement.fromJson(element));
            });
            return role;
        }
    }
}
exports.AwsLoadBalancePolicy = AwsLoadBalancePolicy;
;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWxiLWNvbnRyb2xsZXItcG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2FsYi1jb250cm9sbGVyLXBvbGljeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx3Q0FBd0M7Ozs7QUFDeEMsSUFBWSxhQVNYO0FBVEQsV0FBWSxhQUFhO0lBSXZCLDhEQUE2QyxDQUFBO0lBSTdDLDhEQUE2QyxDQUFBO0FBQy9DLENBQUMsRUFUVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQVN4QjtBQUNELE1BQU0saUNBQWlDLEdBQUc7SUFDeEMsT0FBTyxFQUFFO1FBQ1AseUJBQXlCO1FBQ3pCLHNCQUFzQjtRQUN0QixvQkFBb0I7UUFDcEIsbUNBQW1DO1FBQ25DLHlCQUF5QjtRQUN6QixnQkFBZ0I7UUFDaEIsZ0JBQWdCO1FBQ2hCLHlCQUF5QjtRQUN6QiwrQkFBK0I7UUFDL0IsdUJBQXVCO1FBQ3ZCLHVCQUF1QjtRQUN2Qiw0QkFBNEI7UUFDNUIsOEJBQThCO1FBQzlCLCtCQUErQjtRQUMvQiw0QkFBNEI7UUFDNUIscUJBQXFCO1FBQ3JCLGtCQUFrQjtRQUNsQixrQkFBa0I7UUFDbEIsNkJBQTZCO1FBQzdCLHFDQUFxQztRQUNyQyxnQ0FBZ0M7UUFDaEMsOENBQThDO1FBQzlDLDhCQUE4QjtRQUM5QixxQ0FBcUM7UUFDckMseUNBQXlDO1FBQ3pDLGlDQUFpQztRQUNqQyx3Q0FBd0M7UUFDeEMscUNBQXFDO1FBQ3JDLHlDQUF5QztRQUN6QyxpQ0FBaUM7UUFDakMsd0NBQXdDO1FBQ3hDLHdDQUF3QztRQUN4QyxtREFBbUQ7UUFDbkQsd0NBQXdDO1FBQ3hDLDRDQUE0QztRQUM1QyxxREFBcUQ7UUFDckQsb0NBQW9DO1FBQ3BDLDBDQUEwQztRQUMxQyxtQ0FBbUM7UUFDbkMsMkNBQTJDO1FBQzNDLG9EQUFvRDtRQUNwRCwyQ0FBMkM7UUFDM0MscUNBQXFDO1FBQ3JDLG1EQUFtRDtRQUNuRCxpQ0FBaUM7UUFDakMsd0NBQXdDO1FBQ3hDLGtEQUFrRDtRQUNsRCxzQ0FBc0M7UUFDdEMsaURBQWlEO1FBQ2pELGlDQUFpQztRQUNqQyx1Q0FBdUM7UUFDdkMsd0NBQXdDO1FBQ3hDLGlDQUFpQztRQUNqQyxnQ0FBZ0M7UUFDaEMsNkJBQTZCO1FBQzdCLDBCQUEwQjtRQUMxQiw0QkFBNEI7UUFDNUIsb0NBQW9DO1FBQ3BDLG1DQUFtQztRQUNuQyx3QkFBd0I7UUFDeEIsOEJBQThCO1FBQzlCLGlDQUFpQztRQUNqQyxrQkFBa0I7UUFDbEIsa0JBQWtCO1FBQ2xCLGVBQWU7UUFDZixpQkFBaUI7UUFDakIsNEJBQTRCO1FBQzVCLHVCQUF1QjtRQUN2QiwwQkFBMEI7UUFDMUIsMkJBQTJCO1FBQzNCLDZCQUE2QjtRQUM3Qix5QkFBeUI7UUFDekIseUJBQXlCO1FBQ3pCLDZCQUE2QjtLQUM5QjtJQUNELFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQztDQUNqQixDQUFDO0FBR0YsTUFBTSxpQ0FBaUMsR0FBRztJQUN4QztRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04sNkJBQTZCO1lBQzdCLCtCQUErQjtZQUMvQix1QkFBdUI7WUFDdkIsOEJBQThCO1lBQzlCLGtCQUFrQjtZQUNsQixxQkFBcUI7WUFDckIsNEJBQTRCO1lBQzVCLHVCQUF1QjtZQUN2QiwrQkFBK0I7WUFDL0Isa0JBQWtCO1lBQ2xCLDRDQUE0QztZQUM1QyxxREFBcUQ7WUFDckQsd0NBQXdDO1lBQ3hDLG1EQUFtRDtZQUNuRCwwQ0FBMEM7WUFDMUMsb0NBQW9DO1lBQ3BDLDJDQUEyQztZQUMzQyxvREFBb0Q7WUFDcEQsMkNBQTJDO1lBQzNDLG1DQUFtQztTQUNwQztRQUNELFFBQVEsRUFBRSxHQUFHO0tBQ2Q7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04sb0NBQW9DO1lBQ3BDLHNCQUFzQjtZQUN0Qix5QkFBeUI7WUFDekIsNEJBQTRCO1lBQzVCLDBCQUEwQjtZQUMxQix3QkFBd0I7WUFDeEIsbUNBQW1DO1lBQ25DLDhCQUE4QjtZQUM5QixpQ0FBaUM7WUFDakMsaUJBQWlCO1lBQ2pCLDRCQUE0QjtZQUM1Qix1QkFBdUI7WUFDdkIsMEJBQTBCO1lBQzFCLDZCQUE2QjtZQUM3QiwyQkFBMkI7WUFDM0IseUJBQXlCO1lBQ3pCLHlCQUF5QjtTQUMxQjtRQUNELFFBQVEsRUFBRSxHQUFHO0tBQ2Q7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04sbUNBQW1DO1lBQ25DLGdDQUFnQztTQUNqQztRQUNELFFBQVEsRUFBRSxHQUFHO0tBQ2Q7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04seUJBQXlCO1NBQzFCO1FBQ0QsUUFBUSxFQUFFLEdBQUc7S0FDZDtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTixnQkFBZ0I7U0FDakI7UUFDRCxRQUFRLEVBQUUsa0NBQWtDO1FBQzVDLFNBQVMsRUFBRTtZQUNULFlBQVksRUFBRTtnQkFDWixrQkFBa0IsRUFBRSxxQkFBcUI7YUFDMUM7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osc0NBQXNDLEVBQUUsT0FBTzthQUNoRDtTQUNGO0tBQ0Y7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04sZ0JBQWdCO1lBQ2hCLGdCQUFnQjtTQUNqQjtRQUNELFFBQVEsRUFBRSxrQ0FBa0M7UUFDNUMsU0FBUyxFQUFFO1lBQ1QsSUFBSSxFQUFFO2dCQUNKLHNDQUFzQyxFQUFFLE1BQU07Z0JBQzlDLHVDQUF1QyxFQUFFLE9BQU87YUFDakQ7U0FDRjtLQUNGO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLG1DQUFtQztZQUNuQyxnQ0FBZ0M7WUFDaEMseUJBQXlCO1NBQzFCO1FBQ0QsUUFBUSxFQUFFLEdBQUc7UUFDYixTQUFTLEVBQUU7WUFDVCxJQUFJLEVBQUU7Z0JBQ0osdUNBQXVDLEVBQUUsT0FBTzthQUNqRDtTQUNGO0tBQ0Y7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04seUNBQXlDO1lBQ3pDLHdDQUF3QztTQUN6QztRQUNELFFBQVEsRUFBRSxHQUFHO1FBQ2IsU0FBUyxFQUFFO1lBQ1QsSUFBSSxFQUFFO2dCQUNKLHNDQUFzQyxFQUFFLE9BQU87YUFDaEQ7U0FDRjtLQUNGO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLHFDQUFxQztZQUNyQyxxQ0FBcUM7WUFDckMsaUNBQWlDO1lBQ2pDLGlDQUFpQztTQUNsQztRQUNELFFBQVEsRUFBRSxHQUFHO0tBQ2Q7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04sOEJBQThCO1lBQzlCLGlDQUFpQztTQUNsQztRQUNELFFBQVEsRUFBRTtZQUNSLGtEQUFrRDtZQUNsRCx1REFBdUQ7WUFDdkQsdURBQXVEO1NBQ3hEO1FBQ0QsU0FBUyxFQUFFO1lBQ1QsSUFBSSxFQUFFO2dCQUNKLHNDQUFzQyxFQUFFLE1BQU07Z0JBQzlDLHVDQUF1QyxFQUFFLE9BQU87YUFDakQ7U0FDRjtLQUNGO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLG1EQUFtRDtZQUNuRCx1Q0FBdUM7WUFDdkMsd0NBQXdDO1lBQ3hDLGlDQUFpQztZQUNqQyx5Q0FBeUM7WUFDekMsd0NBQXdDO1lBQ3hDLGtEQUFrRDtZQUNsRCx3Q0FBd0M7U0FDekM7UUFDRCxRQUFRLEVBQUUsR0FBRztRQUNiLFNBQVMsRUFBRTtZQUNULElBQUksRUFBRTtnQkFDSix1Q0FBdUMsRUFBRSxPQUFPO2FBQ2pEO1NBQ0Y7S0FDRjtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTixzQ0FBc0M7WUFDdEMsd0NBQXdDO1NBQ3pDO1FBQ0QsUUFBUSxFQUFFLGtEQUFrRDtLQUM3RDtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTixnQ0FBZ0M7WUFDaEMscUNBQXFDO1lBQ3JDLDhDQUE4QztZQUM5QyxpREFBaUQ7WUFDakQsaUNBQWlDO1NBQ2xDO1FBQ0QsUUFBUSxFQUFFLEdBQUc7S0FDZDtDQUNGLENBQUM7Ozs7QUFLRixNQUFhLG9CQUFvQjs7OztJQUN4QixNQUFNLENBQUMsU0FBUyxDQUFDLE9BQWUsRUFBRSxJQUFTO1FBQ2hELElBQUksT0FBTyxJQUFJLElBQUksRUFBRTtZQUNuQixJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBRSxpQ0FBaUMsQ0FBRSxDQUFDLENBQUM7WUFDL0UsT0FBTyxJQUFJLENBQUM7U0FDYjtRQUFDLElBQUksT0FBTyxJQUFJLElBQUksRUFBRTtZQUNyQixpQ0FBaUMsQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLEVBQUU7Z0JBQ2xELElBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztZQUMxRCxDQUFDLENBQUMsQ0FBQztZQUNILE9BQU8sSUFBSSxDQUFDO1NBQ2I7SUFDSCxDQUFDO0NBQ0Y7QUFaRCxvREFZQztBQUFBLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5leHBvcnQgZW51bSBWZXJzaW9uc0xpc3RzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVdTX0xPQURfQkFMQU5DRVJfQ09OVFJPTExFUl9QT0xJQ1lfVjEgPSAndjEnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFXU19MT0FEX0JBTEFOQ0VSX0NPTlRST0xMRVJfUE9MSUNZX1YyID0gJ3YyJyxcbn1cbmNvbnN0IGF3c0xvYWRCYWxhbmNlckNvbnRyb2xsZXJQb2xpY3lWMSA9IHtcbiAgYWN0aW9uczogW1xuICAgICdhY206RGVzY3JpYmVDZXJ0aWZpY2F0ZScsXG4gICAgJ2FjbTpMaXN0Q2VydGlmaWNhdGVzJyxcbiAgICAnYWNtOkdldENlcnRpZmljYXRlJyxcbiAgICAnZWMyOkF1dGhvcml6ZVNlY3VyaXR5R3JvdXBJbmdyZXNzJyxcbiAgICAnZWMyOkNyZWF0ZVNlY3VyaXR5R3JvdXAnLFxuICAgICdlYzI6Q3JlYXRlVGFncycsXG4gICAgJ2VjMjpEZWxldGVUYWdzJyxcbiAgICAnZWMyOkRlbGV0ZVNlY3VyaXR5R3JvdXAnLFxuICAgICdlYzI6RGVzY3JpYmVBY2NvdW50QXR0cmlidXRlcycsXG4gICAgJ2VjMjpEZXNjcmliZUFkZHJlc3NlcycsXG4gICAgJ2VjMjpEZXNjcmliZUluc3RhbmNlcycsXG4gICAgJ2VjMjpEZXNjcmliZUluc3RhbmNlU3RhdHVzJyxcbiAgICAnZWMyOkRlc2NyaWJlSW50ZXJuZXRHYXRld2F5cycsXG4gICAgJ2VjMjpEZXNjcmliZU5ldHdvcmtJbnRlcmZhY2VzJyxcbiAgICAnZWMyOkRlc2NyaWJlU2VjdXJpdHlHcm91cHMnLFxuICAgICdlYzI6RGVzY3JpYmVTdWJuZXRzJyxcbiAgICAnZWMyOkRlc2NyaWJlVGFncycsXG4gICAgJ2VjMjpEZXNjcmliZVZwY3MnLFxuICAgICdlYzI6TW9kaWZ5SW5zdGFuY2VBdHRyaWJ1dGUnLFxuICAgICdlYzI6TW9kaWZ5TmV0d29ya0ludGVyZmFjZUF0dHJpYnV0ZScsXG4gICAgJ2VjMjpSZXZva2VTZWN1cml0eUdyb3VwSW5ncmVzcycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkFkZExpc3RlbmVyQ2VydGlmaWNhdGVzJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6QWRkVGFncycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkNyZWF0ZUxpc3RlbmVyJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6Q3JlYXRlTG9hZEJhbGFuY2VyJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6Q3JlYXRlUnVsZScsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkNyZWF0ZVRhcmdldEdyb3VwJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVsZXRlTGlzdGVuZXInLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZWxldGVMb2FkQmFsYW5jZXInLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZWxldGVSdWxlJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVsZXRlVGFyZ2V0R3JvdXAnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXJlZ2lzdGVyVGFyZ2V0cycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlTGlzdGVuZXJDZXJ0aWZpY2F0ZXMnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZUxpc3RlbmVycycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlTG9hZEJhbGFuY2VycycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlTG9hZEJhbGFuY2VyQXR0cmlidXRlcycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlUnVsZXMnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVNTTFBvbGljaWVzJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVUYWdzJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVUYXJnZXRHcm91cHMnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVRhcmdldEdyb3VwQXR0cmlidXRlcycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlVGFyZ2V0SGVhbHRoJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6TW9kaWZ5TGlzdGVuZXInLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpNb2RpZnlMb2FkQmFsYW5jZXJBdHRyaWJ1dGVzJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6TW9kaWZ5UnVsZScsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOk1vZGlmeVRhcmdldEdyb3VwJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6TW9kaWZ5VGFyZ2V0R3JvdXBBdHRyaWJ1dGVzJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6UmVnaXN0ZXJUYXJnZXRzJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6UmVtb3ZlTGlzdGVuZXJDZXJ0aWZpY2F0ZXMnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpSZW1vdmVUYWdzJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6U2V0SXBBZGRyZXNzVHlwZScsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlNldFNlY3VyaXR5R3JvdXBzJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6U2V0U3VibmV0cycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlNldFdlYkFjbCcsXG4gICAgJ2lhbTpDcmVhdGVTZXJ2aWNlTGlua2VkUm9sZScsXG4gICAgJ2lhbTpHZXRTZXJ2ZXJDZXJ0aWZpY2F0ZScsXG4gICAgJ2lhbTpMaXN0U2VydmVyQ2VydGlmaWNhdGVzJyxcbiAgICAnY29nbml0by1pZHA6RGVzY3JpYmVVc2VyUG9vbENsaWVudCcsXG4gICAgJ3dhZi1yZWdpb25hbDpHZXRXZWJBQ0xGb3JSZXNvdXJjZScsXG4gICAgJ3dhZi1yZWdpb25hbDpHZXRXZWJBQ0wnLFxuICAgICd3YWYtcmVnaW9uYWw6QXNzb2NpYXRlV2ViQUNMJyxcbiAgICAnd2FmLXJlZ2lvbmFsOkRpc2Fzc29jaWF0ZVdlYkFDTCcsXG4gICAgJ3RhZzpHZXRSZXNvdXJjZXMnLFxuICAgICd0YWc6VGFnUmVzb3VyY2VzJyxcbiAgICAnd2FmOkdldFdlYkFDTCcsXG4gICAgJ3dhZnYyOkdldFdlYkFDTCcsXG4gICAgJ3dhZnYyOkdldFdlYkFDTEZvclJlc291cmNlJyxcbiAgICAnd2FmdjI6QXNzb2NpYXRlV2ViQUNMJyxcbiAgICAnd2FmdjI6RGlzYXNzb2NpYXRlV2ViQUNMJyxcbiAgICAnc2hpZWxkOkRlc2NyaWJlUHJvdGVjdGlvbicsXG4gICAgJ3NoaWVsZDpHZXRTdWJzY3JpcHRpb25TdGF0ZScsXG4gICAgJ3NoaWVsZDpEZWxldGVQcm90ZWN0aW9uJyxcbiAgICAnc2hpZWxkOkNyZWF0ZVByb3RlY3Rpb24nLFxuICAgICdzaGllbGQ6RGVzY3JpYmVTdWJzY3JpcHRpb24nLFxuICBdLFxuICByZXNvdXJjZXM6IFsnKiddLFxufTtcblxuXG5jb25zdCBhd3NMb2FkQmFsYW5jZXJDb250cm9sbGVyUG9saWN5VjIgPSBbXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnaWFtOkNyZWF0ZVNlcnZpY2VMaW5rZWRSb2xlJyxcbiAgICAgICdlYzI6RGVzY3JpYmVBY2NvdW50QXR0cmlidXRlcycsXG4gICAgICAnZWMyOkRlc2NyaWJlQWRkcmVzc2VzJyxcbiAgICAgICdlYzI6RGVzY3JpYmVJbnRlcm5ldEdhdGV3YXlzJyxcbiAgICAgICdlYzI6RGVzY3JpYmVWcGNzJyxcbiAgICAgICdlYzI6RGVzY3JpYmVTdWJuZXRzJyxcbiAgICAgICdlYzI6RGVzY3JpYmVTZWN1cml0eUdyb3VwcycsXG4gICAgICAnZWMyOkRlc2NyaWJlSW5zdGFuY2VzJyxcbiAgICAgICdlYzI6RGVzY3JpYmVOZXR3b3JrSW50ZXJmYWNlcycsXG4gICAgICAnZWMyOkRlc2NyaWJlVGFncycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVMb2FkQmFsYW5jZXJzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZUxvYWRCYWxhbmNlckF0dHJpYnV0ZXMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlTGlzdGVuZXJzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZUxpc3RlbmVyQ2VydGlmaWNhdGVzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVNTTFBvbGljaWVzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVJ1bGVzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVRhcmdldEdyb3VwcycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVUYXJnZXRHcm91cEF0dHJpYnV0ZXMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlVGFyZ2V0SGVhbHRoJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVRhZ3MnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6ICcqJyxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdjb2duaXRvLWlkcDpEZXNjcmliZVVzZXJQb29sQ2xpZW50JyxcbiAgICAgICdhY206TGlzdENlcnRpZmljYXRlcycsXG4gICAgICAnYWNtOkRlc2NyaWJlQ2VydGlmaWNhdGUnLFxuICAgICAgJ2lhbTpMaXN0U2VydmVyQ2VydGlmaWNhdGVzJyxcbiAgICAgICdpYW06R2V0U2VydmVyQ2VydGlmaWNhdGUnLFxuICAgICAgJ3dhZi1yZWdpb25hbDpHZXRXZWJBQ0wnLFxuICAgICAgJ3dhZi1yZWdpb25hbDpHZXRXZWJBQ0xGb3JSZXNvdXJjZScsXG4gICAgICAnd2FmLXJlZ2lvbmFsOkFzc29jaWF0ZVdlYkFDTCcsXG4gICAgICAnd2FmLXJlZ2lvbmFsOkRpc2Fzc29jaWF0ZVdlYkFDTCcsXG4gICAgICAnd2FmdjI6R2V0V2ViQUNMJyxcbiAgICAgICd3YWZ2MjpHZXRXZWJBQ0xGb3JSZXNvdXJjZScsXG4gICAgICAnd2FmdjI6QXNzb2NpYXRlV2ViQUNMJyxcbiAgICAgICd3YWZ2MjpEaXNhc3NvY2lhdGVXZWJBQ0wnLFxuICAgICAgJ3NoaWVsZDpHZXRTdWJzY3JpcHRpb25TdGF0ZScsXG4gICAgICAnc2hpZWxkOkRlc2NyaWJlUHJvdGVjdGlvbicsXG4gICAgICAnc2hpZWxkOkNyZWF0ZVByb3RlY3Rpb24nLFxuICAgICAgJ3NoaWVsZDpEZWxldGVQcm90ZWN0aW9uJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnKicsXG4gIH0sXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnZWMyOkF1dGhvcml6ZVNlY3VyaXR5R3JvdXBJbmdyZXNzJyxcbiAgICAgICdlYzI6UmV2b2tlU2VjdXJpdHlHcm91cEluZ3Jlc3MnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6ICcqJyxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlYzI6Q3JlYXRlU2VjdXJpdHlHcm91cCcsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogJyonLFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2VjMjpDcmVhdGVUYWdzJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnYXJuOmF3czplYzI6KjoqOnNlY3VyaXR5LWdyb3VwLyonLFxuICAgIENvbmRpdGlvbjoge1xuICAgICAgU3RyaW5nRXF1YWxzOiB7XG4gICAgICAgICdlYzI6Q3JlYXRlQWN0aW9uJzogJ0NyZWF0ZVNlY3VyaXR5R3JvdXAnLFxuICAgICAgfSxcbiAgICAgIE51bGw6IHtcbiAgICAgICAgJ2F3czpSZXF1ZXN0VGFnL2VsYnYyLms4cy5hd3MvY2x1c3Rlcic6ICdmYWxzZScsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnZWMyOkNyZWF0ZVRhZ3MnLFxuICAgICAgJ2VjMjpEZWxldGVUYWdzJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnYXJuOmF3czplYzI6KjoqOnNlY3VyaXR5LWdyb3VwLyonLFxuICAgIENvbmRpdGlvbjoge1xuICAgICAgTnVsbDoge1xuICAgICAgICAnYXdzOlJlcXVlc3RUYWcvZWxidjIuazhzLmF3cy9jbHVzdGVyJzogJ3RydWUnLFxuICAgICAgICAnYXdzOlJlc291cmNlVGFnL2VsYnYyLms4cy5hd3MvY2x1c3Rlcic6ICdmYWxzZScsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnZWMyOkF1dGhvcml6ZVNlY3VyaXR5R3JvdXBJbmdyZXNzJyxcbiAgICAgICdlYzI6UmV2b2tlU2VjdXJpdHlHcm91cEluZ3Jlc3MnLFxuICAgICAgJ2VjMjpEZWxldGVTZWN1cml0eUdyb3VwJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnKicsXG4gICAgQ29uZGl0aW9uOiB7XG4gICAgICBOdWxsOiB7XG4gICAgICAgICdhd3M6UmVzb3VyY2VUYWcvZWxidjIuazhzLmF3cy9jbHVzdGVyJzogJ2ZhbHNlJyxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpDcmVhdGVMb2FkQmFsYW5jZXInLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkNyZWF0ZVRhcmdldEdyb3VwJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnKicsXG4gICAgQ29uZGl0aW9uOiB7XG4gICAgICBOdWxsOiB7XG4gICAgICAgICdhd3M6UmVxdWVzdFRhZy9lbGJ2Mi5rOHMuYXdzL2NsdXN0ZXInOiAnZmFsc2UnLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkNyZWF0ZUxpc3RlbmVyJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZWxldGVMaXN0ZW5lcicsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6Q3JlYXRlUnVsZScsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVsZXRlUnVsZScsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogJyonLFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkFkZFRhZ3MnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlJlbW92ZVRhZ3MnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6IFtcbiAgICAgICdhcm46YXdzOmVsYXN0aWNsb2FkYmFsYW5jaW5nOio6Kjp0YXJnZXRncm91cC8qLyonLFxuICAgICAgJ2Fybjphd3M6ZWxhc3RpY2xvYWRiYWxhbmNpbmc6KjoqOmxvYWRiYWxhbmNlci9uZXQvKi8qJyxcbiAgICAgICdhcm46YXdzOmVsYXN0aWNsb2FkYmFsYW5jaW5nOio6Kjpsb2FkYmFsYW5jZXIvYXBwLyovKicsXG4gICAgXSxcbiAgICBDb25kaXRpb246IHtcbiAgICAgIE51bGw6IHtcbiAgICAgICAgJ2F3czpSZXF1ZXN0VGFnL2VsYnYyLms4cy5hd3MvY2x1c3Rlcic6ICd0cnVlJyxcbiAgICAgICAgJ2F3czpSZXNvdXJjZVRhZy9lbGJ2Mi5rOHMuYXdzL2NsdXN0ZXInOiAnZmFsc2UnLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOk1vZGlmeUxvYWRCYWxhbmNlckF0dHJpYnV0ZXMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlNldElwQWRkcmVzc1R5cGUnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlNldFNlY3VyaXR5R3JvdXBzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpTZXRTdWJuZXRzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZWxldGVMb2FkQmFsYW5jZXInLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOk1vZGlmeVRhcmdldEdyb3VwJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpNb2RpZnlUYXJnZXRHcm91cEF0dHJpYnV0ZXMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlbGV0ZVRhcmdldEdyb3VwJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnKicsXG4gICAgQ29uZGl0aW9uOiB7XG4gICAgICBOdWxsOiB7XG4gICAgICAgICdhd3M6UmVzb3VyY2VUYWcvZWxidjIuazhzLmF3cy9jbHVzdGVyJzogJ2ZhbHNlJyxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpSZWdpc3RlclRhcmdldHMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlcmVnaXN0ZXJUYXJnZXRzJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnYXJuOmF3czplbGFzdGljbG9hZGJhbGFuY2luZzoqOio6dGFyZ2V0Z3JvdXAvKi8qJyxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpTZXRXZWJBY2wnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOk1vZGlmeUxpc3RlbmVyJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpBZGRMaXN0ZW5lckNlcnRpZmljYXRlcycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6UmVtb3ZlTGlzdGVuZXJDZXJ0aWZpY2F0ZXMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOk1vZGlmeVJ1bGUnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6ICcqJyxcbiAgfSxcbl07XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEF3c0xvYWRCYWxhbmNlUG9saWN5IHtcbiAgcHVibGljIHN0YXRpYyBhZGRQb2xpY3kodmVyc2lvbjogc3RyaW5nLCByb2xlOiBhbnkpIDphbnkge1xuICAgIGlmICh2ZXJzaW9uID09ICd2MScpIHtcbiAgICAgIHJvbGUuYWRkVG9Qb2xpY3kobmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoIGF3c0xvYWRCYWxhbmNlckNvbnRyb2xsZXJQb2xpY3lWMSApKTtcbiAgICAgIHJldHVybiByb2xlO1xuICAgIH0gaWYgKHZlcnNpb24gPT0gJ3YyJykge1xuICAgICAgYXdzTG9hZEJhbGFuY2VyQ29udHJvbGxlclBvbGljeVYyLmZvckVhY2goZWxlbWVudCA9PiB7XG4gICAgICAgIHJvbGUuYWRkVG9Qb2xpY3koaWFtLlBvbGljeVN0YXRlbWVudC5mcm9tSnNvbihlbGVtZW50KSk7XG4gICAgICB9KTtcbiAgICAgIHJldHVybiByb2xlO1xuICAgIH1cbiAgfVxufTsiXX0=