import { Construct } from 'constructs';
import { EnvVar } from './envvar-ins';
/**
 *
 */
export interface AlbIngressControllerOptions {
    /**
     * Extra labels to associate with resources.
     *
     * @default - none
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * Default Namespace for alb-ingress-controller.
     *
     * @default - kube-system
     */
    readonly namespace?: string;
    /**
     * Kubernetes Cluster Name for alb-ingress-controller.
     *
     * @default - None
     */
    readonly clusterName: string;
    /**
     * Default Service Account Name for alb-ingress-controller.
     *
     * @default - alb-ingress-controller
     */
    readonly serviceAccountName?: string;
    /**
     * Default image for alb-ingress-controller.
     *
     * @default - docker.io/amazon/aws-alb-ingress-controller:v1.1.9
     */
    readonly image?: string;
    /**
     * Another Args for alb-ingress-controller.
     *
     * @default - None
     */
    readonly args?: string[];
    /**
     * Another Args for alb-ingress-controller.
     *
     * @default - None
     */
    readonly env?: EnvVar[];
    /**
     * Replicas for alb-ingress-controller.
     *
     * @default - 1
     */
    readonly replicas?: number;
}
/**
 * Generate alb-ingress-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-alb-ingress-controller/blob/master/docs/examples
 */
export declare class AlbIngressController extends Construct {
    /**
     * Service Account Name for alb-ingress-controller.
     */
    readonly serviceAccountName: string;
    /**
     * Kubernetes Cluster Name for alb-ingress-controller.
     */
    readonly clusterName: string;
    /**
     * Kubernetes Deployment Name for alb-ingress-controller.
     */
    readonly deploymentName: string;
    /**
     * Namespace for alb-ingress-controller.
     *
     * @default - kube-system
     */
    readonly namespace: string;
    /**
     *
     */
    constructor(scope: Construct, id: string, options: AlbIngressControllerOptions);
    private argsFunc;
    private envFunc;
}
