# Generated by Django 3.0.9 on 2021-05-19 13:16

import django.db.models.deletion
from django.db import migrations, models

import solid_backend.media_object.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="MediaObject",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "dzi_option",
                    models.BooleanField(default=False, verbose_name="Deep Zoom option"),
                ),
                (
                    "dzi_file",
                    models.FileField(
                        editable=False,
                        null=True,
                        max_length=200,
                        upload_to="",
                        verbose_name="Deep Zoom file",
                    ),
                ),
                ("object_id", models.PositiveIntegerField(default=0)),
                (
                    "profile_position",
                    models.PositiveSmallIntegerField(blank=True, null=True),
                ),
                (
                    "media_format",
                    models.CharField(
                        choices=[
                            ("image", "image"),
                            ("audio", "audio"),
                            ("video", "video"),
                        ],
                        max_length=5,
                        verbose_name="media format",
                    ),
                ),
                (
                    "file",
                    solid_backend.media_object.models.MediaObjectField(
                        db_index=True,
                        height_field="img_original_height",
                        upload_to="media_object/",
                        width_field="img_original_width",
                    ),
                ),
                (
                    "img_original_width",
                    models.PositiveSmallIntegerField(
                        blank=True, editable=False, null=True, verbose_name="img width"
                    ),
                ),
                (
                    "img_original_height",
                    models.PositiveSmallIntegerField(
                        blank=True, editable=False, null=True, verbose_name="img height"
                    ),
                ),
                (
                    "img_original_scale",
                    models.FloatField(blank=True, null=True, verbose_name="scale"),
                ),
                (
                    "img_alt",
                    models.CharField(
                        blank=True,
                        max_length=200,
                        null=True,
                        verbose_name="alternative text",
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        default="",
                        null=True,
                        verbose_name="description (Markdown)",
                    ),
                ),
                ("audio", models.FileField(blank=True, null=True, upload_to="audio/")),
                (
                    "title",
                    models.CharField(
                        blank=True,
                        max_length=200,
                        null=True,
                        verbose_name="title of image/audio/video file",
                    ),
                ),
                (
                    "date",
                    models.DateField(
                        blank=True, help_text="Date of creation", null=True
                    ),
                ),
                ("author", models.CharField(blank=True, default="", max_length=100)),
                ("license", models.CharField(blank=True, default="", max_length=100)),
                (
                    "content_type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.ContentType",
                    ),
                ),
            ],
        ),
    ]
